/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;

public class IndexLifecycleManager
implements IResourceLifecycleManager<IIndex>,
ILifeCycleComponent {
    private static final long DEFAULT_MEMORY_BUDGET = 0x6400000L;
    private final Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private final long memoryBudget;
    private long memoryUsed;

    public IndexLifecycleManager() {
        this(0x6400000L);
    }

    public IndexLifecycleManager(long memoryBudget) {
        this.memoryBudget = memoryBudget;
        this.memoryUsed = 0L;
    }

    public List<IIndex> getOpenResources() {
        ArrayList<IIndex> openIndexes = new ArrayList<IIndex>();
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            openIndexes.add(i.index);
        }
        return openIndexes;
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream outputStream) throws IOException {
        if (dumpState) {
            this.dumpState(outputStream);
        }
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            i.index.deactivate();
        }
    }

    public void dumpState(OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Memory budget = %d\n", this.memoryBudget));
        sb.append(String.format("Memory used = %d\n", this.memoryUsed));
        String headerFormat = "%-20s %-10s %-20s %-20s %-20s\n";
        String rowFormat = "%-20d %-10b %-20d %-20s %-20s\n";
        sb.append(String.format(headerFormat, "ResourceName", "Open", "Reference Count", "Last Access", "Index Name"));
        for (Map.Entry<String, IndexInfo> entry : this.indexInfos.entrySet()) {
            IndexInfo ii = entry.getValue();
            sb.append(String.format(rowFormat, entry.getKey(), ii.isOpen, ii.referenceCount, ii.lastAccess, ii.index));
        }
        os.write(sb.toString().getBytes());
    }

    public void register(String resourcePath, IIndex index) throws HyracksDataException {
        if (this.indexInfos.containsKey(resourcePath)) {
            throw new HyracksDataException("Index with resource name " + resourcePath + " already exists.");
        }
        this.indexInfos.put(resourcePath, new IndexInfo(index));
    }

    public void open(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw new HyracksDataException("Failed to open index with resource name " + resourcePath + " since it does not exist.");
        }
        if (!info.isOpen) {
            info.index.activate();
            info.isOpen = true;
        }
        info.touch();
    }

    public void close(String resourcePath) throws HyracksDataException {
        this.indexInfos.get(resourcePath).untouch();
    }

    public IIndex get(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        return info == null ? null : info.index;
    }

    public void unregister(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.INDEX_DOES_NOT_EXIST, (Serializable[])new Serializable[]{resourcePath});
        }
        if (info.referenceCount != 0) {
            this.indexInfos.put(resourcePath, info);
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DROP_IN_USE_INDEX, (Serializable[])new Serializable[]{resourcePath});
        }
        if (info.isOpen) {
            info.index.deactivate();
        }
        this.indexInfos.remove(resourcePath);
    }

    private class IndexInfo
    implements Comparable<IndexInfo> {
        private final IIndex index;
        private int referenceCount;
        private long lastAccess;
        private boolean isOpen;

        public IndexInfo(IIndex index) {
            this.index = index;
            this.lastAccess = -1L;
            this.referenceCount = 0;
            this.isOpen = false;
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
            ++this.referenceCount;
        }

        public void untouch() {
            this.lastAccess = System.currentTimeMillis();
            --this.referenceCount;
        }

        @Override
        public int compareTo(IndexInfo i) {
            if (this.isOpen && !i.isOpen) {
                return -1;
            }
            if (!this.isOpen && i.isOpen) {
                return 1;
            }
            if (this.referenceCount < i.referenceCount) {
                return -1;
            }
            if (this.referenceCount > i.referenceCount) {
                return 1;
            }
            if (this.lastAccess < i.lastAccess) {
                return -1;
            }
            if (this.lastAccess > i.lastAccess) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "{index: " + this.index + ", isOpen: " + this.isOpen + ", refCount: " + this.referenceCount + ", lastAccess: " + this.lastAccess + "}";
        }
    }
}

