/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetIntersectionDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = () -> new GetIntersectionDescriptor();

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.GET_INTERSECTION;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                IHyracksTaskContext hyracksTaskContext = ctx.getTaskContext();
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final IPointable inputArg0 = new VoidPointable();
                    private final IPointable inputArg1 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final AMutableRectangle aRectangle;
                    private final AMutablePoint[] aPoint;
                    private final ISerializerDeserializer<ARectangle> rectangleSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.aRectangle = new AMutableRectangle((APoint)new AMutablePoint(0.0, 0.0), (APoint)new AMutablePoint(0.0, 0.0));
                        this.aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
                        this.rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1)) {
                            return;
                        }
                        byte[] bytes0 = this.inputArg0.getByteArray();
                        byte[] bytes1 = this.inputArg1.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int offset1 = this.inputArg1.getStartOffset();
                        ATypeTag tag0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        ATypeTag tag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        if (tag0 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(GetIntersectionDescriptor.this.sourceLoc, GetIntersectionDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        if (tag1 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(GetIntersectionDescriptor.this.sourceLoc, GetIntersectionDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        double ax1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double ay1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double ax2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double ay2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        double bx1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double by1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double bx2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double by2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        double ix1 = Math.max(ax1, bx1);
                        double iy1 = Math.max(ay1, by1);
                        double ix2 = Math.min(ax2, bx2);
                        double iy2 = Math.min(ay2, by2);
                        if (ix1 < ix2 && iy1 < iy2) {
                            this.aPoint[0].setValue(ix1, iy1);
                            this.aPoint[1].setValue(ix2, iy2);
                        } else {
                            this.aPoint[0].setValue(0.0, 0.0);
                            this.aPoint[1].setValue(0.0, 0.0);
                        }
                        this.aRectangle.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
                        this.resultStorage.reset();
                        this.rectangleSerde.serialize((Object)this.aRectangle, this.resultStorage.getDataOutput());
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

