/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.connectors.MToOneSequentialMergingConnectorDescriptor;

public class SequentialMergeExchangePOperator
extends AbstractExchangePOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.SEQUENTIAL_MERGE_EXCHANGE;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector requiredByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements();
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator childOp = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        List<ILocalStructuralProperty> childLocalProps = childOp.getDeliveredPhysicalProperties().getLocalProperties();
        IPartitioningProperty childPartitioning = childOp.getDeliveredPhysicalProperties().getPartitioningProperty();
        ArrayList<ILocalStructuralProperty> outputLocalProp = new ArrayList<ILocalStructuralProperty>(0);
        if (childLocalProps != null && !childLocalProps.isEmpty() && childPartitioning != null && childPartitioning.getPartitioningType() == IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED) {
            this.propagateChildProperties((OrderedPartitionedProperty)childPartitioning, childLocalProps, outputLocalProp);
        }
        this.deliveredProperties = new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, outputLocalProp);
    }

    @Override
    public Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> createConnectorDescriptor(IConnectorDescriptorRegistry spec, ILogicalOperator op, IOperatorSchema opSchema, JobGenContext context) {
        MToOneSequentialMergingConnectorDescriptor connector = new MToOneSequentialMergingConnectorDescriptor(spec);
        return new Pair((Object)connector, (Object)IHyracksJobBuilder.TargetConstraint.ONE);
    }

    private void propagateChildProperties(OrderedPartitionedProperty childPartitioning, List<ILocalStructuralProperty> childLocalProps, List<ILocalStructuralProperty> outputLocalProp) {
        ILocalStructuralProperty childLocalProp = childLocalProps.get(0);
        if (childLocalProp.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
            OrderColumn localOrderColumn;
            ArrayList<OrderColumn> outputOrderColumns = new ArrayList<OrderColumn>();
            List globalOrderColumns = childPartitioning.getOrderColumns();
            List<OrderColumn> localOrderColumns = ((LocalOrderProperty)childLocalProp).getOrderColumns();
            for (int i = 0; i < localOrderColumns.size() && i < globalOrderColumns.size() && (localOrderColumn = localOrderColumns.get(i)).equals(globalOrderColumns.get(i)); ++i) {
                outputOrderColumns.add(localOrderColumn);
            }
            if (!outputOrderColumns.isEmpty()) {
                outputLocalProp.add(new LocalOrderProperty(outputOrderColumns));
            }
        }
    }
}

