/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class Projection
extends AbstractClause {
    private Kind kind;
    private Expression expr;
    private String name;

    public Projection(Kind kind, Expression expr, String name) {
        Projection.validateKind(kind, expr, name);
        this.kind = kind;
        this.expr = expr;
        this.name = name;
    }

    private static void validateKind(Kind kind, Expression expr, String name) {
        switch (kind) {
            case NAMED_EXPR: {
                if (expr != null) break;
                throw new NullPointerException();
            }
            case STAR: 
            case EVERY_VAR_STAR: {
                if (expr == null && name == null) break;
                throw new IllegalArgumentException();
            }
            case VAR_STAR: {
                if (expr == null) {
                    throw new NullPointerException();
                }
                if (name == null) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Deprecated
    public Projection(Expression expr, String name, boolean star, boolean varStar) {
        this(Projection.asKind(star, varStar), expr, name);
    }

    @Deprecated
    private static Kind asKind(boolean star, boolean varStar) {
        return star ? Kind.STAR : (varStar ? Kind.VAR_STAR : Kind.NAMED_EXPR);
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.PROJECTION;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public boolean hasExpression() {
        return this.expr != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Deprecated
    public boolean star() {
        return this.kind == Kind.STAR;
    }

    @Deprecated
    public boolean varStar() {
        return this.kind == Kind.VAR_STAR;
    }

    public String toString() {
        switch (this.kind) {
            case NAMED_EXPR: {
                return this.expr + (String)(this.hasName() ? " as " + this.getName() : "");
            }
            case STAR: {
                return "*";
            }
            case VAR_STAR: {
                return this.expr + ".*";
            }
            case EVERY_VAR_STAR: {
                return "*.*";
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.expr, this.name});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Projection)) {
            return false;
        }
        Projection target = (Projection)((Object)object);
        return this.kind == target.kind && Objects.equals(this.expr, target.expr) && Objects.equals(this.name, target.name);
    }

    public static enum Kind {
        NAMED_EXPR,
        STAR,
        VAR_STAR,
        EVERY_VAR_STAR;

    }
}

