/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.pushdown.ExpectedSchemaBuilder;
import org.apache.asterix.optimizer.rules.pushdown.ExpressionValueAccessPushdownVisitor;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class OperatorValueAccessPushdownVisitor
implements ILogicalOperatorVisitor<Void, Void> {
    private final IOptimizationContext context;
    private final ExpectedSchemaBuilder builder;
    private final ExpressionValueAccessPushdownVisitor pushdownVisitor;
    private final Map<LogicalVariable, DataSourceScanOperator> registeredDatasets;
    private final Set<ILogicalOperator> visitedOperators;

    public OperatorValueAccessPushdownVisitor(IOptimizationContext context) {
        this.context = context;
        this.builder = new ExpectedSchemaBuilder();
        this.registeredDatasets = new HashMap<LogicalVariable, DataSourceScanOperator>();
        this.pushdownVisitor = new ExpressionValueAccessPushdownVisitor(this.builder);
        this.visitedOperators = new HashSet<ILogicalOperator>();
    }

    public void finish() {
        for (Map.Entry<LogicalVariable, DataSourceScanOperator> scan : this.registeredDatasets.entrySet()) {
            scan.getValue().setProjectionInfo((IProjectionInfo)this.builder.createProjectionInfo(scan.getKey()));
        }
    }

    private void visitInputs(ILogicalOperator op, List<LogicalVariable> producedVariables) throws AlgebricksException {
        if (this.visitedOperators.contains(op)) {
            return;
        }
        for (Mutable child : op.getInputs()) {
            ((ILogicalOperator)child.getValue()).accept((ILogicalOperatorVisitor)this, null);
        }
        this.visitedOperators.add(op);
        this.pushdownVisitor.init(producedVariables);
        op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.pushdownVisitor);
        this.pushdownVisitor.end();
    }

    public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        if (op.getVariables().isEmpty()) {
            this.setEmptyRecord((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
        }
        return null;
    }

    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        LogicalVariable recordVar;
        this.visitInputs((ILogicalOperator)op);
        DatasetDataSource datasetDataSource = this.getDatasetDataSourceIfApplicable(op);
        if (datasetDataSource != null && !this.builder.isVariableRegistered(recordVar = datasetDataSource.getDataRecordVariable(op.getVariables()))) {
            this.builder.registerDataset(recordVar, RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE);
            this.registeredDatasets.put(recordVar, op);
        }
        return null;
    }

    public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        if (!op.isGlobal() && this.isCountConstant(op.getExpressions())) {
            this.setEmptyRecord((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
        }
        return null;
    }

    private DatasetDataSource getDatasetDataSourceIfApplicable(DataSourceScanOperator scan) throws AlgebricksException {
        String datasetName;
        DataverseName dataverse;
        DataSource dataSource = (DataSource)scan.getDataSource();
        if (dataSource == null) {
            return null;
        }
        MetadataProvider mp = (MetadataProvider)this.context.getMetadataProvider();
        Dataset dataset = mp.findDataset(dataverse = dataSource.getId().getDataverseName(), datasetName = dataSource.getId().getDatasourceName());
        if (dataset == null || dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL || dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && !ExternalDataUtils.supportsPushdown((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties())) {
            return null;
        }
        return (DatasetDataSource)dataSource;
    }

    private void setEmptyRecord(ILogicalOperator inputOp) throws AlgebricksException {
        DataSourceScanOperator scan;
        DatasetDataSource datasetDataSource;
        if (inputOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN && (datasetDataSource = this.getDatasetDataSourceIfApplicable(scan = (DataSourceScanOperator)inputOp)) != null) {
            LogicalVariable recordVar = datasetDataSource.getDataRecordVariable(scan.getVariables());
            this.builder.registerDataset(recordVar, RootExpectedSchemaNode.EMPTY_ROOT_NODE);
        }
    }

    private boolean isCountConstant(List<Mutable<ILogicalExpression>> expressions) {
        if (expressions.size() != 1) {
            return false;
        }
        ILogicalExpression expression = (ILogicalExpression)expressions.get(0).getValue();
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        return BuiltinFunctions.SQL_COUNT.equals((Object)fid) && ((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT;
    }

    private void visitSubplans(List<ILogicalPlan> nestedPlans) throws AlgebricksException {
        for (ILogicalPlan plan : nestedPlans) {
            for (Mutable root : plan.getRoots()) {
                this.visitInputs((ILogicalOperator)root.getValue());
            }
        }
    }

    public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        return null;
    }

    public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.visitSubplans(op.getNestedPlans());
        return null;
    }

    public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        return null;
    }

    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return null;
    }

    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.visitSubplans(op.getNestedPlans());
        return null;
    }

    public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.visitSubplans(op.getNestedPlans());
        return null;
    }

    private void visitInputs(ILogicalOperator op) throws AlgebricksException {
        this.visitInputs(op, null);
    }
}

