/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class AListMultiListArgsTypeComputer
extends AbstractResultTypeComputer {
    public static final AListMultiListArgsTypeComputer INSTANCE = new AListMultiListArgsTypeComputer();

    private AListMultiListArgsTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        if (strippedInputTypes.length < 2) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(ErrorCode.COMPILATION_INVALID_NUM_OF_ARGS, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        IAType listType = strippedInputTypes[0];
        if (listType.getTypeTag().isListType()) {
            listType = DefaultOpenFieldType.getDefaultOpenFieldType(listType.getTypeTag());
            return AUnionType.createUnknownableType(listType);
        }
        return BuiltinType.ANY;
    }
}

