/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class ADateTime
implements IAObject {
    protected long chrononTime;

    public ADateTime(long chrononTime) {
        this.chrononTime = chrononTime;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ADATETIME;
    }

    public int compare(Object o) {
        if (!(o instanceof ADateTime)) {
            return -1;
        }
        ADateTime d = (ADateTime)o;
        if (this.chrononTime > d.chrononTime) {
            return 1;
        }
        if (this.chrononTime < d.chrononTime) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ADateTime)) {
            return false;
        }
        ADateTime t = (ADateTime)o;
        return t.chrononTime == this.chrononTime;
    }

    public int hashCode() {
        return (int)(this.chrononTime ^ this.chrononTime >>> 32);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        return ADateTime.appendDatetime(new StringBuilder().append("datetime: { "), this.chrononTime).append(" }").toString();
    }

    public String toSimpleString() {
        return ADateTime.appendDatetime(new StringBuilder(), this.chrononTime).toString();
    }

    private static StringBuilder appendDatetime(StringBuilder sbder, long chrononTime) {
        try {
            GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(chrononTime, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.MILLISECOND, true);
            return sbder;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getChrononTime() {
        return this.chrononTime;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("ADateTime", this.chrononTime);
        return json;
    }
}

