/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.asterix.api.http.server.NodeControllerDetailsApiServlet;
import org.apache.asterix.api.http.server.NodeControllerDetailsHelper;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiagnosticsApiServlet
extends NodeControllerDetailsApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IHyracksClientConnection hcc;
    protected final ExecutorService executor;

    public DiagnosticsApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(appCtx, ctx, paths);
        this.hcc = (IHyracksClientConnection)ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        this.executor = (ExecutorService)ctx.get("org.apache.asterix.EXECUTOR_SERVICE");
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter responseWriter = response.writer();
        response.setStatus(HttpResponseStatus.OK);
        try {
            if (!"".equals(this.localPath(request))) {
                throw new IllegalArgumentException();
            }
            JSONUtil.writeNode((Writer)responseWriter, (JsonNode)this.getClusterDiagnosticsJSON());
        }
        catch (IllegalStateException e) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (RejectedExecutionException e) {
            LOGGER.info("RejectedExecutionException while servicing request; returning 503", (Throwable)e);
            this.sendError(response, HttpResponseStatus.SERVICE_UNAVAILABLE, null);
        }
        catch (Exception e) {
            LOGGER.warn("exception while servicing request; returning 500", (Throwable)e);
            this.sendError(response, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.toString());
        }
        responseWriter.flush();
    }

    protected ObjectNode getClusterDiagnosticsJSON() throws Exception {
        Map<String, Future<JsonNode>> ccFutureData = this.getCcDiagosticsFutures();
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        HashMap<String, Map<String, Future<JsonNode>>> ncDataMap = new HashMap<String, Map<String, Future<JsonNode>>>();
        for (String nc : csm.getParticipantNodes()) {
            ncDataMap.put(nc, this.getNcDiagnosticFutures(nc));
        }
        ObjectNode result = OBJECT_MAPPER.createObjectNode();
        if (!ccFutureData.isEmpty()) {
            result.putPOJO("cc", this.resolveFutures(ccFutureData));
        }
        ArrayList<Map<String, JsonNode>> ncList = new ArrayList<Map<String, JsonNode>>();
        for (Map.Entry entry : ncDataMap.entrySet()) {
            Map<String, JsonNode> ncMap = this.resolveFutures((Map)entry.getValue());
            ncMap.put("node_id", (JsonNode)new TextNode((String)entry.getKey()));
            ncList.add(ncMap);
        }
        result.putPOJO("ncs", ncList);
        result.put("date", String.valueOf(new Date()));
        return result;
    }

    protected Map<String, Future<JsonNode>> getNcDiagnosticFutures(String nc) {
        HashMap<String, Future<JsonNode>> ncData = new HashMap<String, Future<JsonNode>>();
        ncData.put("threaddump", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys((ObjectNode)OBJECT_MAPPER.readTree(this.processThreadDump(nc)))));
        ncData.put("config", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys((ObjectNode)OBJECT_MAPPER.readTree(this.processNodeDetails(nc, false, true)))));
        ncData.put("stats", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys(this.processNodeStats(this.hcc, nc))));
        return ncData;
    }

    protected Map<String, Future<JsonNode>> getCcDiagosticsFutures() {
        HashMap<String, Future<JsonNode>> ccFutureData = new HashMap<String, Future<JsonNode>>();
        ccFutureData.put("threaddump", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys((ObjectNode)OBJECT_MAPPER.readTree(this.processThreadDump(null)))));
        ccFutureData.put("config", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys((ObjectNode)OBJECT_MAPPER.readTree(this.processNodeDetails(null, false, true)))));
        ccFutureData.put("stats", this.executor.submit(() -> NodeControllerDetailsHelper.fixupKeys((ObjectNode)OBJECT_MAPPER.readTree(this.processNodeDetails(null, true, false)))));
        return ccFutureData;
    }

    protected Map<String, JsonNode> resolveFutures(Map<String, Future<JsonNode>> futureMap) throws InterruptedException {
        HashMap<String, JsonNode> result = new HashMap<String, JsonNode>();
        DiagnosticsApiServlet.resolveFutures(futureMap, result, result);
        return result;
    }

    public static void resolveFutures(Map<String, Future<JsonNode>> futureMap, Map<String, JsonNode> outputMap, Map<String, JsonNode> errorMap) throws InterruptedException {
        for (Map.Entry<String, Future<JsonNode>> entry : futureMap.entrySet()) {
            try {
                outputMap.put(entry.getKey(), entry.getValue().get());
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.WARN, "unexpected exception obtaining value for " + entry.getKey(), (Throwable)e);
                errorMap.put(entry.getKey(), (JsonNode)new TextNode(String.valueOf(e)));
            }
        }
    }

    protected String processNodeDetails(String node, boolean includeStats, boolean includeConfig) throws Exception {
        return this.checkNullDetail(node, this.hcc.getNodeDetailsJSON(node, includeStats, includeConfig));
    }

    protected String processThreadDump(String node) throws Exception {
        return this.checkNullDetail(node, this.hcc.getThreadDump(node));
    }
}

