/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class InlineUnnestFunctionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        if (op1.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnestOperator = (UnnestOperator)op1;
        AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)unnestOperator.getExpressionRef().getValue();
        if (expr.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return false;
        }
        List args = expr.getArguments();
        boolean changed = false;
        for (int i = 0; i < args.size(); ++i) {
            ILogicalExpression argExpr = (ILogicalExpression)((Mutable)args.get(i)).getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)argExpr;
            changed |= this.inlineVariable(varExpr.getVariableReference(), unnestOperator);
        }
        return changed;
    }

    private boolean inlineVariable(LogicalVariable usedVar, UnnestOperator unnestOp) throws AlgebricksException {
        AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)unnestOp.getExpressionRef().getValue();
        ArrayList<Pair<AbstractFunctionCallExpression, Integer>> parentAndIndexList = new ArrayList<Pair<AbstractFunctionCallExpression, Integer>>();
        this.getParentFunctionExpression(usedVar, expr, parentAndIndexList);
        ILogicalExpression usedVarOrginExpr = this.findUsedVarOrigin(usedVar, (AbstractLogicalOperator)unnestOp, (AbstractLogicalOperator)((Mutable)unnestOp.getInputs().get(0)).getValue());
        if (usedVarOrginExpr != null) {
            for (Pair pair : parentAndIndexList) {
                if (((AbstractFunctionCallExpression)pair.first).getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION || pair.first != expr) continue;
                unnestOp.getExpressionRef().setValue((Object)usedVarOrginExpr);
            }
            return true;
        }
        return false;
    }

    private void getParentFunctionExpression(LogicalVariable usedVar, AbstractFunctionCallExpression funcExpr, List<Pair<AbstractFunctionCallExpression, Integer>> parentAndIndexList) {
        List args = funcExpr.getArguments();
        for (int i = 0; i < args.size(); ++i) {
            VariableReferenceExpression varExpr;
            ILogicalExpression argExpr = (ILogicalExpression)((Mutable)args.get(i)).getValue();
            if (argExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE && (varExpr = (VariableReferenceExpression)argExpr).getVariableReference().equals((Object)usedVar)) {
                parentAndIndexList.add((Pair<AbstractFunctionCallExpression, Integer>)new Pair((Object)funcExpr, (Object)i));
            }
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            this.getParentFunctionExpression(usedVar, (AbstractFunctionCallExpression)argExpr, parentAndIndexList);
        }
    }

    private ILogicalExpression findUsedVarOrigin(LogicalVariable usedVar, AbstractLogicalOperator parentOp, AbstractLogicalOperator currentOp) throws AlgebricksException {
        ILogicalExpression ret;
        block3: {
            block2: {
                VariableReferenceExpression varExpr;
                LogicalVariable var;
                ILogicalExpression finalExpr;
                ILogicalExpression returnedExpr;
                int index;
                AssignOperator assignOp;
                block4: {
                    ret = null;
                    if (currentOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) break block2;
                    ArrayList producedVars = new ArrayList();
                    VariableUtilities.getProducedVariables((ILogicalOperator)currentOp, producedVars);
                    if (!producedVars.contains(usedVar)) break block3;
                    assignOp = (AssignOperator)currentOp;
                    index = assignOp.getVariables().indexOf(usedVar);
                    returnedExpr = (ILogicalExpression)((Mutable)assignOp.getExpressions().get(index)).getValue();
                    if (returnedExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break block4;
                    AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)returnedExpr;
                    if (BuiltinFunctions.isBuiltinUnnestingFunction((FunctionIdentifier)funcExpr.getFunctionIdentifier())) {
                        this.removeUnecessaryAssign(parentOp, currentOp, assignOp, index);
                        ret = returnedExpr;
                    }
                    break block3;
                }
                if (returnedExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE || (finalExpr = this.findUsedVarOrigin(var = (varExpr = (VariableReferenceExpression)returnedExpr).getVariableReference(), currentOp, (AbstractLogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue())) == null) break block3;
                this.removeUnecessaryAssign(parentOp, currentOp, assignOp, index);
                ret = finalExpr;
                break block3;
            }
            for (Mutable child : currentOp.getInputs()) {
                ILogicalExpression expr = this.findUsedVarOrigin(usedVar, currentOp, (AbstractLogicalOperator)child.getValue());
                if (expr == null) continue;
                ret = expr;
            }
        }
        return ret;
    }

    private void removeUnecessaryAssign(AbstractLogicalOperator parentOp, AbstractLogicalOperator currentOp, AssignOperator assignOp, int index) {
        assignOp.getVariables().remove(index);
        assignOp.getExpressions().remove(index);
        if (assignOp.getVariables().size() == 0) {
            int opIndex = parentOp.getInputs().indexOf(new MutableObject((Object)currentOp));
            ((Mutable)parentOp.getInputs().get(opIndex)).setValue(((Mutable)assignOp.getInputs().get(0)).getValue());
        }
    }
}

