/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;

public final class StringReplacer {
    private final UTF8StringBuilder resultBuilder = new UTF8StringBuilder();
    private final GrowableArray resultArray = new GrowableArray();
    private final int resultArrayInitLength;

    public StringReplacer() throws HyracksDataException {
        try {
            this.resultArray.getDataOutput().writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.resultArrayInitLength = this.resultArray.getLength();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public boolean findAndReplace(UTF8StringPointable input, UTF8StringPointable search, UTF8StringPointable replace, int limit) throws HyracksDataException {
        try {
            this.resultArray.setSize(this.resultArrayInitLength);
            return input.findAndReplace(search, replace, limit, this.resultBuilder, this.resultArray);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void assignResult(IPointable resultPointable) {
        resultPointable.set(this.resultArray.getByteArray(), 0, this.resultArray.getLength());
    }
}

