/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.protobuf.BufferOutputStream;
import org.apache.activemq.protobuf.CodedOutputStream;
import org.apache.activemq.protobuf.InvalidProtocolBufferException;
import org.apache.activemq.protobuf.MessageBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageBufferSupport {
    public static final String FORZEN_ERROR_MESSAGE = "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";

    public static Buffer toUnframedBuffer(MessageBuffer message) {
        try {
            int size = message.serializedSizeUnframed();
            BufferOutputStream baos = new BufferOutputStream(size);
            CodedOutputStream output = new CodedOutputStream(baos);
            message.writeUnframed(output);
            Buffer rc = baos.toBuffer();
            assert (rc.length == size) : "Did not write as much data as expected.";
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static Buffer toFramedBuffer(MessageBuffer message) {
        try {
            int size = message.serializedSizeFramed();
            BufferOutputStream baos = new BufferOutputStream(size);
            CodedOutputStream output = new CodedOutputStream(baos);
            message.writeFramed(output);
            Buffer rc = baos.toBuffer();
            assert (rc.length == size) : "Did not write as much data as expected.";
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static void writeMessage(CodedOutputStream output, int tag, MessageBuffer message) throws IOException {
        output.writeTag(tag, 2);
        message.writeFramed(output);
    }

    public static int computeMessageSize(int tag, MessageBuffer message) {
        return CodedOutputStream.computeTagSize(tag) + message.serializedSizeFramed();
    }

    public static Buffer readFrame(InputStream input) throws IOException {
        int r;
        int length = MessageBufferSupport.readRawVarint32(input);
        byte[] data = new byte[length];
        for (int pos = 0; pos < length; pos += r) {
            r = input.read(data, pos, length - pos);
            if (r >= 0) continue;
            throw new InvalidProtocolBufferException("Input stream ended before a full message frame could be read.");
        }
        return new Buffer(data);
    }

    public static int readRawVarint32(InputStream is) throws IOException {
        byte tmp = MessageBufferSupport.readRawByte(is);
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = MessageBufferSupport.readRawByte(is);
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = MessageBufferSupport.readRawByte(is);
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = MessageBufferSupport.readRawByte(is);
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = MessageBufferSupport.readRawByte(is);
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i2 = 0; i2 < 5; ++i2) {
                            if (MessageBufferSupport.readRawByte(is) < 0) continue;
                            return result;
                        }
                        throw new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    public static byte readRawByte(InputStream is) throws IOException {
        int rc = is.read();
        if (rc == -1) {
            throw new InvalidProtocolBufferException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either than the input has been truncated or that an embedded message misreported its own length.");
        }
        return (byte)rc;
    }

    public static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            list.addAll(collection);
        } else {
            for (T value : values) {
                list.add(value);
            }
        }
    }
}

