/* symlink/stdio.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _SYMLINK_STDIO_H
#define _SYMLINK_STDIO_H


#include <symlink/cdefs.h>

#include <stdio.h>


__BEGIN_DECLS

FILE *symlink_fopen __PROTO ((const char *name, const char *flags));
FILE *symlink_freopen __PROTO ((const char *name, const char *flags, FILE *stream));
int symlink_rename __PROTO ((const char *old, const char *new));
int symlink_remove __PROTO ((const char *name));
int symlink_unlink __PROTO ((const char *name));

__END_DECLS


#ifdef USE_SYMLINK_STDIO

#undef fopen
#undef freopen

#define fopen		symlink_fopen
#define freopen		symlink_freopen

#ifndef __OPTIMIZE__

#undef rename
#undef remove
#undef unlink

#define rename		symlink_rename
#define remove		symlink_remove
#define unlink		symlink_unlink

#endif /* not __OPTIMIZE__ */

#endif /* USE_SYMLINK_STDIO */


#endif /* not _SYMLINK_STDIO_H */
