/*
 * Decompiled with CFR 0.152.
 */
package pdbf.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import pdbf.json.PDBFelement;

public class PDBFelementTypeAdapter
implements JsonSerializer<PDBFelement>,
JsonDeserializer<PDBFelement> {
    private static final String CLASSNAME = "C";
    private static final String INSTANCE = "I";

    @Override
    public JsonElement serialize(PDBFelement src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject retValue = new JsonObject();
        String className = src.getClass().getCanonicalName();
        retValue.addProperty(CLASSNAME, className);
        JsonElement elem = context.serialize(src);
        retValue.add(INSTANCE, elem);
        return retValue;
    }

    @Override
    public PDBFelement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get(CLASSNAME);
        String className = prim.getAsString();
        Class<?> klass = null;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new JsonParseException(e.getMessage());
        }
        return (PDBFelement)context.deserialize(jsonObject.get(INSTANCE), klass);
    }
}

