%{
/* doc2tex.l					06 Oct 90
 *---------------------------------------------------------
 * (c) 1990 by J.Schrod.  
 *     Copyright conditions: GNU General Public License
 */

/*
 *       VERSION HISTORY
 *
 * DATE     REMARK
 * 90-10-06 mentioned filelist WEBWARE for LISTSERV in Heidelberg,
 *	    added tuglib
 * 90-01-14 june.cs.washington.edu instead of cs.washington.edu
 * 90-01-20 first version
 */

%}

%S PREAMBLE COMMENT COPY


%{
#include <ctype.h>
void hint_to_makeprog();
%}


%%

%{
#ifdef MSDOS
                check_yycrank(); /* this should go into ncform... */
#endif
                BEGIN PREAMBLE;
%}


^\ *\n          putc('\n', yyout);


<PREAMBLE>^%.*\n ECHO;
<PREAMBLE>^.    {
                hint_to_makeprog();
		unput(yytext[0]);  NLSTATE;
		BEGIN COMMENT;
		}

<COMMENT>^\\beginprog.*\n {
                fputs("%%% ", yyout);  ECHO;
		BEGIN COPY;
		}
<COMMENT>^.*\n  {
                fputs("%%% ", yyout);  ECHO;
		}

<COPY>^\\endprog.*\n {
                fputs("%%% ", yyout);  ECHO;
		BEGIN COMMENT;
		}
<COPY>^%%%.*\n  {
                fputs("%%% ", yyout);  ECHO;
                fprintf(stderr, "Macro code changed at line %d\n", yylineno-1);
		}
<COPY>^.*\n     ECHO;


.|\n            {
                register char c = yytext[0];
                fprintf(stderr, 
		      "! Illegal state at char %c (\"%02x) in line %d\n",
		      ( isprint(c)  ?  c : ' ' ), 
		      (unsigned char)c,
		      ( c == '\n'  ?  yylineno-1 : yylineno )
		      );
                }


%%

void hint_to_makeprog()
{
   fputs("%%%%\n",yyout);
   fputs("%%%%\n",yyout);
   fputs(
      "%%%% These TeX macros were documented with the documentation system\n",
      yyout);
   fputs(
      "%%%% MAKEPROG and automatically converted to the current form.\n",
      yyout);
   fputs(
      "%%%% If you have MAKEPROG available you may transform it back to\n",
      yyout);
   fputs(
      "%%%% the original input: Remove every occurence of three percents\n",
      yyout);
   fputs(
      "%%%% and one optional blank from the beginning of a line and remove\n",
      yyout);
   fputs(
      "%%%% every line which starts with four percents.  The following lex\n",
      yyout);
   fputs(
      "%%%% program will do this:\n",
      yyout);
   fputs("%%%%\n",yyout);
   fputs("%%%%    %%\n",yyout);
   fputs("%%%%\n",yyout);
   fputs("%%%%    ^%%%\\ ?   ;\n",yyout);
   fputs("%%%%    ^%%%%.*\\n ;\n",yyout);
   fputs("%%%%\n",yyout);
   fputs(
      "%%%% MAKEPROG may be obtained over the net from the Bitnet-Listserver\n",
      yyout);
   fputs(
    "%%%% LISTSERV@DHDURZ1 (filelist WEBWARE), from tuglib@science.utah.edu,\n",
      yyout);
   fputs("%%%% or via ftp from june.cs.washington.edu.\n", yyout);
   fputs("%%%%\n",yyout);
   fputs("%%%%\n",yyout);
   return;
}
