{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibPrint;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, wbibdisp, wbibabv1, WinProcs, WinTypes, strings, wbibedhy, wbibole,
{$ELSE}
  Dos, Objects, bibdisp,
{$ENDIF}
  bibstrg, bibfile, bibvars, bibutil, bibecond, bib8bit, lfnunit;

procedure PrintEntry(var dump: text; OutStrm: PStream; Entry: EntryRecPtr;
                     var fields: FieldArr; ExportFormat: byte;
                     Unix: boolean);

Implementation

const
  HyperStartChar=#1; HyperEndChar=#2;
  TildeChar     =#3;


procedure PrintEntry(var dump: text; OutStrm: PStream; Entry: EntryRecPtr;
                     var fields: FieldArr; ExportFormat: byte;
                     Unix: boolean);
{$IFDEF WINDOWS}
const
  SBufLen=$FFF0;
{$ENDIF}
var
  line,tmp: string;
  i,j,k,level,si,nbr,tx,ty,CharCase,etype,NewLines: integer;
  ch: char;
  Eval, LastEval,BfStatus,OBfStatus,Exists,FoundEnd: boolean;
  DoneCr,IsIgnored: boolean;
  Attrib: array[1..100] of integer;
  PrColor: byte;
  FileDrive: string[1];
  FilePath,FileName,FileExt: Pstring;
{$IFDEF WINDOWS}
  SBuf: PChar;
{$ENDIF}

procedure Wrt(S: string);
begin
  if OutStrm=Nil then write(dump,S)
  else if S<>'' then OutStrm^.write(S[1],length(S));
end;

procedure WrtLine(S: string; Unix: boolean);
var
  EOL: string[2];
begin
  if OutStrm=Nil then WriteLine(dump,S,Unix)
  else begin
    if S<>'' then OutStrm^.write(S[1],length(S));
    if Unix then EOL:=#10 else EOL:=#13#10;
    OutStrm^.write(EOL[1],length(EOL));
  end;
end;                { WrtLine }

procedure Cr(N: integer); forward;

procedure Boldface(SwitchOn: boolean);
begin
  if BfStatus=SwitchOn then Exit;
  if SwitchOn and (BoldfaceOn[ExportFormat]<>Nil) then
    wrt(BoldfaceOn[ExportFormat]^)
  else if (BoldfaceOff[ExportFormat]<>Nil) then
    wrt(BoldfaceOff[ExportFormat]^);
  BfStatus:=SwitchOn;
end;                 { Boldface }

procedure PrintColor(Color: byte);
begin
  if (Color=0) or (PrColor=Color) then Exit;
  if Color<=17 then
  begin
    if PrintColorStr^[ExportFormat,PrColor,2]<>Nil then
      wrt(PrintColorStr^[ExportFormat,PrColor,2]^);
    if PrintColorStr^[ExportFormat,Color,1]<>Nil then
      wrt(PrintColorStr^[ExportFormat,Color,1]^);
  end;
  PrColor:=Color;
end;                  { PrintColor }

procedure prchar(ch: char);
begin                               { prchar }
  if ch=#0 then exit;
  wrt(ch);
  Inc(tx);
  if tx>LineWidth[ExportFormat] then CR(0);
  NewLines:=0;
end;                                 { prchar }

{$IFDEF WINDOWS}
procedure pbig1(S: BigTypePtr; Slen: Word; KeepCase,HideBraces: boolean);
{$ELSE}
procedure pbig(S: BigTypePtr; Slen: Word; KeepCase,HideBraces: boolean);
{$ENDIF}
var
  ind,l,j,k,lline,j1,j2,EolInd: Word;
  icode,BrDepth,cr_jump: integer;
  i: longint;
  line,tmp: string;
  cut,beg,cr_find,ExtraBrace,Math,StrField: boolean;
{$IFDEF WINDOWS}
  NewS: PChar;
  SSize: Word;
{$ENDIF}
begin                               { pbig }
  WinYield;
  if (Slen=0) or ((Slen=1) and (S^[1]=EmptyFieldChar)) then Exit;

{$IFDEF WINDOWS}
  if (SLen>1) and (S^[1]='@') and ExpandMacros then    { Macro }
  begin
    NewS:=Nil;
    DecodeAbbrevs(S^[2],SLen-1,NewS,SLen,SSize);
    if NewS<>Nil then
    begin
      ExpandMacros:=false;
      PBig1(BigTypePtr(NewS),SLen,KeepCase,HideBraces);
      FreeMem(NewS,SSize);
      ExpandMacros:=true;
    end;
    Exit;
  end;
{$ENDIF}

  ind:=1; beg:=true;
  BrDepth:=0; ExtraBrace:=false; Math:=false;
  StrField:=(S^[1]='@');
  while ind<=slen do
  begin
    cut:=false; line:='';
    cr_jump:=0; cr_find:=false;
    { Skip leading spaces }
    if beg or (tx=1) then while (ind<=Slen) and (S^[ind]=' ') do Inc(Ind);
    { Add everything up to the maximal width }
    beg:=false;
    for i:=ind to imin(ind+LineWidth[ExportFormat]-tx,slen) do
      PStrCat(line,S^[i],LineWidth[ExportFormat]);
    if (ind+length(line)<=slen) and
         (length(line)=LineWidth[ExportFormat]+1-tx) and
                  (line[length(line)]<>' ') and  (S^[ind]<>' ') then
    begin
      i:=ChrPosR(line,' ',1);
      if i>0 then
      begin
        StrCut(line,i-1); cut:=true;
      end else if tx>1 then
      begin
        line:=''; cut:=true;
      end;
    end;

    { Look for CR }
    cr_jump:=0; cr_find:=false;
    EolInd:=0; k:=0;
    while EolDisplay and (EolInd=0) and (k<NEolStrings) do
    begin
      inc(k); j:=Pos(EolString[k]^,line);
      if j>0 then
      begin
        EolInd:=k; i:=j; j:=j+length(EolString[EolInd]^);
      end;
    end;
    if EolDisplay and (EolInd>0) and ((j>length(line)) or
           ((j<=length(line)) and (line[j] in [' ',lbrace,'[','\','~']))) then
    begin
      j2:=0;
      if (j>length(line)) or (line[j] in ['\','~']) then
      begin
        cr_find:=true;
        j2:=j-1;
      end else if line[j]=' ' then
      begin
        cr_find:=true;
        j2:=j; 
      end else if line[j]=lbrace then
      begin
        cr_find:=true;
        j2:=ChrPosX(line,rbrace,j+1);
        if j2>j+1 then
        begin
          icode:=0;
          val(Copy(line,j+1,j2-j-1),cr_jump,icode);
          if icode>0 then cr_jump:=0;
        end else if j2<j then j2:=j;
      end else if line[j]='[' then
      begin
        j2:=ChrPosX(line,']',j+1);
        if j2<j then j2:=j;
      end;
      ind:=ind+j2-i+1;
      if i=1 then line:=''
      else begin
        StrCut(line,i-1); cut:=true;
      end;
      ind:=ind+length(line);
      if (ind<slen) and (S^[ind]=' ') then inc(ind);
      ChrDelR(line,' ');
    end else if line<>'' then
    begin
      ind:=ind+length(line);
      if cut then inc(ind);
    end;
    if TildeToSpace then
      for i:=1 to length(line) do
        if (line[i]='~') and ((i=1) or (line[i-1]<>'\')) then line[i]:=' '
        else if line[i]=TildeChar then line[i]:='~';
    if not KeepCase then
    begin
      if CharCase=-2 then StrUpr(line)
      else if CharCase=-3 then StrLwr(line);
    end;
    if HideBraces and not StrField
          then StripBraces(line,BrDepth,ExtraBrace,Math);
    tx:=tx+length(line);
    { Expand any hyperlink color changes }
    tmp:='';
    if PrintColorStr^[ExportFormat,PrColor,2]<>Nil then
      tmp:=tmp+PrintColorStr^[ExportFormat,PrColor,2]^;
    if PrintColorStr^[ExportFormat,17,1]<>Nil then
      tmp:=tmp+PrintColorStr^[ExportFormat,17,1]^;
    StrRepl(line,HyperStartChar,tmp,1,255,255);
    tmp:='';
    if PrintColorStr^[ExportFormat,17,2]<>Nil then
      tmp:=tmp+PrintColorStr^[ExportFormat,17,2]^;
    if PrintColorStr^[ExportFormat,PrColor,1]<>Nil then
      tmp:=tmp+PrintColorStr^[ExportFormat,PrColor,1]^;
    StrRepl(line,HyperEndChar,tmp,1,255,255);
    { }
    wrt(line);
    if cr_find or (cr_jump>0) then CR(cr_Jump)
    else if cut then CR($7FFF)
    else if tx>LineWidth[ExportFormat] then CR($7FFF);
  end;
  NewLines:=0;
end;                                 { pbig }

{$IFDEF WINDOWS}
procedure Pbig(S: BigTypePtr; Slen: Word; KeepCase,HideBraces: boolean);
var
  i0,i1,i2,j,nbr,MaxPreLen: longint;
  StartArg,EndArg,StartDesc,EndDesc: longint;
  LType,HyperInd: integer;
  F: Pstring;
  P,P1: PChar;
  TermChar: char;
  CurColor: byte;
  BitInfo: ObjInfoPtr;

procedure CatPart(start,finish: longint; Separate: boolean);
var
  ch: Char;
  A: array[0..10] of char;
  i: longint;
begin
  if finish<start then Exit;
  if finish>Slen then finish:=Slen;
  if Separate or (ExpHyperFormat[ExportFormat]<>ExpHyper_HTML) then
  begin
    ch:=S^[finish+1]; S^[finish+1]:=#0;
    StrLCat(SBuf,PChar(@S^[Start]),SBufLen-1);
    S^[Finish+1]:=ch;
  end else     { Take care of special characters }
  begin
    for i:=Start to Finish do
    begin
      A[0]:=#0; A[1]:=#0;
      if S^[i]='<' then StrPCopy(A,'&lt;')
      else if S^[i]='>' then StrPCopy(A,'&gt;')
      else if S^[i]='"' then StrPCopy(A,'&quot;')
      else if S^[i]='&' then StrPCopy(A,'&amp;')
      else A[0]:=S^[i];
      StrLCat(SBuf,A,SBufLen-1);
    end;
  end;
end;             { CatPart }

procedure SetHyperColor(start: boolean);
begin
  if Start then P^:=HyperStartChar else P^:=HyperEndChar; P[1]:=#0;
  StrLCat(SBuf,P,SBufLen-1);
end;                { SetHyperColor }

begin               { Windows PBig wrapper }
  if slen=0 then Exit;
  if (Slen<5) or (ExpHyperFormat[ExportFormat]=ExpHyper_Ignore) then  { Normal }
  begin
    PBig1(S,SLen,KeepCase,HideBraces); Exit;
  end;
  MaxPreLen:=MaxHyperTypeLen;
  MaxPreLen:=imax(MaxPreLen,length(ImageTeXMacro^));
  MaxPreLen:=imax(MaxPreLen,length(ObjectTeXMacro^));

  {
  SBuf^:='!'; P1:=SBuf+1;
  Move(S^,P1^,SLen); p1[SLen]:='!'; p1[Slen+1]:=#0;
  messagebox(0,SBuf,'',mb_ok);
  }
  New(F); GetMem(P,256);
  SBuf^:=#0;
  i0:=1; i1:=1;
  repeat
    while (i1<SLen-1) and
          ((S^[i1]<>'\') or
           ((i1>1) and not (S^[i1-1] in [' ',lbrace]))) do inc(i1);
    if i1>=SLen-1 then i1:=SLen
    else begin
      i2:=i1+1;
      while (i2<=SLen) and (I2-I1<=MaxPreLen) and (S^[i2]<>lbrace) do inc(I2);
      if (I2<=Slen) and (S^[i2]=lbrace) then   { Second stage, identify macro }
      begin
        Move(S^[i1],F^[1],i2-i1); F^[0]:=chr(i2-i1);
        HyperInd:=0;
        if StrCmpI(F^,ImageTeXMacro^,1,1,255)=0 then HyperInd:=-2
        else if StrCmpI(F^,ObjectTeXMacro^,1,1,255)=0 then HyperInd:=-1
        else for j:=1 to NHyperTypes do
          if StrCmpI(F^,HyperTypesArr^[j].TeXMacro^,1,1,255)=0 then HyperInd:=j;
        if HyperInd<>0 then   { Bingo! }
        begin
          CatPart(i0,i1-1,true);
          { Locate argument }
          nbr:=1; inc(i2); StartArg:=i2;
          while (nbr>0) and (I2<=slen) do   { find end of argument }
          begin
            if S^[i2]=lbrace then inc(nbr) else if S^[i2]=rbrace then dec(nbr);
            inc(i2);
          end;
          EndArg:=i2-2;
          StartDesc:=StartArg; EndDesc:=EndArg;
          { Description }
          if (i2<SLen) and (S^[i2] in ['['{,lbrace}]) then { Description exists }
          begin
            if S^[i2]='[' then TermChar:=']' else TermChar:=rbrace;
            i1:=I2+1; i2:=i1; nbr:=1; StartDesc:=i1; 
            while (nbr>0) and (I2<=slen) do   { find description }
            begin
              if S^[i2]=lbrace then inc(nbr)
              else if ((nbr=1) and (S^[i2]=TermChar)) or
                       ((nbr>1) and (S^[i2]=rbrace)) then dec(nbr);
              inc(i2);
            end;
            EndDesc:=i2-2;
          end;
          { Type of hyperlink }
          if HyperInd<0 then LType:=HyperInd
          else if HyperInd<Hyper_User then LType:=HyperInd
          else LType:=HyperTypesArr^[HyperInd].HType;

          { Copy into buffer }
          if (ExpHyperFormat[ExportFormat]=ExpHyper_Resolve) or
             ((LType<>Hyper_Href) and (LType<>Hyper_FTP) and
              (LType<>Hyper_Mail) and (LType<>-2)) then
          begin
            SetHyperColor(true);
            CatPart(StartDesc,EndDesc,StartDesc<>StartArg);
            SetHyperColor(false);
          end else if (ExpHyperFormat[ExportFormat]=ExpHyper_HTML)
              and (LType=-2) then  { \Image }
          begin
            New(BitInfo);
            ParseObjectString(@S^[StartArg],EndArg-StartArg+1,BitInfo^);
            P1:=BitInfo^.fname+StrLen(BitInfo^.Fname)-1;
            while (P1<>@BitInfo^.fname) and (P1^<>'.') do dec(P1);
            if P1^='.' then inc(P1);
            F^:='.'+StrPas(P1)+';'; StrLwr(F^);
            { Filter file extensions }
            if (HTMLImages=Nil) or (Pos(F^,HTMLImages^)=0) then  { wrong file type }
            begin
              SetHyperColor(true);
              CatPart(StartDesc,EndDesc,StartDesc<>StartArg);
              SetHyperColor(false);
            end else with BitInfo^ do
            begin
              if (halign<>ObjAlign_Inline) and (NEolStrings>0) then
              begin
                StrPCopy(P,' '+EolString[1]^+' ');
                StrLCat(SBuf,P,SBufLen-1);
              end;
              StrLCat(SBuf,'<IMG SRC="',SBufLen-1);
              { !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! }
{              StrLCat(SBuf,'file:///',SBufLen-1);}
              for j:=0 to StrLen(Fname)-1 do
              begin
                if fname[j]='\' then fname[j]:='/'
                else if TildeToSpace and (fname[j]='~') then fname[j]:=TildeChar;
              end;
              StrCopy(P,fname); StrLCat(SBuf,P,SBufLen-1);
              StrLCat(SBuf,'"',SBufLen-1);
              if BaseTop or BaseMid then
              begin
                StrLCat(SBuf,' ALIGN=',SBufLen-1);
                if BaseTop then StrLCat(SBuf,'TOP',SBufLen-1)
                else if BaseMid then StrLCat(SBuf,'MIDDLE',SBufLen-1);
              end;
              if StartDesc<>StartArg then  { Optional textual description }
              begin
                StrLCat(SBuf,' ALT="',SBufLen-1);
                CatPart(StartDesc,EndDesc,true);
                StrLCat(SBuf,'"',SBufLen-1);
              end;
              StrLCat(SBuf,'>',SBufLen-1);
              if (halign<>ObjAlign_Inline) and (NEolStrings>0) then
              begin
                StrPCopy(P,' '+EolString[1]^+' ');
                StrLCat(SBuf,P,SBufLen-1);
              end;
            end;
            Dispose(BitInfo);
          end else if ExpHyperFormat[ExportFormat]=ExpHyper_HTML then
          begin
            { Resolve argument (URL) }
            j:=imin(255,EndArg-StartArg+1);
            Move(S^[StartArg],P^,j); P[j]:=#0;
            if HyperInd>=Hyper_User then
              Hyper_UserClassExpand(Entry,HyperInd,P);
            P1:=StrScan(P,','); if P1<>Nil then P1^:=#0;  { kill at first comma }
            if LType=Hyper_Mail then
            begin
              P1:=P;
              repeat
                P1:=StrScan(P1,';');
                if P1<>Nil then P1^:=',';
              until P1=Nil;
              StrLCat(SBuf,'<a href="mailto:',SBufLen-1);
            end else
            begin
              for j:=0 to StrLen(P)-1 do
                if P[j]='\' then P[j]:='/'
                else if TildeToSpace and (P[j]='~') then P[j]:=TildeChar;
              StrLCat(SBuf,'<a href="',SBufLen-1);
            end;
            StrLCat(SBuf,P,SBufLen-1);
            StrLCat(SBuf,'">',SBufLen-1);
            { Description }
            CatPart(StartDesc,EndDesc,true);
            StrLCat(SBuf,'</a>',SBufLen-1);
          end;
          i0:=i2; i1:=i2-1;
        end;
      end;
    end;
    inc(i1);
  until i1>=SLen;
  FreeMem(P,256); Dispose(F);
  CatPart(i0,i1,true);
  Slen:=StrLen(SBuf);
  PBig1(BigTypePtr(SBuf),SLen,KeepCase,HideBraces);
end;           { PBig wrapper }
{$ENDIF}

procedure PrString(s: string; KeepCase,HideBraces: boolean);
begin
  if not ((S='') or (S=EmptyFieldChar)) then
    Pbig(BigTypePtr(@S[1]),length(S),KeepCase,HideBraces);
  NewLines:=0;
end;

procedure emph(s: string; KeepCase: boolean);
begin
  OBfStatus:=BfStatus;
  Boldface(true);
  PrString(s,KeepCase,false);
  Boldface(OBfStatus);
end;

function GetShowFormat(i: integer; first: boolean): char;
begin                            { GetShowFormat }
  if (i<1) or (i>ShowFormat[first].len) then 
    GetShowFormat:=#0
  else
    GetShowFormat:=ShowFormat[first].p^[i];
end;                                 { GetShowFormat }

procedure Cr(N: integer);
var
  i: integer;
  negative,UseEolStrings: boolean;
  j: byte;
begin
  negative:=false;
  if N=$7FFF then
  begin
    UseEolStrings:=false; N:=0;
  end else UseEolStrings:=true;
  if N<0 then
  begin
    N:=-N; Negative:=true;
  end;
  if (tx=1) and (ty=1) and (not negative) then N:=0;
  if (not negative) and (NewLines>0) then
  begin
    N:=N-NewLines; if N<0 then N:=0;
  end;
  if tx>1 then
  begin
    if (EndLineString[ExportFormat]<>Nil) and
       (EndLineString[ExportFormat]^<>'') then
    begin
      if UseEolStrings then wrt(EndLineString[ExportFormat]^);
      NewLines:=0;
    end;
    wrtline('',Unix);
    tx:=1; Inc(ty);
  end else tx:=1;
  if N>0 then
  begin
    for i:=1 to n do
      if EndLineString[ExportFormat]=Nil then wrtline('',Unix)
      else wrtline(EndLineString[ExportFormat]^,Unix);
    tx:=1; ty:=ty+n;
  end;
  NewLines:=NewLines+N;
end;                                 { Cr }

begin                                { PrintEntry }
  AllocStrings(true,@FilePath,@FileName,@FileExt,Nil);
  TimeOutOn:=false;
  MaxMemAvail;
  with Entry^ do
  begin
    ChrDel(EntryType,' '); StrLwr(entrytype);
  end;
  tx:=1; ty:=1;
  si:=0;
  nbr:=1; CharCase:=-1; BfStatus:=false; PrColor:=1;
  FoundEnd:=false; NewLines:=0;
  LFNFsplit(bibname^,FilePath,FileName,FileExt);
  FileDrive:=FilePath^[1]; Delete(FilePath^,1,2);
  if (FileExt^<>'') and (FileExt^[1]='.') then Delete(FileExt^,1,1);
  etype:=FindInETypeList(Entry^.EntryType);
{$IFDEF WINDOWS}
  SBuf:=Nil;
  if ExpHyperFormat[ExportFormat]<>ExpHyper_Ignore then GetMem(SBuf,SBufLen);
{$ENDIF}
  repeat
    repeat
      inc(si);
    until (si=ShowFormat[FirstShowBuf].len) or 
          (GetShowFormat(si,FirstShowBuf)<>sf_NOP);
    ch:=GetShowFormat(si,FirstShowBuf);
    if ch=sf_BF then                        { begin \bf }
    begin
      if BfStatus then Attrib[nbr]:=2
      else Attrib[nbr]:=1;
      inc(nbr);
      Boldface(true);
    end else if ch=sf_Color then              { begin \color }
    begin
      Attrib[nbr]:=16+PrColor;
      PrintColor(Ord(GetShowFormat(si+1,FirstShowBuf)));
      inc(nbr); Inc(si);
    end else if ch=sf_UpCase then              { begin \uc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-2;
    end else if ch=sf_DnCase then              { begin \lc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-3;
    end else if ch=sf_DefCase then              { begin \dc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-1;
    end else if ch=sf_EndAtt then     { end attribute }
    begin
      dec(nbr);
      if Attrib[nbr]=1 then Boldface(false)
      else if Attrib[nbr]=2 then Boldface(true)
      else if Attrib[nbr]>16 then PrintColor(Attrib[nbr]-16)
      else if Attrib[nbr]<0 then CharCase:=Attrib[nbr];
    end else if ch=sf_CR then                   { \cr }
    begin
      inc(si);
      Cr(ShortInt(Ord(GetShowFormat(si,FirstShowBuf))));
    end else if ch=sf_FF then                  { Windows print FF, ignore }
    else if (ch=sf_If) or (ch=sf_ElseIf) then  { \if and \elseif }
    begin
      inc(si); tmp:='';
      while GetShowFormat(si,FirstShowBuf)<>sf_EndIf do
      begin
        if GetShowFormat(si,FirstShowBuf)<>sf_NOP then
           PStrCat(tmp,GetShowFormat(si,FirstShowBuf),255);
        inc(si);
      end;
      if (ch=sf_If) then   {\if}
      begin
        if EvalCondition(entry,tmp,true,false,@fields[1]) then
        begin
          LastEval:=true;
          inc(nbr);
        end else
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
          LastEval:=false;
        end;
      end else if ch=sf_ElseIf then  {\elseif}
      begin
        if LastEval then
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
        end else
        begin
          if EvalCondition(entry,tmp,true,false,@fields[1]) then
          begin
            LastEval:=true; inc(nbr);
          end else
          begin
            repeat
              inc(si);
            until (si>=showformat[FirstShowBuf].len) or
                  (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
            LastEval:=false;
          end;
        end;
      end;
    end else if Ord(ch)>sf_EndBrace then  {close of good \if}
    begin
      dec(nbr);
      LastEval:=true;
    end else if ch=sf_FldName then   { The (possibly alternate) field name }
    begin
      inc(si); j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
      if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^
      else begin
        tmp:=TypeField^[j]; tmp[1]:=UpCase(tmp[1]);
      end;
      PrString(tmp,false,false);
    end else if ch in [sf_Field,sf_Field1,sf_Field2,sf_Field3] then   { fields }
    begin
      inc(si); Exists:=false;
      if GetShowFormat(si,FirstShowBuf)=sfFld_Name then         { Name }
        Exists:=(entry^.name<>'')
      else if GetShowFormat(si,FirstShowBuf) in
        [sfFld_flFull,sfFld_flDrive,sfFld_flPath,sfFld_flName,
         sfFld_flExt,sfFld_Type] then
        Exists:=true   { File name components, Type }
      else begin                                          { Field name }
        j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
        Exists:=((j=StringIndex) or (j<=Entry^.LastField))
                 and (entry^.index[j]>0)
                 and ((j=StringIndex) or fields[j]);
        if (not Exists) and (not FirstShowBuf) then
          Exists:=(Pos(chr(j),Pstring(@required^[etype])^)>0)
             or (Pos(chr(byte(-j)),Pstring(@required^[etype])^)>0);
      end;
      if Exists then
      begin
        if (ch in [sf_Field1,sf_Field3]) then Cr(0);      { \cr(0) }
        if ch=sf_Field3 then Cr(1);
        if GetShowFormat(si,FirstShowBuf)=sfFld_flFull then             { Full file path }
        begin
          if ch<>sf_Field then emph('File: ',true);
          PrString(bibname^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flDrive then    { File drive }
        begin
          if ch<>sf_Field then emph('File drive: ',true);
          PrString(FileDrive,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flPath then    { File path }
        begin
          if ch<>sf_Field then emph('File path: ',true);
          PrString(FilePath^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flName then    { File name }
        begin
          if ch<>sf_Field then emph('File name: ',true);
          PrString(FileName^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flExt then    { File extension }
        begin
          if ch<>sf_Field then emph('File extension: ',true);
          PrString(FileExt^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Name then    { Entry Name }
        begin
          if ch<>sf_Field then emph('Entry name: ',true);
          PrString(Entry^.name,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Type then    { Entry Type }
        begin
          if ch<>sf_Field then emph('Entry type: ',true);
          tmp:=Entry^.EntryType; tmp[1]:=UpCase(tmp[1]);
          PrString(tmp,false,false);
        end else                                                { Field }
        begin
          j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
          isIgnored:=true;
          for k:=1 to required^[etype,0] do
            if j=abs(required^[etype,k]) then IsIgnored:=false;

          k:=entry^.index[j];
          if ch<>sf_Field then
          begin
            if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^+': '
            else begin
              tmp:=TypeField^[j]+': '; tmp[1]:=UpCase(tmp[1]);
            end;
            {
            if k>0 then tmp:=entry^.field[k]+': '
            else tmp:=TypeField^[j]+': ';
            tmp[1]:=UpCase(tmp[1]);
            }
            emph(tmp,true);
          end;
          if k>0 then
          begin
            if entry^.BigIndex[j]=0 then
              PrString(entry^.content[k],false,not IsIgnored)
            else
              Pbig(entry^.Big[entry^.BigIndex[j]],entry^.Blen[entry^.Bigindex[j]],
                   false,not IsIgnored);
          end;
        end;
        if (ch in [sf_Field1,sf_Field3]) then Cr(0);
      end;      
    end else if ch=sf_EOL then CR(0)
    else if ch=sf_Quote then               { ASCII char }
    begin
      inc(si); prchar(GetShowFormat(si,FirstShowBuf));
    end else if ch=sf_END then FoundEnd:=true
    else if (ch<>sf_NOP) then   { Characters in the ShowFormat }
    begin
      if ch=' ' then
      begin
        prchar(ch); inc(si);
      end;
      i:=si;
      while (i<ShowFormat[FirstShowBuf].len) and
            (GetShowFormat(i,FirstShowBuf)>=' ') and
            (Ord(GetShowFormat(i,FirstShowBuf))<sf_EndBrace) do inc(i);
      dec(i);
      Pbig(@ShowFormat[FirstShowBuf].p^[si],i-si+1,false,false);
      si:=i;
    end;
  until (si>=ShowFormat[FirstShowBuf].len) or (nbr<1) or FoundEnd;
{$IFDEF WINDOWS}
  if SBuf<>Nil then FreeMem(SBuf,SBufLen);
{$ENDIF}

  if entry^.EntryType<>'_header' then CR(0)
  else if tx>1 then wrtline('',Unix);
  AllocStrings(false,@FilePath,@FileName,@FileExt,Nil);
end;                                   { PrintEntry }


end.
