/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import de.nm.ant.ipdf.AbstractPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfRemovingLaunchActionTask
extends AbstractPdfTask {
    private String javascript = "app.alert('Launch Application Action removed by iText');\r";

    public void execute() {
        try {
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input);
            PdfReader reader = this.createPdfReaderFromFile(input);
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            int n = reader.getXrefSize();
            for (int i = 1; i < n; ++i) {
                PdfDictionary action;
                PdfObject object = reader.getPdfObject(i);
                if (!(object instanceof PdfDictionary) || (action = ((PdfDictionary)object).getAsDict(PdfName.A)) == null || !PdfName.LAUNCH.equals((Object)action.getAsName(PdfName.S))) continue;
                action.remove(PdfName.F);
                action.remove(PdfName.WIN);
                action.put(PdfName.S, (PdfObject)PdfName.JAVASCRIPT);
                action.put(PdfName.JS, (PdfObject)new PdfString(this.javascript));
            }
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }
}

