// Name of a group of files
[groupname]
/l83000/l

// This section contains extensions of files belonging to the group.
// If one extenstion belongs to more than one group, definitions from all the
// groups are applied
[extensions]
tex, sty, cls, clo

// Access type to the files from the group
[access]
// level    = (0-readonly, 1-ask before edit, 2-fullaccess}
// question = {nicetext shown to ask the file should be edited}
// exec     = {file name to execute when a file is opened}
level=2

// Defines if the group of files is enabled by default
[default]
no

// Hilight commands
// Predefined groups:
// [hilight\keys]     - keywords
// [hilight\symbols]  - special symbols
// [hilight\types]    - types
// [hilight\comments] - comments
[hilight\LongtableKeys]
\begin{longtable}
\end{longtable}
\LTleft
\LTright
\LTpre
\LTpost
\LTcapwidth
\tabularnewline
\endhead
\endfirsthead
\endfoot
\endlastfoot
\pagebreak
\nopagebreak
\setlongtables
\LTmulticolumn

// Defines hints for keywords. Each hint is a nicetext.
[hints]
// Longtable
\begin{longtable}=/l83001/l
\end{longtable}=/l83002/l
\LTleft=/l83003/l
\LTright=/l83004/l
\LTpre=/l83005/l
\LTpost=/l83006/l
\LTcapwidth=/l83007/l
\tabularnewline=/l83008/l
\endhead=/l83009/l
\endfirsthead=/l83010/l
\endfoot=/l83011/l
\endlastfoot=/l83012/l
\pagebreak=/l83013/l
\nopagebreak=/l83014/l
\setlongtables=/l83015/l
\LTmulticolumn=/l83016/l

// This section defines commands related to the group of files
// Syntaxt of the row:
//     name     - command name (nicetext)
//     bitmap   - bitmap code from resources
//     shortcut - hotkey 
//     label    - (nicetext)
//     hint     - (nicetext)
//     command  - command to execute
//
// Command syntax:
//     exec:nicetext - execute nicetext
//     ins:nicetext' - insert nicetext to the editor window (_ denotes cursor position)
//
// Predefined constants:
//     <PROGRAMDIR>       - LEd directory
//     <PROJECT>          - full path of the project, e.g., C:\Papers\Newest.lpr
//     <PROJECTDIR>       - project directory, e.g., C:\Papers
//     <PROJECTNAME>      - project name, e.g., Newest
//     <PROJECTNAMEEXT>   - project name with extension, e.g., Newest.lpr
//     <MAINFILE>         - full path to the main project file, e.g., C:\Papers\Main.tex
//     <MAINFILEDIR>      - directory name of the main project file, e.g., C:\Papers
//     <MAINFILENAME>     - main file name, e.g., Main
//     <MAINFILENAMEEXT>  - main file name with extension, e.g., Main.tex
//     <FILE>             - full path to the selected file
//     <FILEDIR>          - directory of the selected file
//     <FILENAME>         - selected file name
//     <FILENAMEEXT>      - selected file name with extension
//     <BatchesDir>       - directory with LEd batches
//     <DefinitionsDir>   - directory with LEd definitions
//     <DictionariesDir>  - directory with LEd dictionaries
//     <LanguagesDir>     - directory with LEd language resources
//     <ProjectsDir>      - default LEd directory for projects
//     <TemplatesDir>     - directory with LEd templates
//     <ResourcesDir>     - directory with LEd resources
[commands]

// Example for syntaxt hilighting for the group of files
[syntaxexample\LongtableKeys]
=\begin{longtable}
=...
=\end{longtable}
