/* This file is macio.c
 *
 * Copyright (C) 1993 by Norman Walsh
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ************************************************************************/

#include <stdio.h>
#include "macio.h"
#include "mactypes.h"

int read_int()
{
  int datum;
  rc = fread(&datum, sizeof (datum), 1, input);
  return datum;
}

short int read_shortint()
{
  short int datum;
  rc = fread(&datum, sizeof (datum), 1, input);
  return datum;
}

unsigned char read_char()
{
  unsigned char datum;
  rc = fread(&datum, sizeof (datum), 1, input);
  return datum;
}

int read_macint()
{
  unsigned char Ca[4];
  int datum;

  rc = fread(&Ca, 1, 4, input);
  datum = (Ca[0] << 24) + (Ca[1] << 16) + (Ca[2] << 8) + (Ca[3]);
  return datum;
}

int read_macint3()
{
  unsigned char Ca[3];
  int datum;

  rc = fread(&Ca, 1, 3, input);
  datum = (Ca[0] << 16) + (Ca[1] << 8) + (Ca[2]);
  return datum;
}

short int read_macshortint()
{
  unsigned char Ca[2];
  int datum;

  rc = fread(&Ca, 1, 2, input);
  datum = (Ca[0] << 8) + (Ca[1]);
  return datum;
}

unsigned char read_macchar()
{
  return read_char();
}

RsrcHdrStruct read_mac_header()
{
  RsrcHdrStruct Header;
  int count;

  Header.DataOffset = read_macint();
  Header.MapOffset  = read_macint();
  Header.DataLen    = read_macint();
  Header.MapLen     = read_macint();

  for (count = 0; count < 96; count++)
    Header.OSReserved[count] = read_macchar();

  for (count = 0; count < 128; count++)
    Header.AppReserved[count] = read_macchar();

  return Header;
}

RsrcMapStruct read_mac_map()
{
  RsrcMapStruct Map;
  int count;

  for (count = 0; count < 4; count++)
    Map.MapCopy[count] = read_macint();

  Map.NextMap = read_macint();
  Map.FileRef = read_macshortint();
  Map.FileAttr = read_macshortint();
  Map.TypeOffset = read_macshortint();
  Map.NameOffset = read_macshortint();

  return Map;
}

RsrcTypeStruct read_mac_type()
{
  RsrcTypeStruct Type;
  int count;

  for (count = 0; count < 4; count++)
    Type.Name[count] = read_macchar();

  Type.Count = read_macshortint() + 1; /* ofs from zero */
  Type.RefOffset = read_macshortint();

  return Type;
}

RsrcRefStruct read_mac_ref()
{
  RsrcRefStruct Ref;
  int count;

  Ref.Ident = read_macshortint();
  Ref.NameOffset = read_macshortint();
  Ref.Attr = read_macchar();
  Ref.DataOffset = read_macint3();
  Ref.Unknown = read_macint();

  return Ref;
}

RsrcFondStruct read_mac_fond()
{
  RsrcFondStruct Fond;
  int count;

  Fond.Flag = read_macshortint();
  Fond.FamilyId = read_macshortint();
  Fond.FirstChar = read_macshortint();
  Fond.LastChar = read_macshortint();
  Fond.Ascent = read_macshortint();
  Fond.Descent = read_macshortint();
  Fond.Leading = read_macshortint();
  Fond.WidMax = read_macshortint();
  Fond.WidTblOfs = read_macint();
  Fond.KrnTblOfs = read_macint();
  Fond.StyTblOfs = read_macint();

  for (count = 0; count < 9; count++)
    Fond.FamStyProp[count] = read_macshortint();

  Fond.Intrnatnl = read_macint();
  Fond.FontVers = read_macshortint();

  Fond.NumFonts = read_macshortint() + 1;
  Fond.AssocTable = (FontEntryFormat *) malloc(Fond.NumFonts *
						     sizeof(FontEntryFormat));
  for (count = 0; count < Fond.NumFonts; count++)
    {
      Fond.AssocTable[count].PointSize = read_macshortint();
      Fond.AssocTable[count].StyleCode = read_macshortint();
      Fond.AssocTable[count].ResourceNumber = read_macshortint();
    }

  return Fond;
}

RsrcNfntStruct read_mac_nfnt()
{
  RsrcNfntStruct Nfnt;
  int count;

  Nfnt.FontType = read_macshortint();
  Nfnt.FirstChar = read_macshortint();
  Nfnt.LastChar = read_macshortint();
  Nfnt.WidMax = read_macshortint();
  Nfnt.KernMax = read_macshortint();
  Nfnt.NDescent = read_macshortint();
  Nfnt.FRectWidth = read_macshortint();
  Nfnt.FRectHeight = read_macshortint();
  Nfnt.OWTLoc = read_macshortint();
  Nfnt.Ascent = read_macshortint();
  Nfnt.Descent = read_macshortint();
  Nfnt.Leading = read_macshortint();
  Nfnt.RowWords = read_macshortint();

  return Nfnt;
}

