/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.TriggerEvent;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class InternalTriggerExecutionContext
implements TriggerExecutionContext,
ExecutionStmtValidator {
    protected int[] changedColIds;
    protected String[] changedColNames;
    protected int dmlType;
    protected String statementText;
    protected ConnectionContext cc;
    protected UUID targetTableId;
    protected String targetTableName;
    protected LanguageConnectionContext lcc;
    protected CursorResultSet beforeResultSet;
    protected CursorResultSet afterResultSet;
    protected ExecRow afterRow;
    protected boolean cleanupCalled;
    protected TriggerEvent event;
    protected TriggerDescriptor triggerd;
    private Vector resultSetVector;
    private Vector aiCounters;
    private Hashtable aiHT;

    public InternalTriggerExecutionContext(LanguageConnectionContext languageConnectionContext, ConnectionContext connectionContext, String string, int n, int[] nArray, String[] stringArray, UUID uUID, String string2, Vector vector) throws StandardException {
        this.dmlType = n;
        this.changedColIds = nArray;
        this.changedColNames = stringArray;
        this.statementText = string;
        this.cc = connectionContext;
        this.lcc = languageConnectionContext;
        this.targetTableId = uUID;
        this.targetTableName = string2;
        this.resultSetVector = new Vector();
        this.aiCounters = vector;
        languageConnectionContext.pushTriggerExecutionContext(this);
    }

    void setBeforeResultSet(CursorResultSet cursorResultSet) {
        this.beforeResultSet = cursorResultSet;
    }

    void setAfterResultSet(CursorResultSet cursorResultSet) throws StandardException {
        this.afterResultSet = cursorResultSet;
        if (this.aiCounters != null) {
            if (this.triggerd.isRowTrigger()) {
                cursorResultSet.open();
                this.afterRow = cursorResultSet.getNextRow();
                cursorResultSet.close();
            } else if (!this.triggerd.isBeforeTrigger()) {
                this.resetAICounters(false);
            }
        }
    }

    void setCurrentTriggerEvent(TriggerEvent triggerEvent) {
        this.event = triggerEvent;
    }

    void clearCurrentTriggerEvent() {
        this.event = null;
    }

    void setTrigger(TriggerDescriptor triggerDescriptor) {
        this.triggerd = triggerDescriptor;
    }

    void clearTrigger() throws StandardException {
        this.event = null;
        this.triggerd = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
    }

    protected void cleanup() throws StandardException {
        this.lcc.popTriggerExecutionContext(this);
        Enumeration enumeration = this.resultSetVector.elements();
        while (enumeration.hasMoreElements()) {
            ResultSet resultSet = (ResultSet)enumeration.nextElement();
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        this.resultSetVector = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
        this.lcc = null;
        this.cleanupCalled = true;
    }

    private void ensureProperContext() throws SQLException {
        if (this.cleanupCalled) {
            throw new SQLException(MessageService.getTextMessage("XCL31.S"), "XCL31", 20000);
        }
    }

    public void validateStatement(ConstantAction constantAction) throws StandardException {
        if (this.triggerd.isBeforeTrigger() && constantAction instanceof WriteCursorConstantAction && constantAction.modifiesTableId(this.targetTableId)) {
            throw StandardException.newException("X0Y70.S", this.triggerd.getName(), (Object)this.targetTableName);
        }
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public UUID getTargetTableId() {
        return this.targetTableId;
    }

    public int getEventType() {
        return this.dmlType;
    }

    public String getEventStatementText() {
        return this.statementText;
    }

    public String[] getModifiedColumns() {
        return this.changedColNames;
    }

    public boolean wasColumnModified(String string) {
        if (this.changedColNames == null) {
            return true;
        }
        for (int i = 0; i < this.changedColNames.length; ++i) {
            if (!this.changedColNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean wasColumnModified(int n) {
        if (this.changedColIds == null) {
            return true;
        }
        for (int i = 0; i < this.changedColNames.length; ++i) {
            if (this.changedColIds[i] != n) continue;
            return true;
        }
        return false;
    }

    public ResultSet getOldRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.beforeResultSet == null) {
            return null;
        }
        try {
            CursorResultSet cursorResultSet = this.beforeResultSet;
            if (cursorResultSet instanceof TemporaryRowHolderResultSet) {
                cursorResultSet = (CursorResultSet)((TemporaryRowHolderResultSet)cursorResultSet).clone();
            } else if (cursorResultSet instanceof TableScanResultSet) {
                cursorResultSet = (CursorResultSet)((TableScanResultSet)cursorResultSet).clone();
            }
            cursorResultSet.open();
            ResultSet resultSet = this.cc.getResultSet(cursorResultSet);
            this.resultSetVector.addElement(resultSet);
            return resultSet;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public ResultSet getNewRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.afterResultSet == null) {
            return null;
        }
        try {
            CursorResultSet cursorResultSet = this.afterResultSet;
            if (cursorResultSet instanceof TemporaryRowHolderResultSet) {
                cursorResultSet = (CursorResultSet)((TemporaryRowHolderResultSet)cursorResultSet).clone();
            } else if (cursorResultSet instanceof TableScanResultSet) {
                cursorResultSet = (CursorResultSet)((TableScanResultSet)cursorResultSet).clone();
            }
            cursorResultSet.open();
            ResultSet resultSet = this.cc.getResultSet(cursorResultSet);
            this.resultSetVector.addElement(resultSet);
            return resultSet;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public ResultSet getOldRow() throws SQLException {
        ResultSet resultSet = this.getOldRowSet();
        if (resultSet != null) {
            resultSet.next();
        }
        return resultSet;
    }

    public ResultSet getNewRow() throws SQLException {
        ResultSet resultSet = this.getNewRowSet();
        if (resultSet != null) {
            resultSet.next();
        }
        return resultSet;
    }

    public Long getAutoincrementValue(String string) {
        Long l;
        if (this.aiHT != null && (l = (Long)this.aiHT.get(string)) != null) {
            return l;
        }
        if (this.aiCounters != null) {
            for (int i = 0; i < this.aiCounters.size(); ++i) {
                AutoincrementCounter autoincrementCounter = (AutoincrementCounter)this.aiCounters.elementAt(i);
                if (!string.equals(autoincrementCounter.getIdentity())) continue;
                return autoincrementCounter.getCurrentValue();
            }
        }
        return null;
    }

    public void copyHashtableToAIHT(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        if (this.aiHT == null) {
            this.aiHT = new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            this.aiHT.put(k, v);
        }
    }

    public void resetAICounters(boolean bl) {
        if (this.aiCounters == null) {
            return;
        }
        this.afterRow = null;
        int n = this.aiCounters.size();
        for (int i = 0; i < n; ++i) {
            AutoincrementCounter autoincrementCounter = (AutoincrementCounter)this.aiCounters.elementAt(i);
            autoincrementCounter.reset(bl);
        }
    }

    public void updateAICounters() throws StandardException {
        if (this.aiCounters == null) {
            return;
        }
        int n = this.aiCounters.size();
        for (int i = 0; i < n; ++i) {
            AutoincrementCounter autoincrementCounter = (AutoincrementCounter)this.aiCounters.elementAt(i);
            DataValueDescriptor dataValueDescriptor = this.afterRow.getColumn(autoincrementCounter.getColumnPosition());
            autoincrementCounter.update(dataValueDescriptor.getLong());
        }
    }

    public String toString() {
        return this.triggerd.getName();
    }
}

