/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.util.Formatter;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;

public class Evaluator {
    private String constant;
    private Variable v;

    public static FeatureType getFeatureType(NetcdfDataset ds, String key, Formatter errlog) {
        FeatureType ft = null;
        String fts = Evaluator.getLiteral(ds, key, errlog);
        if (fts != null && (ft = FeatureType.valueOf(fts.toUpperCase())) == null && errlog != null) {
            errlog.format(" Cant find Feature type %s from %s\n", fts, key);
        }
        return ft;
    }

    public static String getLiteral(NetcdfDataset ds, String key, Formatter errlog) {
        if (key.startsWith(":")) {
            String val = ds.findAttValueIgnoreCase(null, key.substring(1), null);
            if (val == null && errlog != null) {
                errlog.format(" Cant find global attribute %s\n", key);
            }
            return val;
        }
        return key;
    }

    public static String getVariableName(NetcdfDataset ds, String key, Formatter errlog) {
        Variable v = null;
        String vs = Evaluator.getLiteral(ds, key, errlog);
        if (vs != null && (v = ds.findVariable(vs)) == null && errlog != null) {
            errlog.format(" Cant find Variable %s from %s\n", vs, key);
        }
        return v == null ? null : v.getShortName();
    }

    public static Variable getVariableWithAttribute(NetcdfDataset ds, String attName) {
        for (Variable v : ds.getVariables()) {
            String stdName = ds.findAttValueIgnoreCase(v, attName, null);
            if (stdName == null) continue;
            return v;
        }
        return null;
    }

    public static Variable getVariableWithAttributeValue(NetcdfDataset ds, String attName, String attValue) {
        for (Variable v : ds.getVariables()) {
            String haveValue = ds.findAttValueIgnoreCase(v, attName, null);
            if (haveValue == null || !haveValue.equals(attValue)) continue;
            return v;
        }
        return null;
    }

    public static String getVariableAttributeValue(NetcdfDataset ds, String attName) {
        for (Variable v : ds.getVariables()) {
            String haveValue = ds.findAttValueIgnoreCase(v, attName, null);
            if (haveValue == null) continue;
            return haveValue;
        }
        return null;
    }

    public static String getNameOfVariableWithAttribute(NetcdfDataset ds, String attName, String attValue) {
        Variable v = Evaluator.getVariableWithAttributeValue(ds, attName, attValue);
        return v == null ? null : v.getShortName();
    }

    public static String getNameOfVariableWithAttribute(Structure struct, String attName, String attValue) {
        for (Variable v : struct.getVariables()) {
            Attribute att = v.findAttributeIgnoreCase(attName);
            if (att == null || !att.getStringValue().equals(attValue)) continue;
            return v.getShortName();
        }
        return null;
    }

    public static String getDimensionName(NetcdfDataset ds, String key, Formatter errlog) {
        Dimension d = Evaluator.getDimension(ds, key, errlog);
        return d == null ? null : d.getName();
    }

    public static Dimension getDimension(NetcdfDataset ds, String key, Formatter errlog) {
        Dimension d = null;
        String s = Evaluator.getLiteral(ds, key, errlog);
        if (s != null && (d = ds.findDimension(s)) == null && errlog != null) {
            errlog.format(" Cant find Variable %s from %s\n", s, key);
        }
        return d;
    }

    public static Structure getStructureWithDimensions(NetcdfDataset ds, Dimension dim0, Dimension dim1) {
        for (Variable v : ds.getVariables()) {
            if (!(v instanceof Structure) || v.getRank() != 2 || !v.getDimension(0).equals(dim0) || !v.getDimension(1).equals(dim1)) continue;
            return (Structure)v;
        }
        return null;
    }

    public static Structure getNestedStructure(Structure s) {
        for (Variable v : s.getVariables()) {
            if (!(v instanceof Structure)) continue;
            return (Structure)v;
        }
        return null;
    }

    public static boolean hasRecordStructure(NetcdfDataset ds) {
        Variable v = ds.findVariable("record");
        return v != null && v.getDataType() == DataType.STRUCTURE;
    }

    Evaluator(Variable v) {
        this.v = v;
    }

    Evaluator(String constant) {
        this.constant = constant;
    }

    public String getValue() {
        if (this.constant != null) {
            return this.constant;
        }
        return null;
    }
}

