/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.measure.Units;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.logging.WarningListeners;

public abstract class Decoder
implements Closeable {
    public final GeometryLibrary geomlib;
    public final WarningListeners<DataStore> listeners;
    public volatile boolean canceled;

    protected Decoder(GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) {
        Objects.requireNonNull(warningListeners);
        this.geomlib = geometryLibrary;
        this.listeners = warningListeners;
    }

    public abstract String getFilename();

    public abstract void setSearchPath(String ... var1);

    public abstract String[] getSearchPath();

    public abstract Collection<String> getAttributeNames();

    public abstract String stringValue(String var1);

    public abstract Number numericValue(String var1);

    protected final Number parseNumber(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.listeners.warning(null, numberFormatException);
            return null;
        }
    }

    public abstract Date dateValue(String var1);

    public final Unit<?> unitValue(String string) {
        String string2 = this.stringValue(string);
        if (string2 != null) {
            try {
                return Units.valueOf(string2);
            }
            catch (ParserException parserException) {
                this.listeners.warning(null, parserException);
            }
        }
        return null;
    }

    public abstract Date[] numberToDate(String var1, Number ... var2);

    public String getId() {
        return this.stringValue("_Id");
    }

    public String getTitle() {
        return this.stringValue("_Title");
    }

    public abstract Variable[] getVariables();

    public abstract DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException;

    public abstract GridGeometry[] getGridGeometries() throws IOException, DataStoreException;
}

