/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateConverter
implements Converter {
    public static final DateConverter INSTANCE = new DateConverter();
    private static final Pattern TIMEZONE_PATTERN = Pattern.compile("(?:GMT|UTC)([+-][0-9]{2})([0-9]{2})");

    DateConverter() {
    }

    @Override
    public Object convert(JSON jSON, JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Object object2;
        Object object3;
        if (object instanceof Map) {
            object = ((Map)object).get(null);
        } else if (object instanceof List) {
            object3 = (List)object;
            object = !object3.isEmpty() ? object3.get(0) : null;
        }
        object3 = null;
        long l = -1L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
            object3 = (java.util.Date)jSON.create(context, clazz);
        } else if (object != null && ((String)(object2 = object.toString().trim())).length() > 0) {
            l = DateConverter.convertDate((String)object2, context);
            object3 = (java.util.Date)jSON.create(context, clazz);
        }
        if (object3 != null) {
            if (object3 instanceof Date) {
                object2 = Calendar.getInstance();
                ((Calendar)object2).setTimeInMillis(l);
                ((Calendar)object2).set(11, 0);
                ((Calendar)object2).set(12, 0);
                ((Calendar)object2).set(13, 0);
                ((Calendar)object2).set(14, 0);
                ((java.util.Date)object3).setTime(((Calendar)object2).getTimeInMillis());
            } else if (object3 instanceof Time) {
                object2 = Calendar.getInstance();
                ((Calendar)object2).setTimeInMillis(l);
                ((Calendar)object2).set(1, 1970);
                ((Calendar)object2).set(2, 0);
                ((Calendar)object2).set(5, 1);
                ((java.util.Date)object3).setTime(((Calendar)object2).getTimeInMillis());
            } else {
                ((java.util.Date)object3).setTime(l);
            }
        }
        return object3;
    }

    static Long convertDate(String string, JSON.Context context) throws ParseException {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        string = TIMEZONE_PATTERN.matcher(string).replaceFirst("GMT$1:$2");
        DateFormat dateFormat = null;
        if (Character.isDigit(string.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            String string2 = "yMdHmsSZ";
            int n = string.length() > 2 && string.charAt(2) == ':' ? 3 : 0;
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                boolean bl2;
                char c = string.charAt(i);
                if (!(n != 4 && n != 5 && n != 6 || c != '+' && c != '-' || i + 1 >= string.length() || !Character.isDigit(string.charAt(i + 1)))) {
                    if (!bl) {
                        stringBuilder.append('\'');
                    }
                    n = 7;
                    n2 = 0;
                    bl = true;
                    continue;
                }
                if (n == 7 && c == ':' && i + 1 < string.length() && Character.isDigit(string.charAt(i + 1))) {
                    string = string.substring(0, i) + string.substring(i + 1);
                    continue;
                }
                boolean bl3 = bl2 = Character.isDigit(c) && n < 8;
                if (bl != bl2) {
                    stringBuilder.append('\'');
                    if (bl2) {
                        n2 = 0;
                        ++n;
                    }
                }
                if (bl2) {
                    char c2 = string2.charAt(n);
                    if (n2 == (c2 == 'y' || c2 == 'Z' ? 4 : (c2 == 'S' ? 3 : 2))) {
                        n2 = 0;
                        c2 = string2.charAt(++n);
                    }
                    if (c2 != 'Z' || n2 == 0) {
                        stringBuilder.append(c2);
                    }
                    ++n2;
                } else {
                    stringBuilder.append(c == '\'' ? "''" : Character.valueOf(c));
                }
                bl = bl2;
            }
            if (!bl) {
                stringBuilder.append('\'');
            }
            dateFormat = new SimpleDateFormat(stringBuilder.toString(), Locale.ENGLISH);
        } else if (string.length() > 18) {
            if (string.charAt(3) == ',') {
                String string3 = "EEE, dd MMM yyyy HH:mm:ss Z";
                dateFormat = new SimpleDateFormat(string.length() < string3.length() ? string3.substring(0, string.length()) : string3, Locale.ENGLISH);
            } else if (string.charAt(13) == ':') {
                dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH);
            } else if (string.charAt(18) == ':') {
                String string4 = "EEE MMM dd yyyy HH:mm:ss Z";
                dateFormat = new SimpleDateFormat(string.length() < string4.length() ? string4.substring(0, string.length()) : string4, Locale.ENGLISH);
            } else {
                dateFormat = DateFormat.getDateTimeInstance(2, 2, context.getLocale());
            }
        } else {
            dateFormat = DateFormat.getDateInstance(2, context.getLocale());
        }
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(context.getTimeZone());
        return dateFormat.parse(string).getTime();
    }
}

