/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.message.BasicBinaryBody;
import org.apache.james.mime4j.message.BasicTextBody;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.StringBody;
import org.apache.james.mime4j.util.CharsetUtil;

public class BasicBodyFactory
implements BodyFactory {
    public BinaryBody binaryBody(InputStream is) throws IOException {
        return new BasicBinaryBody(BasicBodyFactory.bufferContent(is));
    }

    public TextBody textBody(InputStream is, String mimeCharset) throws IOException {
        return new BasicTextBody(BasicBodyFactory.bufferContent(is), mimeCharset);
    }

    private static byte[] bufferContent(InputStream is) throws IOException {
        int l;
        if (is == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] tmp = new byte[2048];
        while ((l = is.read(tmp)) != -1) {
            buf.write(tmp, 0, l);
        }
        return buf.toByteArray();
    }

    public TextBody textBody(String text, String mimeCharset) throws UnsupportedEncodingException {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        Charset charset = Charset.forName(mimeCharset);
        try {
            return new StringBody(text, charset);
        }
        catch (UnsupportedCharsetException ex) {
            throw new UnsupportedEncodingException(ex.getMessage());
        }
    }

    public TextBody textBody(String text, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody(text, charset);
    }

    public TextBody textBody(String text) {
        return this.textBody(text, CharsetUtil.DEFAULT_CHARSET);
    }

    public BinaryBody binaryBody(byte[] buf) {
        return new BasicBinaryBody(buf);
    }
}

