package TaskPipe::Task_Record_NameValuePairs;

use Moose;
extends 'TaskPipe::Task_Record';

sub action{
    my ($self) = @_;

    $self->set_dt;

    my $name_col = 'name';
    my $val_col = 'value';

    my $cols = $self->pinterp->{columns};
    if ( $cols ){
        $name_col = $cols->{name} if $cols->{name};
        $val_col = $cols->{val} if $cols->{val};
    }
    
    my $record;
    my $kvh = $self->pinterp->{pairs} || $self->input;

    foreach my $k (keys %$kvh){
        next if $self->pinterp->{key}{$k};

        my $to_record = {
            $name_col => $k,
            $val_col => +$kvh->{$k}
        };

        my $key = $self->pinterp->{key};
        if ( $key ){
            foreach my $k (keys %$key){
                $to_record->{ $k } = $key->{ $k };
            }
        }

        $record = $self->record_row( $to_record );

    }

    my $rec_hash = { $record->get_columns };

    return [ $rec_hash ];
}


1;
                        
