# Generated by default/object.tt
package Paws::LexModelsV2::SlotDefaultValueSpecification;
  use Moose;
  has DefaultValueList => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::SlotDefaultValue]', request_name => 'defaultValueList', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::SlotDefaultValueSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::SlotDefaultValueSpecification object:

  $service_obj->Method(Att1 => { DefaultValueList => $value, ..., DefaultValueList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::SlotDefaultValueSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValueList

=head1 DESCRIPTION

Defines a list of values that Amazon Lex should use as the default
value for a slot.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultValueList => ArrayRef[L<Paws::LexModelsV2::SlotDefaultValue>]

A list of default values. Amazon Lex chooses the default value to use
in the order that they are presented in the list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

