# Generated by default/object.tt
package Paws::SecurityHub::AwsCloudTrailTrailDetails;
  use Moose;
  has CloudWatchLogsLogGroupArn => (is => 'ro', isa => 'Str');
  has CloudWatchLogsRoleArn => (is => 'ro', isa => 'Str');
  has HasCustomEventSelectors => (is => 'ro', isa => 'Bool');
  has HomeRegion => (is => 'ro', isa => 'Str');
  has IncludeGlobalServiceEvents => (is => 'ro', isa => 'Bool');
  has IsMultiRegionTrail => (is => 'ro', isa => 'Bool');
  has IsOrganizationTrail => (is => 'ro', isa => 'Bool');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has LogFileValidationEnabled => (is => 'ro', isa => 'Bool');
  has Name => (is => 'ro', isa => 'Str');
  has S3BucketName => (is => 'ro', isa => 'Str');
  has S3KeyPrefix => (is => 'ro', isa => 'Str');
  has SnsTopicArn => (is => 'ro', isa => 'Str');
  has SnsTopicName => (is => 'ro', isa => 'Str');
  has TrailArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCloudTrailTrailDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCloudTrailTrailDetails object:

  $service_obj->Method(Att1 => { CloudWatchLogsLogGroupArn => $value, ..., TrailArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCloudTrailTrailDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudWatchLogsLogGroupArn

=head1 DESCRIPTION

Provides details about a CloudTrail trail.

=head1 ATTRIBUTES


=head2 CloudWatchLogsLogGroupArn => Str

The ARN of the log group that CloudTrail logs are delivered to.


=head2 CloudWatchLogsRoleArn => Str

The ARN of the role that the CloudWatch Logs endpoint assumes when it
writes to the log group.


=head2 HasCustomEventSelectors => Bool

Indicates whether the trail has custom event selectors.


=head2 HomeRegion => Str

The Region where the trail was created.


=head2 IncludeGlobalServiceEvents => Bool

Indicates whether the trail publishes events from global services such
as IAM to the log files.


=head2 IsMultiRegionTrail => Bool

Indicates whether the trail applies only to the current Region or to
all Regions.


=head2 IsOrganizationTrail => Bool

Whether the trail is created for all accounts in an organization in AWS
Organizations, or only for the current AWS account.


=head2 KmsKeyId => Str

The AWS KMS key ID to use to encrypt the logs.


=head2 LogFileValidationEnabled => Bool

Indicates whether CloudTrail log file validation is enabled.


=head2 Name => Str

The name of the trail.


=head2 S3BucketName => Str

The name of the S3 bucket where the log files are published.


=head2 S3KeyPrefix => Str

The S3 key prefix. The key prefix is added after the name of the S3
bucket where the log files are published.


=head2 SnsTopicArn => Str

The ARN of the SNS topic that is used for notifications of log file
delivery.


=head2 SnsTopicName => Str

The name of the SNS topic that is used for notifications of log file
delivery.


=head2 TrailArn => Str

The ARN of the trail.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

