# Generated by default/object.tt
package Paws::Appflow::ExecutionResult;
  use Moose;
  has BytesProcessed => (is => 'ro', isa => 'Int', request_name => 'bytesProcessed', traits => ['NameInRequest']);
  has BytesWritten => (is => 'ro', isa => 'Int', request_name => 'bytesWritten', traits => ['NameInRequest']);
  has ErrorInfo => (is => 'ro', isa => 'Paws::Appflow::ErrorInfo', request_name => 'errorInfo', traits => ['NameInRequest']);
  has RecordsProcessed => (is => 'ro', isa => 'Int', request_name => 'recordsProcessed', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ExecutionResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ExecutionResult object:

  $service_obj->Method(Att1 => { BytesProcessed => $value, ..., RecordsProcessed => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ExecutionResult object:

  $result = $service_obj->Method(...);
  $result->Att1->BytesProcessed

=head1 DESCRIPTION

Specifies the end result of the flow run.

=head1 ATTRIBUTES


=head2 BytesProcessed => Int

The total number of bytes processed by the flow run.


=head2 BytesWritten => Int

The total number of bytes written as a result of the flow run.


=head2 ErrorInfo => L<Paws::Appflow::ErrorInfo>

Provides any error message information related to the flow run.


=head2 RecordsProcessed => Int

The number of records processed in the flow run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

