#include <parser.hpp>

using namespace std;
namespace TokenType = Enum::Token::Type;
namespace SyntaxType = Enum::Parser::Syntax;
namespace TokenKind = Enum::Token::Kind;

#define type(tk) tk->info.type
#define kind(tk) tk->info.kind

AssignCompleter::AssignCompleter(void)
{
}

bool AssignCompleter::complete(Token *tk, size_t current_idx)
{
	if (isAssign(tk, current_idx - 2)) {
		insertExpr(tk, current_idx - 2, 3);
		return true;
	}
	return false;
}

bool AssignCompleter::isAssign(Token *tk, int current_idx)
{
	if (current_idx < 0) return false;
	if (tk->token_num <= 3) return false;
	if (tk->token_num <= current_idx + 2) return false;
	Token *next_tk = tk->tks[current_idx + 1];
	if (kind(next_tk) == TokenKind::Assign) return true;
	return false;
}
