#include <common.hpp>

TokenInfo decl_tokens[] = {
	{Enum::Token::Type::Return, Enum::Token::Kind::Return, "Return", "return"},
	{Enum::Token::Type::Add, Enum::Token::Kind::Operator, "Add", "+"},
	{Enum::Token::Type::Sub, Enum::Token::Kind::Operator, "Sub", "-"},
	{Enum::Token::Type::Mul, Enum::Token::Kind::Operator, "Mul", "*"},
	{Enum::Token::Type::Div, Enum::Token::Kind::Operator, "Div", "/"},
	{Enum::Token::Type::Mod, Enum::Token::Kind::Operator, "Mod", "%"},
	{Enum::Token::Type::ThreeTermOperator, Enum::Token::Kind::Operator, "ThreeTermOperator", "?"},
	{Enum::Token::Type::Greater, Enum::Token::Kind::Operator, "Greater", ">"},
	{Enum::Token::Type::Less, Enum::Token::Kind::Operator, "Less", "<"},
	{Enum::Token::Type::StringAdd, Enum::Token::Kind::Operator, "StringAdd", "."},
	{Enum::Token::Type::Ref, Enum::Token::Kind::Operator, "Ref", "\\"},
	{Enum::Token::Type::Glob, Enum::Token::Kind::Operator, "Glob", "*"},
	{Enum::Token::Type::BitNot, Enum::Token::Kind::Operator, "BitNot", "~"},
	{Enum::Token::Type::BitOr, Enum::Token::Kind::Operator, "BitOr", "|"},
	{Enum::Token::Type::Or, Enum::Token::Kind::Operator, "Or", "or"},
	{Enum::Token::Type::BitAnd, Enum::Token::Kind::Operator, "BitAnd", "&"},
	{Enum::Token::Type::And, Enum::Token::Kind::Operator, "And", "and"},
	{Enum::Token::Type::BitXOr, Enum::Token::Kind::Operator, "BitXOr", "^"},
	{Enum::Token::Type::XOr, Enum::Token::Kind::Operator, "XOr", "xor"},
	{Enum::Token::Type::StringMul, Enum::Token::Kind::Operator, "StringMul", "x"},
	{Enum::Token::Type::AddEqual, Enum::Token::Kind::Assign, "AddEqual", "+="},
	{Enum::Token::Type::SubEqual, Enum::Token::Kind::Assign, "SubEqual", "-="},
	{Enum::Token::Type::MulEqual, Enum::Token::Kind::Assign, "MulEqual", "*="},
	{Enum::Token::Type::DivEqual, Enum::Token::Kind::Assign, "DivEqual", "/="},
	{Enum::Token::Type::ModEqual, Enum::Token::Kind::Assign, "ModEqual", "%="},
	{Enum::Token::Type::StringAdd, Enum::Token::Kind::Assign, "StringAdd", ".="},
	{Enum::Token::Type::GreaterEqual, Enum::Token::Kind::Operator, "GreaterEqual", ">="},
	{Enum::Token::Type::LessEqual, Enum::Token::Kind::Operator, "LessEqual", "<="},
	{Enum::Token::Type::EqualEqual, Enum::Token::Kind::Operator, "EqualEqual", "=="},
	{Enum::Token::Type::Diamond, Enum::Token::Kind::Operator, "Diamond", "<>"},
	{Enum::Token::Type::Compare, Enum::Token::Kind::Operator, "Compare", "<=>"},
	{Enum::Token::Type::PolymorphicCompare, Enum::Token::Kind::Operator, "PolymorphicCompare", "~~"},
	{Enum::Token::Type::RegOK, Enum::Token::Kind::Operator, "RegOK", "=~"},
	{Enum::Token::Type::RegNot, Enum::Token::Kind::Operator, "RegNot", "!~"},
	{Enum::Token::Type::NotEqual, Enum::Token::Kind::Operator, "NotEqual", "!="},
	{Enum::Token::Type::StringLess, Enum::Token::Kind::Operator, "StringLess", "lt"},
	{Enum::Token::Type::StringLessEqual, Enum::Token::Kind::Operator, "StringLessEqual", "le"},
	{Enum::Token::Type::StringGreater, Enum::Token::Kind::Operator, "StringGreater", "gt"},
	{Enum::Token::Type::StringGreaterEqual, Enum::Token::Kind::Operator, "StringGreaterEqual", "ge"},
	{Enum::Token::Type::StringEqual, Enum::Token::Kind::Operator, "StringEqual", "eq"},
	{Enum::Token::Type::StringNotEqual, Enum::Token::Kind::Operator, "StringNotEqual", "ne"},
	{Enum::Token::Type::StringCompare, Enum::Token::Kind::Operator, "StringCompare", "cmp"},
	{Enum::Token::Type::Inc, Enum::Token::Kind::Operator, "Inc", "++"},
	{Enum::Token::Type::Dec, Enum::Token::Kind::Operator, "Dec", "--"},
	{Enum::Token::Type::Exp, Enum::Token::Kind::Operator, "Exp", "**"},
	{Enum::Token::Type::PowerEqual, Enum::Token::Kind::Assign, "PowerEqual", "**="},
	{Enum::Token::Type::DefaultEqual, Enum::Token::Kind::Assign, "DefaultEqual", "//="},
	{Enum::Token::Type::LeftShift, Enum::Token::Kind::Operator, "LeftShift", "<<"},
	{Enum::Token::Type::RightShift, Enum::Token::Kind::Operator, "RightShift", ">>"},
	{Enum::Token::Type::And, Enum::Token::Kind::Operator, "And", "&&"},
	{Enum::Token::Type::Or, Enum::Token::Kind::Operator, "Or", "||"},
	{Enum::Token::Type::AndBitEqual, Enum::Token::Kind::Assign, "AndBitEqual", "&="},
	{Enum::Token::Type::OrBitEqual, Enum::Token::Kind::Assign, "OrBitEqual", "|="},
	{Enum::Token::Type::NotBitEqual, Enum::Token::Kind::Assign, "NotBitEqual", "^="},
	{Enum::Token::Type::OrEqual, Enum::Token::Kind::Assign, "OrEqual", "||="},
	{Enum::Token::Type::AndEqual, Enum::Token::Kind::Assign, "AndEqual", "&&="},
	{Enum::Token::Type::Slice, Enum::Token::Kind::Operator, "Slice", ".."},
	{Enum::Token::Type::DefaultOperator, Enum::Token::Kind::Operator, "DefaultOperator", "//"},
	{Enum::Token::Type::ToDo, Enum::Token::Kind::Operator, "ToDo", "..."},
	{Enum::Token::Type::VarDecl, Enum::Token::Kind::Decl, "VarDecl", "my"},
	{Enum::Token::Type::FunctionDecl, Enum::Token::Kind::Decl, "FunctionDecl", "sub"},
	{Enum::Token::Type::Method, Enum::Token::Kind::Function, "Method", ""},
	{Enum::Token::Type::Assign, Enum::Token::Kind::Assign, "Assign", "="},
	{Enum::Token::Type::ArraySize, Enum::Token::Kind::SingleTerm, "ArraySize", "$#"},
	{Enum::Token::Type::Is, Enum::Token::Kind::SingleTerm, "Is", ""},
	{Enum::Token::Type::IsNot, Enum::Token::Kind::SingleTerm, "IsNot", "!"},
	{Enum::Token::Type::Not, Enum::Token::Kind::SingleTerm, "Not", "not"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chomp"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chop"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chr"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "crypt"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "index"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "lc"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "lcfirst"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "length"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "ord"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "pack"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "unpack"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sort"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "reverse"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "rindex"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sprintf"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "substr"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "uc"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "ucfirst"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "pos"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "quotemeta"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "split"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "study"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "pop"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "push"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "splice"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shift"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "unshift"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "grep"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "join"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "map"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "delete"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "each"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "exists"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "keys"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "values"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "binmode"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "close"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "closedir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "dbmclose"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "dbmopen"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "die"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "eof"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "fileno"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "flock"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "format"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getc"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "print"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "say"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "printf"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "read"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "readdir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "rewinddir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "seek"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "seekdir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "select"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "syscall"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sysread"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sysseek"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "syswrite"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "tell"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "telldir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "truncate"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "warn"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "write"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "vec"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chdir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chmod"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chown"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chroot"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "fcntl"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "glob"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "ioctl"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "link"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "lstat"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "mkdir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "open"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "opendir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "readlink"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "rename"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "rmdir"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "stat"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "symlink"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "umask"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "unlink"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "utime"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "caller"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "dump"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "eval"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "exit"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "wantarray"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "formline"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "reset"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "scalar"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "alarm"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "exec"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "fork"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpgrp"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getppid"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpriority"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "kill"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "pipe"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setpgrp"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setpriority"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sleep"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "system"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "times"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "wait"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "waitpid"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "no"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "tie"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "tied"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "untie"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "accept"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "bind"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "connect"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpeername"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getsockname"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getsockopt"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "listen"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "recv"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "send"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setsockopt"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shutdown"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "socket"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "socketpair"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "msgctl"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "msgget"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "msgrcv"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "msgsnd"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "semctl"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "semget"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "semop"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shmctl"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shmget"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shmread"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "shmwrite"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endgrent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endhostent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endnetent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endpwent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getgrent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getgrgid"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getgrnam"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getlogin"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpwent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpwnam"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getpwuid"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setgrent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setpwent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endprotoent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "endservent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "gethostbyaddr"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "gethostbyname"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "gethostent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getnetbyaddr"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getnetbyname"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getnetent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getprotobyname"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getprotobynumber"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getprotoent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getservbyname"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getservbyport"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "getservent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sethostent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setnetent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setprotoent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "setservent"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "gmtime"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "localtime"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "time"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "ref"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "bless"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "defined"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "abs"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "atan2"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "cos"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "exp"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "hex"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "int"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "log"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "oct"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "rand"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sin"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "sqrt"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "srand"},
	{Enum::Token::Type::RequireDecl, Enum::Token::Kind::Decl, "RequireDecl", "require"},
	{Enum::Token::Type::Import, Enum::Token::Kind::Import, "Import", "import"},
	{Enum::Token::Type::SpecificKeyword, Enum::Token::Kind::SpecificKeyword, "SpecificKeyword", "__PACKAGE__"},
	{Enum::Token::Type::SpecificKeyword, Enum::Token::Kind::SpecificKeyword, "SpecificKeyword", "__FILE__"},
	{Enum::Token::Type::SpecificKeyword, Enum::Token::Kind::SpecificKeyword, "SpecificKeyword", "__LINE__"},
	{Enum::Token::Type::SpecificKeyword, Enum::Token::Kind::SpecificKeyword, "SpecificKeyword", "__SUB__"},
	{Enum::Token::Type::DataWord, Enum::Token::Kind::DataWord, "DataWord", "__DATA__"},
	{Enum::Token::Type::DataWord, Enum::Token::Kind::DataWord, "DataWord", "__END__"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "BEGIN"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "CHECK"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "INIT"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "END"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "UNITCHECK"},
	{Enum::Token::Type::AUTOLOAD, Enum::Token::Kind::AUTOLOAD, "AUTOLOAD", "AUTOLOAD"},
	{Enum::Token::Type::CORE, Enum::Token::Kind::CORE, "CORE", "CORE"},
	{Enum::Token::Type::DESTROY, Enum::Token::Kind::DESTROY, "DESTROY", "DESTROY"},
	{Enum::Token::Type::STDIN, Enum::Token::Kind::Handle, "STDIN", "STDIN"},
	{Enum::Token::Type::STDOUT, Enum::Token::Kind::Handle, "STDOUT", "STDOUT"},
	{Enum::Token::Type::STDERR, Enum::Token::Kind::Handle, "STDERR", "STDERR"},
	{Enum::Token::Type::Redo, Enum::Token::Kind::Redo, "Redo", "redo"},
	{Enum::Token::Type::Next, Enum::Token::Kind::Next, "Next", "next"},
	{Enum::Token::Type::Last, Enum::Token::Kind::Last, "Last", "last"},
	{Enum::Token::Type::Goto, Enum::Token::Kind::Goto, "Goto", "goto"},
	{Enum::Token::Type::Continue, Enum::Token::Kind::Continue, "Continue", "continue"},
	{Enum::Token::Type::Do, Enum::Token::Kind::Do, "Do", "do"},
	{Enum::Token::Type::Break, Enum::Token::Kind::Break, "Break", "break"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-b"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-c"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-d"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-e"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-f"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-g"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-k"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-l"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-o"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-p"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-r"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-s"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-t"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-u"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-w"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-x"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-z"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-A"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-B"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-C"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-M"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-O"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-R"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-S"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-T"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-W"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-X"},
	{Enum::Token::Type::LocalDecl, Enum::Token::Kind::Decl, "LocalDecl", "local"},
	{Enum::Token::Type::OurDecl, Enum::Token::Kind::Decl, "OurDecl", "our"},
	{Enum::Token::Type::StateDecl, Enum::Token::Kind::Decl, "StateDecl", "state"},
	{Enum::Token::Type::UseDecl, Enum::Token::Kind::Decl, "UseDecl", "use"},
	{Enum::Token::Type::UsedName, Enum::Token::Kind::Module, "UsedName", ""},
	{Enum::Token::Type::RequiredName, Enum::Token::Kind::Module, "RequiredName", ""},
	{Enum::Token::Type::IfStmt, Enum::Token::Kind::Stmt, "IfStmt", "if"},
	{Enum::Token::Type::ElseStmt, Enum::Token::Kind::Stmt, "ElseStmt", "else"},
	{Enum::Token::Type::ElsifStmt, Enum::Token::Kind::Stmt, "ElsifStmt", "elsif"},
	{Enum::Token::Type::UnlessStmt, Enum::Token::Kind::Stmt, "UnlessStmt", "unless"},
	{Enum::Token::Type::UntilStmt, Enum::Token::Kind::Stmt, "UntilStmt", "until"},
	{Enum::Token::Type::WhenStmt, Enum::Token::Kind::Stmt, "WhenStmt", "when"},
	{Enum::Token::Type::GivenStmt, Enum::Token::Kind::Stmt, "GivenStmt", "given"},
	{Enum::Token::Type::DefaultStmt, Enum::Token::Kind::DefaultStmt, "DefaultStmt", "default"},
	{Enum::Token::Type::Comma, Enum::Token::Kind::Comma, "Comma", ","},
	{Enum::Token::Type::Colon, Enum::Token::Kind::Colon, "Colon", ":"},
	{Enum::Token::Type::SemiColon, Enum::Token::Kind::StmtEnd, "SemiColon", ";"},
	{Enum::Token::Type::LeftParenthesis, Enum::Token::Kind::Symbol, "LeftParenthesis", "("},
	{Enum::Token::Type::RightParenthesis, Enum::Token::Kind::Symbol, "RightParenthesis", ")"},
	{Enum::Token::Type::LeftBrace, Enum::Token::Kind::Symbol, "LeftBrace", "{"},
	{Enum::Token::Type::RightBrace, Enum::Token::Kind::Symbol, "RightBrace", "}"},
	{Enum::Token::Type::LeftBracket, Enum::Token::Kind::Symbol, "LeftBracket", "["},
	{Enum::Token::Type::RightBracket, Enum::Token::Kind::Symbol, "RightBracket", "]"},
	{Enum::Token::Type::ArrayDereference, Enum::Token::Kind::Modifier, "ArrayDereference", "@{"},
	{Enum::Token::Type::HashDereference, Enum::Token::Kind::Modifier, "HashDereference", "%{"},
	{Enum::Token::Type::ScalarDereference, Enum::Token::Kind::Modifier, "ScalarDereference", "${"},
	{Enum::Token::Type::ShortScalarDereference, Enum::Token::Kind::Modifier, "ShortScalarDereference", ""},
	{Enum::Token::Type::ShortArrayDereference, Enum::Token::Kind::Modifier, "ShortArrayDereference", "@$"},
	{Enum::Token::Type::ShortHashDereference, Enum::Token::Kind::Modifier, "ShortHashDereference", "%$"},
	{Enum::Token::Type::ShortCodeDereference, Enum::Token::Kind::Modifier, "ShortCodeDereference", "&$"},
	{Enum::Token::Type::ArraySizeDereference, Enum::Token::Kind::Modifier, "ArraySizeDereference", "$#{"},
	{Enum::Token::Type::Key, Enum::Token::Kind::Term, "Key", ""},
	{Enum::Token::Type::BareWord, Enum::Token::Kind::Term, "BareWord", ""},
	{Enum::Token::Type::Arrow, Enum::Token::Kind::Operator, "Arrow", "=>"},
	{Enum::Token::Type::Pointer, Enum::Token::Kind::Operator, "Pointer", "->"},
	{Enum::Token::Type::NamespaceResolver, Enum::Token::Kind::Operator, "NamespaceResolver", "::"},
	{Enum::Token::Type::Namespace, Enum::Token::Kind::Namespace, "Namespace", ""},
	{Enum::Token::Type::Package, Enum::Token::Kind::Package, "Package", "package"},
	{Enum::Token::Type::Class, Enum::Token::Kind::Class, "Class", ""},
	{Enum::Token::Type::CallDecl, Enum::Token::Kind::Decl, "CallDecl", "&"},
	{Enum::Token::Type::CodeRef, Enum::Token::Kind::SingleTerm, "CodeRef", "\\&"},
	{Enum::Token::Type::WhileStmt, Enum::Token::Kind::Stmt, "WhileStmt", "while"},
	{Enum::Token::Type::ForStmt, Enum::Token::Kind::Stmt, "ForStmt", "for"},
	{Enum::Token::Type::ForeachStmt, Enum::Token::Kind::Stmt, "ForeachStmt", "foreach"},
	{Enum::Token::Type::Annotation, Enum::Token::Kind::Annotation, "Annotation", "#@"},
	{Enum::Token::Type::ArgumentArray, Enum::Token::Kind::Term, "ArgumentArray", "@_"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$_"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$0"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$1"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$2"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$3"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$4"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$5"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$6"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$7"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$8"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$9"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$&"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$`"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$'"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$+"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$."},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$/"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$|"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$*"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$,"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$\\"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$\""},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$%"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$="},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$-"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$~"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$:"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$?"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$!"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$@"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$$"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$<"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$>"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$("},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$)"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$["},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$]"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$;"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^A"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^D"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^E"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^F"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^G"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^H"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^I"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^L"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^M"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^O"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^P"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^R"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^T"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^W"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$^X"},
	{Enum::Token::Type::ConstValue, Enum::Token::Kind::Term, "ConstValue", ""},
	{Enum::Token::Type::ProgramArgument, Enum::Token::Kind::Term, "ProgramArgument", "@ARGV"},
	{Enum::Token::Type::LibraryDirectories, Enum::Token::Kind::Term, "LibraryDirectories", "@INC"},
	{Enum::Token::Type::Environment, Enum::Token::Kind::Term, "Environment", "%ENV"},
	{Enum::Token::Type::Include, Enum::Token::Kind::Term, "Include", "%INC"},
	{Enum::Token::Type::Signal, Enum::Token::Kind::Term, "Signal", "%SIG"},
	{Enum::Token::Type::RegOpt, Enum::Token::Kind::RegOpt, "RegOpt", ""},
	{Enum::Token::Type::RegQuote, Enum::Token::Kind::RegPrefix, "RegQuote", "q"},
	{Enum::Token::Type::RegDoubleQuote, Enum::Token::Kind::RegPrefix, "RegDoubleQuote", "qq"},
	{Enum::Token::Type::RegList, Enum::Token::Kind::RegPrefix, "RegList", "qw"},
	{Enum::Token::Type::RegExec, Enum::Token::Kind::RegPrefix, "RegExec", "qx"},
	{Enum::Token::Type::RegDecl, Enum::Token::Kind::RegPrefix, "RegDecl", "qr"},
	{Enum::Token::Type::RegMatch, Enum::Token::Kind::RegPrefix, "RegMatch", "m"},
	{Enum::Token::Type::RegDelim, Enum::Token::Kind::Term, "RegDelim", ""},
	{Enum::Token::Type::HandleDelim, Enum::Token::Kind::Term, "HandleDelim", ""},
	{Enum::Token::Type::RegMiddleDelim, Enum::Token::Kind::Term, "RegMiddleDelim", ""},
	{Enum::Token::Type::RegAllReplace, Enum::Token::Kind::RegReplacePrefix, "RegAllReplace", "tr"},
	{Enum::Token::Type::RegAllReplace, Enum::Token::Kind::RegReplacePrefix, "RegAllReplace", "y"},
	{Enum::Token::Type::RegReplace, Enum::Token::Kind::RegReplacePrefix, "RegReplace", "s"},
	{Enum::Token::Type::RegReplaceFrom, Enum::Token::Kind::Term, "RegReplaceFrom", ""},
	{Enum::Token::Type::RegReplaceTo, Enum::Token::Kind::Term, "RegReplaceTo", ""},
	{Enum::Token::Type::FieldDecl, Enum::Token::Kind::Decl, "FieldDecl", ""},
	{Enum::Token::Type::TypeRef, Enum::Token::Kind::Ref, "TypeRef", ""},
	{Enum::Token::Type::LabelRef, Enum::Token::Kind::Ref, "LabelRef", ""},
	{Enum::Token::Type::LocalVarDecl, Enum::Token::Kind::Decl, "LocalVarDecl", ""},
	{Enum::Token::Type::GlobalVarDecl, Enum::Token::Kind::Decl, "GlobalVarDecl", ""},
	{Enum::Token::Type::MultiLocalVarDecl, Enum::Token::Kind::Decl, "MultiLocalVarDecl", ""},
	{Enum::Token::Type::MultiGlobalVarDecl, Enum::Token::Kind::Decl, "MultiGlobalVarDecl", ""},
	{Enum::Token::Type::Prototype, Enum::Token::Kind::Term, "Prototype", ""},
	{Enum::Token::Type::Var, Enum::Token::Kind::Term, "Var", ""},
	{Enum::Token::Type::CodeVar, Enum::Token::Kind::Term, "CodeVar", ""},
	{Enum::Token::Type::ArrayVar, Enum::Token::Kind::Term, "ArrayVar", ""},
	{Enum::Token::Type::HashVar, Enum::Token::Kind::Term, "HashVar", ""},
	{Enum::Token::Type::Int, Enum::Token::Kind::Term, "Int", ""},
	{Enum::Token::Type::Double, Enum::Token::Kind::Term, "Double", ""},
	{Enum::Token::Type::String, Enum::Token::Kind::Term, "String", ""},
	{Enum::Token::Type::RawString, Enum::Token::Kind::Term, "RawString", ""},
	{Enum::Token::Type::ExecString, Enum::Token::Kind::Term, "ExecString", ""},
	{Enum::Token::Type::VersionString, Enum::Token::Kind::Term, "VersionString", ""},
	{Enum::Token::Type::HereDocumentTag, Enum::Token::Kind::Term, "HereDocumentTag", ""},
	{Enum::Token::Type::HereDocumentRawTag, Enum::Token::Kind::Term, "HereDocumentRawTag", ""},
	{Enum::Token::Type::HereDocumentExecTag, Enum::Token::Kind::Term, "HereDocumentExecTag", ""},
	{Enum::Token::Type::RawHereDocument, Enum::Token::Kind::Term, "RawHereDocument", ""},
	{Enum::Token::Type::HereDocument, Enum::Token::Kind::Term, "HereDocument", ""},
	{Enum::Token::Type::HereDocumentEnd, Enum::Token::Kind::Term, "HereDocumentEnd", ""},
	{Enum::Token::Type::FormatDecl, Enum::Token::Kind::Decl, "FormatDecl", ""},
	{Enum::Token::Type::Format, Enum::Token::Kind::Term, "Format", ""},
	{Enum::Token::Type::FormatEnd, Enum::Token::Kind::Term, "FormatEnd", ""},
	{Enum::Token::Type::Object, Enum::Token::Kind::Term, "Object", ""},
	{Enum::Token::Type::RegExp, Enum::Token::Kind::Term, "RegExp", ""},
	{Enum::Token::Type::Array, Enum::Token::Kind::Term, "Array", ""},
	{Enum::Token::Type::Hash, Enum::Token::Kind::Term, "Hash", ""},
	{Enum::Token::Type::Operator, Enum::Token::Kind::Operator, "Operator", ""},
	{Enum::Token::Type::LocalVar, Enum::Token::Kind::Term, "LocalVar", ""},
	{Enum::Token::Type::LocalArrayVar, Enum::Token::Kind::Term, "LocalArrayVar", ""},
	{Enum::Token::Type::LocalHashVar, Enum::Token::Kind::Term, "LocalHashVar", ""},
	{Enum::Token::Type::GlobalVar, Enum::Token::Kind::Term, "GlobalVar", ""},
	{Enum::Token::Type::GlobalArrayVar, Enum::Token::Kind::Term, "GlobalArrayVar", ""},
	{Enum::Token::Type::GlobalHashVar, Enum::Token::Kind::Term, "GlobalHashVar", ""},
	{Enum::Token::Type::ArrayRef, Enum::Token::Kind::Ref, "ArrayRef", ""},
	{Enum::Token::Type::HashRef, Enum::Token::Kind::Ref, "HashRef", ""},
	{Enum::Token::Type::ArrayAt, Enum::Token::Kind::Get, "ArrayAt", ""},
	{Enum::Token::Type::HashAt, Enum::Token::Kind::Get, "HashAt", ""},
	{Enum::Token::Type::ArraySet, Enum::Token::Kind::Set, "ArraySet", ""},
	{Enum::Token::Type::HashSet, Enum::Token::Kind::Set, "HashSet", ""},
	{Enum::Token::Type::Function, Enum::Token::Kind::Decl, "Function", ""},
	{Enum::Token::Type::Call, Enum::Token::Kind::Function, "Call", ""},
	{Enum::Token::Type::Argument, Enum::Token::Kind::Term, "Argument", ""},
	{Enum::Token::Type::List, Enum::Token::Kind::Term, "List", ""},
	{Enum::Token::Type::Default, Enum::Token::Kind::Term, "Default", "undef"},
	{Enum::Token::Type::Pod, Enum::Token::Kind::Verbose, "Pod", ""},
	{Enum::Token::Type::Comment, Enum::Token::Kind::Verbose, "Comment", ""},
	{Enum::Token::Type::WhiteSpace, Enum::Token::Kind::Verbose, "WhiteSpace", ""},
	{Enum::Token::Type::Undefined, Enum::Token::Kind::Undefined, "Undefined", ""}
};

TokenInfo type_to_info[] = {
	{Enum::Token::Type::Return, Enum::Token::Kind::Return, "Return", "return"},
	{Enum::Token::Type::Add, Enum::Token::Kind::Operator, "Add", "+"},
	{Enum::Token::Type::Sub, Enum::Token::Kind::Operator, "Sub", "-"},
	{Enum::Token::Type::Mul, Enum::Token::Kind::Operator, "Mul", "*"},
	{Enum::Token::Type::Div, Enum::Token::Kind::Operator, "Div", "/"},
	{Enum::Token::Type::Mod, Enum::Token::Kind::Operator, "Mod", "%"},
	{Enum::Token::Type::ThreeTermOperator, Enum::Token::Kind::Operator, "ThreeTermOperator", "?"},
	{Enum::Token::Type::Greater, Enum::Token::Kind::Operator, "Greater", ">"},
	{Enum::Token::Type::Less, Enum::Token::Kind::Operator, "Less", "<"},
	{Enum::Token::Type::StringAdd, Enum::Token::Kind::Operator, "StringAdd", "."},
	{Enum::Token::Type::Ref, Enum::Token::Kind::Operator, "Ref", "\\"},
	{Enum::Token::Type::Glob, Enum::Token::Kind::Operator, "Glob", "*"},
	{Enum::Token::Type::BitNot, Enum::Token::Kind::Operator, "BitNot", "~"},
	{Enum::Token::Type::BitOr, Enum::Token::Kind::Operator, "BitOr", "|"},
	{Enum::Token::Type::Or, Enum::Token::Kind::Operator, "Or", "or"},
	{Enum::Token::Type::BitAnd, Enum::Token::Kind::Operator, "BitAnd", "&"},
	{Enum::Token::Type::And, Enum::Token::Kind::Operator, "And", "and"},
	{Enum::Token::Type::BitXOr, Enum::Token::Kind::Operator, "BitXOr", "^"},
	{Enum::Token::Type::XOr, Enum::Token::Kind::Operator, "XOr", "xor"},
	{Enum::Token::Type::StringMul, Enum::Token::Kind::Operator, "StringMul", "x"},
	{Enum::Token::Type::AddEqual, Enum::Token::Kind::Assign, "AddEqual", "+="},
	{Enum::Token::Type::SubEqual, Enum::Token::Kind::Assign, "SubEqual", "-="},
	{Enum::Token::Type::MulEqual, Enum::Token::Kind::Assign, "MulEqual", "*="},
	{Enum::Token::Type::DivEqual, Enum::Token::Kind::Assign, "DivEqual", "/="},
	{Enum::Token::Type::ModEqual, Enum::Token::Kind::Assign, "ModEqual", "%="},
	{Enum::Token::Type::GreaterEqual, Enum::Token::Kind::Operator, "GreaterEqual", ">="},
	{Enum::Token::Type::LessEqual, Enum::Token::Kind::Operator, "LessEqual", "<="},
	{Enum::Token::Type::EqualEqual, Enum::Token::Kind::Operator, "EqualEqual", "=="},
	{Enum::Token::Type::Diamond, Enum::Token::Kind::Operator, "Diamond", "<>"},
	{Enum::Token::Type::Compare, Enum::Token::Kind::Operator, "Compare", "<=>"},
	{Enum::Token::Type::PolymorphicCompare, Enum::Token::Kind::Operator, "PolymorphicCompare", "~~"},
	{Enum::Token::Type::RegOK, Enum::Token::Kind::Operator, "RegOK", "=~"},
	{Enum::Token::Type::RegNot, Enum::Token::Kind::Operator, "RegNot", "!~"},
	{Enum::Token::Type::NotEqual, Enum::Token::Kind::Operator, "NotEqual", "!="},
	{Enum::Token::Type::StringLess, Enum::Token::Kind::Operator, "StringLess", "lt"},
	{Enum::Token::Type::StringLessEqual, Enum::Token::Kind::Operator, "StringLessEqual", "le"},
	{Enum::Token::Type::StringGreater, Enum::Token::Kind::Operator, "StringGreater", "gt"},
	{Enum::Token::Type::StringGreaterEqual, Enum::Token::Kind::Operator, "StringGreaterEqual", "ge"},
	{Enum::Token::Type::StringEqual, Enum::Token::Kind::Operator, "StringEqual", "eq"},
	{Enum::Token::Type::StringNotEqual, Enum::Token::Kind::Operator, "StringNotEqual", "ne"},
	{Enum::Token::Type::StringCompare, Enum::Token::Kind::Operator, "StringCompare", "cmp"},
	{Enum::Token::Type::Inc, Enum::Token::Kind::Operator, "Inc", "++"},
	{Enum::Token::Type::Dec, Enum::Token::Kind::Operator, "Dec", "--"},
	{Enum::Token::Type::Exp, Enum::Token::Kind::Operator, "Exp", "**"},
	{Enum::Token::Type::PowerEqual, Enum::Token::Kind::Assign, "PowerEqual", "**="},
	{Enum::Token::Type::DefaultEqual, Enum::Token::Kind::Assign, "DefaultEqual", "//="},
	{Enum::Token::Type::LeftShift, Enum::Token::Kind::Operator, "LeftShift", "<<"},
	{Enum::Token::Type::RightShift, Enum::Token::Kind::Operator, "RightShift", ">>"},
	{Enum::Token::Type::AndBitEqual, Enum::Token::Kind::Assign, "AndBitEqual", "&="},
	{Enum::Token::Type::OrBitEqual, Enum::Token::Kind::Assign, "OrBitEqual", "|="},
	{Enum::Token::Type::NotBitEqual, Enum::Token::Kind::Assign, "NotBitEqual", "^="},
	{Enum::Token::Type::OrEqual, Enum::Token::Kind::Assign, "OrEqual", "||="},
	{Enum::Token::Type::AndEqual, Enum::Token::Kind::Assign, "AndEqual", "&&="},
	{Enum::Token::Type::Slice, Enum::Token::Kind::Operator, "Slice", ".."},
	{Enum::Token::Type::DefaultOperator, Enum::Token::Kind::Operator, "DefaultOperator", "//"},
	{Enum::Token::Type::ToDo, Enum::Token::Kind::Operator, "ToDo", "..."},
	{Enum::Token::Type::VarDecl, Enum::Token::Kind::Decl, "VarDecl", "my"},
	{Enum::Token::Type::FunctionDecl, Enum::Token::Kind::Decl, "FunctionDecl", "sub"},
	{Enum::Token::Type::Method, Enum::Token::Kind::Function, "Method", ""},
	{Enum::Token::Type::Assign, Enum::Token::Kind::Assign, "Assign", "="},
	{Enum::Token::Type::ArraySize, Enum::Token::Kind::SingleTerm, "ArraySize", "$#"},
	{Enum::Token::Type::Is, Enum::Token::Kind::SingleTerm, "Is", ""},
	{Enum::Token::Type::IsNot, Enum::Token::Kind::SingleTerm, "IsNot", "!"},
	{Enum::Token::Type::Not, Enum::Token::Kind::SingleTerm, "Not", "not"},
	{Enum::Token::Type::BuiltinFunc, Enum::Token::Kind::Function, "BuiltinFunc", "chomp"},
	{Enum::Token::Type::RequireDecl, Enum::Token::Kind::Decl, "RequireDecl", "require"},
	{Enum::Token::Type::Import, Enum::Token::Kind::Import, "Import", "import"},
	{Enum::Token::Type::SpecificKeyword, Enum::Token::Kind::SpecificKeyword, "SpecificKeyword", "__PACKAGE__"},
	{Enum::Token::Type::DataWord, Enum::Token::Kind::DataWord, "DataWord", "__DATA__"},
	{Enum::Token::Type::ModWord, Enum::Token::Kind::ModWord, "ModWord", "BEGIN"},
	{Enum::Token::Type::AUTOLOAD, Enum::Token::Kind::AUTOLOAD, "AUTOLOAD", "AUTOLOAD"},
	{Enum::Token::Type::CORE, Enum::Token::Kind::CORE, "CORE", "CORE"},
	{Enum::Token::Type::DESTROY, Enum::Token::Kind::DESTROY, "DESTROY", "DESTROY"},
	{Enum::Token::Type::STDIN, Enum::Token::Kind::Handle, "STDIN", "STDIN"},
	{Enum::Token::Type::STDOUT, Enum::Token::Kind::Handle, "STDOUT", "STDOUT"},
	{Enum::Token::Type::STDERR, Enum::Token::Kind::Handle, "STDERR", "STDERR"},
	{Enum::Token::Type::Redo, Enum::Token::Kind::Redo, "Redo", "redo"},
	{Enum::Token::Type::Next, Enum::Token::Kind::Next, "Next", "next"},
	{Enum::Token::Type::Last, Enum::Token::Kind::Last, "Last", "last"},
	{Enum::Token::Type::Goto, Enum::Token::Kind::Goto, "Goto", "goto"},
	{Enum::Token::Type::Continue, Enum::Token::Kind::Continue, "Continue", "continue"},
	{Enum::Token::Type::Do, Enum::Token::Kind::Do, "Do", "do"},
	{Enum::Token::Type::Break, Enum::Token::Kind::Break, "Break", "break"},
	{Enum::Token::Type::Handle, Enum::Token::Kind::Handle, "Handle", "-b"},
	{Enum::Token::Type::LocalDecl, Enum::Token::Kind::Decl, "LocalDecl", "local"},
	{Enum::Token::Type::OurDecl, Enum::Token::Kind::Decl, "OurDecl", "our"},
	{Enum::Token::Type::StateDecl, Enum::Token::Kind::Decl, "StateDecl", "state"},
	{Enum::Token::Type::UseDecl, Enum::Token::Kind::Decl, "UseDecl", "use"},
	{Enum::Token::Type::UsedName, Enum::Token::Kind::Module, "UsedName", ""},
	{Enum::Token::Type::RequiredName, Enum::Token::Kind::Module, "RequiredName", ""},
	{Enum::Token::Type::IfStmt, Enum::Token::Kind::Stmt, "IfStmt", "if"},
	{Enum::Token::Type::ElseStmt, Enum::Token::Kind::Stmt, "ElseStmt", "else"},
	{Enum::Token::Type::ElsifStmt, Enum::Token::Kind::Stmt, "ElsifStmt", "elsif"},
	{Enum::Token::Type::UnlessStmt, Enum::Token::Kind::Stmt, "UnlessStmt", "unless"},
	{Enum::Token::Type::UntilStmt, Enum::Token::Kind::Stmt, "UntilStmt", "until"},
	{Enum::Token::Type::WhenStmt, Enum::Token::Kind::Stmt, "WhenStmt", "when"},
	{Enum::Token::Type::GivenStmt, Enum::Token::Kind::Stmt, "GivenStmt", "given"},
	{Enum::Token::Type::DefaultStmt, Enum::Token::Kind::DefaultStmt, "DefaultStmt", "default"},
	{Enum::Token::Type::Comma, Enum::Token::Kind::Comma, "Comma", ","},
	{Enum::Token::Type::Colon, Enum::Token::Kind::Colon, "Colon", ":"},
	{Enum::Token::Type::SemiColon, Enum::Token::Kind::StmtEnd, "SemiColon", ";"},
	{Enum::Token::Type::LeftParenthesis, Enum::Token::Kind::Symbol, "LeftParenthesis", "("},
	{Enum::Token::Type::RightParenthesis, Enum::Token::Kind::Symbol, "RightParenthesis", ")"},
	{Enum::Token::Type::LeftBrace, Enum::Token::Kind::Symbol, "LeftBrace", "{"},
	{Enum::Token::Type::RightBrace, Enum::Token::Kind::Symbol, "RightBrace", "}"},
	{Enum::Token::Type::LeftBracket, Enum::Token::Kind::Symbol, "LeftBracket", "["},
	{Enum::Token::Type::RightBracket, Enum::Token::Kind::Symbol, "RightBracket", "]"},
	{Enum::Token::Type::ArrayDereference, Enum::Token::Kind::Modifier, "ArrayDereference", "@{"},
	{Enum::Token::Type::HashDereference, Enum::Token::Kind::Modifier, "HashDereference", "%{"},
	{Enum::Token::Type::ScalarDereference, Enum::Token::Kind::Modifier, "ScalarDereference", "${"},
	{Enum::Token::Type::ShortScalarDereference, Enum::Token::Kind::Modifier, "ShortScalarDereference", ""},
	{Enum::Token::Type::ShortArrayDereference, Enum::Token::Kind::Modifier, "ShortArrayDereference", "@$"},
	{Enum::Token::Type::ShortHashDereference, Enum::Token::Kind::Modifier, "ShortHashDereference", "%$"},
	{Enum::Token::Type::ShortCodeDereference, Enum::Token::Kind::Modifier, "ShortCodeDereference", "&$"},
	{Enum::Token::Type::ArraySizeDereference, Enum::Token::Kind::Modifier, "ArraySizeDereference", "$#{"},
	{Enum::Token::Type::Key, Enum::Token::Kind::Term, "Key", ""},
	{Enum::Token::Type::BareWord, Enum::Token::Kind::Term, "BareWord", ""},
	{Enum::Token::Type::Arrow, Enum::Token::Kind::Operator, "Arrow", "=>"},
	{Enum::Token::Type::Pointer, Enum::Token::Kind::Operator, "Pointer", "->"},
	{Enum::Token::Type::NamespaceResolver, Enum::Token::Kind::Operator, "NamespaceResolver", "::"},
	{Enum::Token::Type::Namespace, Enum::Token::Kind::Namespace, "Namespace", ""},
	{Enum::Token::Type::Package, Enum::Token::Kind::Package, "Package", "package"},
	{Enum::Token::Type::Class, Enum::Token::Kind::Class, "Class", ""},
	{Enum::Token::Type::CallDecl, Enum::Token::Kind::Decl, "CallDecl", "&"},
	{Enum::Token::Type::CodeRef, Enum::Token::Kind::SingleTerm, "CodeRef", "\\&"},
	{Enum::Token::Type::WhileStmt, Enum::Token::Kind::Stmt, "WhileStmt", "while"},
	{Enum::Token::Type::ForStmt, Enum::Token::Kind::Stmt, "ForStmt", "for"},
	{Enum::Token::Type::ForeachStmt, Enum::Token::Kind::Stmt, "ForeachStmt", "foreach"},
	{Enum::Token::Type::Annotation, Enum::Token::Kind::Annotation, "Annotation", "#@"},
	{Enum::Token::Type::ArgumentArray, Enum::Token::Kind::Term, "ArgumentArray", "@_"},
	{Enum::Token::Type::SpecificValue, Enum::Token::Kind::Term, "SpecificValue", "$_"},
	{Enum::Token::Type::ConstValue, Enum::Token::Kind::Term, "ConstValue", ""},
	{Enum::Token::Type::ProgramArgument, Enum::Token::Kind::Term, "ProgramArgument", "@ARGV"},
	{Enum::Token::Type::LibraryDirectories, Enum::Token::Kind::Term, "LibraryDirectories", "@INC"},
	{Enum::Token::Type::Environment, Enum::Token::Kind::Term, "Environment", "%ENV"},
	{Enum::Token::Type::Include, Enum::Token::Kind::Term, "Include", "%INC"},
	{Enum::Token::Type::Signal, Enum::Token::Kind::Term, "Signal", "%SIG"},
	{Enum::Token::Type::RegOpt, Enum::Token::Kind::RegOpt, "RegOpt", ""},
	{Enum::Token::Type::RegQuote, Enum::Token::Kind::RegPrefix, "RegQuote", "q"},
	{Enum::Token::Type::RegDoubleQuote, Enum::Token::Kind::RegPrefix, "RegDoubleQuote", "qq"},
	{Enum::Token::Type::RegList, Enum::Token::Kind::RegPrefix, "RegList", "qw"},
	{Enum::Token::Type::RegExec, Enum::Token::Kind::RegPrefix, "RegExec", "qx"},
	{Enum::Token::Type::RegDecl, Enum::Token::Kind::RegPrefix, "RegDecl", "qr"},
	{Enum::Token::Type::RegMatch, Enum::Token::Kind::RegPrefix, "RegMatch", "m"},
	{Enum::Token::Type::RegDelim, Enum::Token::Kind::Term, "RegDelim", ""},
	{Enum::Token::Type::HandleDelim, Enum::Token::Kind::Term, "HandleDelim", ""},
	{Enum::Token::Type::RegMiddleDelim, Enum::Token::Kind::Term, "RegMiddleDelim", ""},
	{Enum::Token::Type::RegAllReplace, Enum::Token::Kind::RegReplacePrefix, "RegAllReplace", "tr"},
	{Enum::Token::Type::RegReplace, Enum::Token::Kind::RegReplacePrefix, "RegReplace", "s"},
	{Enum::Token::Type::RegReplaceFrom, Enum::Token::Kind::Term, "RegReplaceFrom", ""},
	{Enum::Token::Type::RegReplaceTo, Enum::Token::Kind::Term, "RegReplaceTo", ""},
	{Enum::Token::Type::FieldDecl, Enum::Token::Kind::Decl, "FieldDecl", ""},
	{Enum::Token::Type::TypeRef, Enum::Token::Kind::Ref, "TypeRef", ""},
	{Enum::Token::Type::LabelRef, Enum::Token::Kind::Ref, "LabelRef", ""},
	{Enum::Token::Type::LocalVarDecl, Enum::Token::Kind::Decl, "LocalVarDecl", ""},
	{Enum::Token::Type::GlobalVarDecl, Enum::Token::Kind::Decl, "GlobalVarDecl", ""},
	{Enum::Token::Type::MultiLocalVarDecl, Enum::Token::Kind::Decl, "MultiLocalVarDecl", ""},
	{Enum::Token::Type::MultiGlobalVarDecl, Enum::Token::Kind::Decl, "MultiGlobalVarDecl", ""},
	{Enum::Token::Type::Prototype, Enum::Token::Kind::Term, "Prototype", ""},
	{Enum::Token::Type::Var, Enum::Token::Kind::Term, "Var", ""},
	{Enum::Token::Type::CodeVar, Enum::Token::Kind::Term, "CodeVar", ""},
	{Enum::Token::Type::ArrayVar, Enum::Token::Kind::Term, "ArrayVar", ""},
	{Enum::Token::Type::HashVar, Enum::Token::Kind::Term, "HashVar", ""},
	{Enum::Token::Type::Int, Enum::Token::Kind::Term, "Int", ""},
	{Enum::Token::Type::Double, Enum::Token::Kind::Term, "Double", ""},
	{Enum::Token::Type::String, Enum::Token::Kind::Term, "String", ""},
	{Enum::Token::Type::RawString, Enum::Token::Kind::Term, "RawString", ""},
	{Enum::Token::Type::ExecString, Enum::Token::Kind::Term, "ExecString", ""},
	{Enum::Token::Type::VersionString, Enum::Token::Kind::Term, "VersionString", ""},
	{Enum::Token::Type::HereDocumentTag, Enum::Token::Kind::Term, "HereDocumentTag", ""},
	{Enum::Token::Type::HereDocumentRawTag, Enum::Token::Kind::Term, "HereDocumentRawTag", ""},
	{Enum::Token::Type::HereDocumentExecTag, Enum::Token::Kind::Term, "HereDocumentExecTag", ""},
	{Enum::Token::Type::RawHereDocument, Enum::Token::Kind::Term, "RawHereDocument", ""},
	{Enum::Token::Type::HereDocument, Enum::Token::Kind::Term, "HereDocument", ""},
	{Enum::Token::Type::HereDocumentEnd, Enum::Token::Kind::Term, "HereDocumentEnd", ""},
	{Enum::Token::Type::FormatDecl, Enum::Token::Kind::Decl, "FormatDecl", ""},
	{Enum::Token::Type::Format, Enum::Token::Kind::Term, "Format", ""},
	{Enum::Token::Type::FormatEnd, Enum::Token::Kind::Term, "FormatEnd", ""},
	{Enum::Token::Type::Object, Enum::Token::Kind::Term, "Object", ""},
	{Enum::Token::Type::RegExp, Enum::Token::Kind::Term, "RegExp", ""},
	{Enum::Token::Type::Array, Enum::Token::Kind::Term, "Array", ""},
	{Enum::Token::Type::Hash, Enum::Token::Kind::Term, "Hash", ""},
	{Enum::Token::Type::Operator, Enum::Token::Kind::Operator, "Operator", ""},
	{Enum::Token::Type::LocalVar, Enum::Token::Kind::Term, "LocalVar", ""},
	{Enum::Token::Type::LocalArrayVar, Enum::Token::Kind::Term, "LocalArrayVar", ""},
	{Enum::Token::Type::LocalHashVar, Enum::Token::Kind::Term, "LocalHashVar", ""},
	{Enum::Token::Type::GlobalVar, Enum::Token::Kind::Term, "GlobalVar", ""},
	{Enum::Token::Type::GlobalArrayVar, Enum::Token::Kind::Term, "GlobalArrayVar", ""},
	{Enum::Token::Type::GlobalHashVar, Enum::Token::Kind::Term, "GlobalHashVar", ""},
	{Enum::Token::Type::ArrayRef, Enum::Token::Kind::Ref, "ArrayRef", ""},
	{Enum::Token::Type::HashRef, Enum::Token::Kind::Ref, "HashRef", ""},
	{Enum::Token::Type::ArrayAt, Enum::Token::Kind::Get, "ArrayAt", ""},
	{Enum::Token::Type::HashAt, Enum::Token::Kind::Get, "HashAt", ""},
	{Enum::Token::Type::ArraySet, Enum::Token::Kind::Set, "ArraySet", ""},
	{Enum::Token::Type::HashSet, Enum::Token::Kind::Set, "HashSet", ""},
	{Enum::Token::Type::Function, Enum::Token::Kind::Decl, "Function", ""},
	{Enum::Token::Type::Call, Enum::Token::Kind::Function, "Call", ""},
	{Enum::Token::Type::Argument, Enum::Token::Kind::Term, "Argument", ""},
	{Enum::Token::Type::List, Enum::Token::Kind::Term, "List", ""},
	{Enum::Token::Type::Default, Enum::Token::Kind::Term, "Default", "undef"},
	{Enum::Token::Type::Pod, Enum::Token::Kind::Verbose, "Pod", ""},
	{Enum::Token::Type::Comment, Enum::Token::Kind::Verbose, "Comment", ""},
	{Enum::Token::Type::WhiteSpace, Enum::Token::Kind::Verbose, "WhiteSpace", ""},
	{Enum::Token::Type::Undefined, Enum::Token::Kind::Undefined, "Undefined", ""}
};

