/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.scanbit;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.scanbit.ScanBit;
import com.ctreber.acearth.scanbit.ScanBitGenerator;
import com.ctreber.acearth.scanbit.ScanBuf;
import com.ctreber.acearth.util.EdgeCrossing;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;
import com.ctreber.acearth.util.Polygon;
import com.ctreber.aclib.sort.CTSort;
import com.ctreber.aclib.sort.QuickSort;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class BitGeneratorMap
extends ScanBitGenerator {
    public static final int PixTypeSpace = 0;
    public static final int PixTypeLand = 1;
    public static final int PixTypeWater = 2;
    public static final int PixTypeStar = 3;
    public static final int PixTypeGridLand = 4;
    public static final int PixTypeGridWater = 5;
    private Polygon[] fMapData;
    Projection fProjection;
    private List fScanbitsVector = new ArrayList();
    List fEdgeCrossings;

    protected abstract ScanBuf scanOutline();

    protected abstract void handleCrossings(ScanBuf var1, EdgeCrossing[] var2);

    protected abstract Comparator getEdgeXingComparator();

    protected abstract void scanPolygon(ScanBuf var1, Point3D[] var2, Point2D[] var3, int var4);

    public BitGeneratorMap(Projection projection) {
        this.fProjection = projection;
    }

    public void generateScanBits() {
        this.fScanbitsVector = new ArrayList();
        this.fProjection.setImageWidth(this.fImageWidth);
        this.fProjection.setImageHeight(this.fImageHeight);
        this.fProjection.initTransformTable();
        ScanBuf scanBuf = this.scanOutline();
        this.fScanbitsVector.addAll(scanBuf.getScanbits(64));
        this.scanPolygons();
        QuickSort quickSort = new QuickSort();
        this.fScanBitsArray = this.fScanbitsVector.toArray(new ScanBit[0]);
        quickSort.sort(this.fScanBitsArray);
    }

    private void scanPolygons() {
        for (int i = 0; i < this.fMapData.length; ++i) {
            Polygon polygon = this.fMapData[i];
            Point3D[] point3DArray = new Point3D[polygon.getSize()];
            Point2D[] point2DArray = new Point2D[polygon.getSize()];
            this.transformPolygonPoints(polygon, point3DArray, point2DArray);
            this.fEdgeCrossings = new ArrayList();
            ScanBuf scanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
            for (int j = 0; j < point2DArray.length; ++j) {
                this.scanPolygon(scanBuf, point3DArray, point2DArray, j);
            }
            if (this.fEdgeCrossings.size() > 0) {
                Object[] objectArray = this.fEdgeCrossings.toArray(new EdgeCrossing[0]);
                QuickSort quickSort = new QuickSort();
                ((CTSort)quickSort).sort(objectArray, this.getEdgeXingComparator());
                this.handleCrossings(scanBuf, (EdgeCrossing[])objectArray);
            }
            if (!scanBuf.containsPoints()) continue;
            this.fScanbitsVector.addAll(scanBuf.getScanbits(polygon.getType()));
        }
    }

    private void transformPolygonPoints(Polygon polygon, Point3D[] point3DArray, Point2D[] point2DArray) {
        for (int i = 0; i < polygon.getPoints().length; ++i) {
            Point3D point3D;
            Point3D point3D2 = polygon.getPoints()[i];
            point3DArray[i] = point3D = this.fProjection.rotate(point3D2);
            point2DArray[i] = this.fProjection.project2D(point3D);
        }
    }

    public void setMapData(Polygon[] polygonArray) {
        this.fMapData = polygonArray;
    }

    protected void addEdgeXing(EdgeCrossing edgeCrossing) {
        this.fEdgeCrossings.add(edgeCrossing);
    }
}

