/*	$OpenBSD: logo.c,v 1.1 2023/02/15 12:43:32 aoyama Exp $	*/

/*
 * Copyright (c) 2023 Kenji Aoyama
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>
#include <machine/board.h>

#define LUNAFB_OFFSET	2	/* LUNA's fb has 2 words (64 pixels) offset */
#define WORDS_PER_LINE	64
#define LOGO_XSIZE	4	/* in word, i.e. 4 x 32 = 128 pixels */
#define LOGO_YSIZE	128
#define LOGO_XOFFSET	0	/* in word */
#define LOGO_YOFFSET	40

u_int32_t pattern[LOGO_YSIZE][LOGO_XSIZE];

void
draw_logo(void)
{
	int i, j;
	u_int32_t *p = (u_int32_t *)(BMAP_BMP) + LUNAFB_OFFSET
			+ LOGO_XOFFSET + LOGO_YOFFSET * WORDS_PER_LINE;
	u_int32_t *q;

	for(i = 0; i < LOGO_YSIZE; i++) {
		q = p;
		for (j = 0; j < LOGO_XSIZE; j++) {
			*p++ = pattern[i][j];
		}	
		p = q + WORDS_PER_LINE;
	}
}

/* OpenBSD Puffy 128x128, displayed in black on while */
u_int32_t pattern[LOGO_YSIZE][LOGO_XSIZE] = {
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 0 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 1 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 2 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 3 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 4 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 5 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 6 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 7 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 8 */
	{ 0x00000000, 0x00000000, 0x00400000, 0x00000000, }, /* 9 */
	{ 0x00000000, 0x00000000, 0x00c00000, 0x00000000, }, /* 10 */
	{ 0x00000000, 0x00000000, 0x00c00000, 0x00000000, }, /* 11 */
	{ 0x00000000, 0x00000000, 0x00c00000, 0x00000000, }, /* 12 */
	{ 0x00000000, 0x00000002, 0x00c00000, 0x00000000, }, /* 13 */
	{ 0x00000000, 0x00002003, 0x00c00000, 0x00000000, }, /* 14 */
	{ 0x00000000, 0x00003003, 0x00c02000, 0x00000000, }, /* 15 */
	{ 0x00000000, 0x00003803, 0x11e23000, 0x00000000, }, /* 16 */
	{ 0x00000000, 0x00001823, 0x99a27001, 0x00000000, }, /* 17 */
	{ 0x00000000, 0x000c1c33, 0x99267001, 0x00000000, }, /* 18 */
	{ 0x00000000, 0x000e1e32, 0xdf3e7103, 0x00000000, }, /* 19 */
	{ 0x00000000, 0x000e0b3a, 0x7e1ff103, 0x00000000, }, /* 20 */
	{ 0x00000000, 0x000709fe, 0x7001f106, 0x00000000, }, /* 21 */
	{ 0x00000000, 0x0005087e, 0x6000db0e, 0x00000000, }, /* 22 */
	{ 0x00000000, 0x00079802, 0x60009f9a, 0x00000000, }, /* 23 */
	{ 0x00000000, 0x0002f802, 0x200093f2, 0x00000000, }, /* 24 */
	{ 0x00000000, 0x20227002, 0x200110e2, 0x20000000, }, /* 25 */
	{ 0x00000000, 0x30336002, 0x11011002, 0xe0000000, }, /* 26 */
	{ 0x00000000, 0x181b2080, 0x11021007, 0xd8000000, }, /* 27 */
	{ 0x00000000, 0x0c1f10c0, 0x01801001, 0x98000000, }, /* 28 */
	{ 0x00000000, 0x0f1d88c0, 0x01801080, 0xf0000000, }, /* 29 */
	{ 0x00000000, 0x07f880e0, 0x03801080, 0x70000000, }, /* 30 */
	{ 0x0000000e, 0x02608060, 0x02800180, 0xb1018000, }, /* 31 */
	{ 0x00000007, 0x83008070, 0x02400301, 0x3f038000, }, /* 32 */
	{ 0x00000006, 0xc3008050, 0x02400302, 0x2e0f0000, }, /* 33 */
	{ 0x00000003, 0x33000048, 0x02400504, 0x667e0000, }, /* 34 */
	{ 0x00000001, 0x9e00004c, 0x00000900, 0x43ec0000, }, /* 35 */
	{ 0x00000000, 0xc60c0040, 0x00001100, 0x41880000, }, /* 36 */
	{ 0x00000002, 0x63860040, 0x20040100, 0x40100000, }, /* 37 */
	{ 0x00000003, 0xf0e70000, 0x60040100, 0x40300000, }, /* 38 */
	{ 0x00000781, 0xf8038000, 0x700a0100, 0x00600000, }, /* 39 */
	{ 0x000003c0, 0xf8016000, 0x50120000, 0x00600000, }, /* 40 */
	{ 0x000001ff, 0xfc000180, 0x10000000, 0x007e0000, }, /* 41 */
	{ 0x000000c7, 0x060000c0, 0x00000000, 0x08380000, }, /* 42 */
	{ 0x00000060, 0x02000020, 0x000000c0, 0x18380000, }, /* 43 */
	{ 0x00000030, 0x00000000, 0x000001c0, 0x78100000, }, /* 44 */
	{ 0x00000018, 0x00000000, 0x00000000, 0x8c180000, }, /* 45 */
	{ 0x000000f8, 0x00040001, 0x00020081, 0x041c0000, }, /* 46 */
	{ 0x00000038, 0x00030000, 0x00000002, 0x021e0000, }, /* 47 */
	{ 0x00000008, 0x38018000, 0x00000004, 0x030b0000, }, /* 48 */
	{ 0x00000008, 0x1f01e000, 0x0000000c, 0x01098000, }, /* 49 */
	{ 0x00000e18, 0x07f08000, 0x00000008, 0x00888000, }, /* 50 */
	{ 0x00000f90, 0x03008000, 0x0000000b, 0xff88c000, }, /* 51 */
	{ 0x00000e78, 0x01000000, 0x0000001e, 0x01cfc000, }, /* 52 */
	{ 0x00000387, 0x80800000, 0x0000001c, 0x0089e000, }, /* 53 */
	{ 0x000001c0, 0x00800000, 0x00000004, 0x0c8cc000, }, /* 54 */
	{ 0x00000060, 0x00400000, 0x00000004, 0x1e8ec000, }, /* 55 */
	{ 0x00000078, 0x00000000, 0x00000006, 0x0c8ec000, }, /* 56 */
	{ 0x07f00e78, 0x00000000, 0x0000000f, 0x008cc000, }, /* 57 */
	{ 0x1e1c03fc, 0x18080000, 0x00000001, 0xc08ce000, }, /* 58 */
	{ 0x3c0600e2, 0x30e00000, 0x00000000, 0x718ce000, }, /* 59 */
	{ 0xfc018040, 0x60600000, 0x00000000, 0x190d3000, }, /* 60 */
	{ 0x0700c040, 0x08000000, 0x00000000, 0x0f0f1800, }, /* 61 */
	{ 0x030060c0, 0x00000000, 0x00000000, 0x060f0800, }, /* 62 */
	{ 0x018030c0, 0x00000000, 0x00000000, 0x0619cc00, }, /* 63 */
	{ 0x01c01fc1, 0x00000000, 0x00000000, 0x06206c00, }, /* 64 */
	{ 0x00c00646, 0x00000080, 0x00000000, 0x06002600, }, /* 65 */
	{ 0x0060005c, 0x00000000, 0x00000008, 0x06402600, }, /* 66 */
	{ 0x0030001b, 0x8100c000, 0x00000004, 0x06802600, }, /* 67 */
	{ 0x00180000, 0xc2000000, 0x00040000, 0x07002200, }, /* 68 */
	{ 0x00180000, 0x02000000, 0x00000000, 0x06086300, }, /* 69 */
	{ 0x000c0000, 0x04000000, 0x00000000, 0x06784300, }, /* 70 */
	{ 0x000c0000, 0x080000f8, 0x40000000, 0x0ff8c3c0, }, /* 71 */
	{ 0x00060000, 0x11e40387, 0xc0000000, 0x0e0fc3c0, }, /* 72 */
	{ 0x00020004, 0x3f080700, 0x00000000, 0x1e04c260, }, /* 73 */
	{ 0x00030020, 0x60080600, 0x10000000, 0x16044220, }, /* 74 */
	{ 0x0001c038, 0x001e0c00, 0x30000000, 0x22004610, }, /* 75 */
	{ 0x00018038, 0x00000800, 0xc0000180, 0x62004618, }, /* 76 */
	{ 0x0001803e, 0x10001801, 0x00000080, 0xc100440f, }, /* 77 */
	{ 0x0000c070, 0x20081002, 0x00000000, 0x81004c07, }, /* 78 */
	{ 0x0000c0d0, 0x60082002, 0x00004001, 0x01004f1e, }, /* 79 */
	{ 0x0000c098, 0x4010c004, 0x4001c000, 0x0180dffc, }, /* 80 */
	{ 0x00006088, 0xc8318018, 0x00008000, 0x01c1b1f0, }, /* 81 */
	{ 0x0000610d, 0xf020e030, 0x01000000, 0x01e76000, }, /* 82 */
	{ 0x0000630d, 0xe0703fe0, 0x02000000, 0x033c4000, }, /* 83 */
	{ 0x0000670f, 0xc0e007c0, 0x02000440, 0x42008000, }, /* 84 */
	{ 0x00007e0f, 0x81800000, 0x00000140, 0x40030000, }, /* 85 */
	{ 0x0000f81f, 0x00000020, 0x80000080, 0x20260000, }, /* 86 */
	{ 0x0001e039, 0x004000c0, 0x800400c1, 0x202e0000, }, /* 87 */
	{ 0x00000020, 0x80400080, 0x00040060, 0xd03f0000, }, /* 88 */
	{ 0x00000040, 0xc0c04400, 0x600c0000, 0x711b8000, }, /* 89 */
	{ 0x00000000, 0xe0804800, 0x600c0000, 0x38d88000, }, /* 90 */
	{ 0x00000001, 0xf0805000, 0x00000200, 0x18f80000, }, /* 91 */
	{ 0x00000001, 0xf9866000, 0x00002200, 0x00dc0000, }, /* 92 */
	{ 0x00000001, 0xfd8c6008, 0x00001200, 0x00c00000, }, /* 93 */
	{ 0x00000003, 0xc7184008, 0x81001a00, 0x81c00000, }, /* 94 */
	{ 0x00000003, 0x83300809, 0x81100800, 0x83c00000, }, /* 95 */
	{ 0x00000007, 0x02600805, 0x00900420, 0x07e00000, }, /* 96 */
	{ 0x00000006, 0x02600805, 0x00900318, 0x4ff00000, }, /* 97 */
	{ 0x0000000c, 0x02b80826, 0x00d00304, 0x5cf80000, }, /* 98 */
	{ 0x00000008, 0x071c0846, 0x00541106, 0x303c0000, }, /* 99 */
	{ 0x00000000, 0x06060c46, 0x41621103, 0xb00c0000, }, /* 100 */
	{ 0x00000000, 0x06078c80, 0x41231003, 0xd0000000, }, /* 101 */
	{ 0x00000000, 0x0407fc80, 0x23211003, 0xd0000000, }, /* 102 */
	{ 0x00000000, 0x0007f900, 0x2321900c, 0x28000000, }, /* 103 */
	{ 0x00000000, 0x00078980, 0x32009038, 0x1c000000, }, /* 104 */
	{ 0x00000000, 0x00070be0, 0x3200d1f0, 0x1c000000, }, /* 105 */
	{ 0x00000000, 0x00070a3e, 0x3200cff0, 0x0e000000, }, /* 106 */
	{ 0x00000000, 0x00060e1f, 0xfa01cff0, 0x00000000, }, /* 107 */
	{ 0x00000000, 0x000e0e1f, 0xffffe8f0, 0x00000000, }, /* 108 */
	{ 0x00000000, 0x000c0c0f, 0x9e7e2878, 0x00000000, }, /* 109 */
	{ 0x00000000, 0x000c000f, 0x0c7c2838, 0x00000000, }, /* 110 */
	{ 0x00000000, 0x0000000f, 0x0c3c3818, 0x00000000, }, /* 111 */
	{ 0x00000000, 0x0000000e, 0x0c3c180c, 0x00000000, }, /* 112 */
	{ 0x00000000, 0x0000000e, 0x0c1c1804, 0x00000000, }, /* 113 */
	{ 0x00000000, 0x0000000c, 0x081c0800, 0x00000000, }, /* 114 */
	{ 0x00000000, 0x0000000c, 0x00180000, 0x00000000, }, /* 115 */
	{ 0x00000000, 0x0000000c, 0x00080000, 0x00000000, }, /* 116 */
	{ 0x00000000, 0x00000000, 0x00080000, 0x00000000, }, /* 117 */
	{ 0x00000000, 0x00000000, 0x00080000, 0x00000000, }, /* 118 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 119 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 120 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 121 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 122 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 123 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 124 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 125 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 126 */
	{ 0x00000000, 0x00000000, 0x00000000, 0x00000000, }, /* 127 */
};
