/* $NetBSD: unichromeconfig.h,v 1.2 2006/08/13 20:25:47 jmcneill Exp $ */

/*
 * Copyright 1998-2006 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2006 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _DEV_PCI_UNICHROMECONFIG_H
#define _DEV_PCI_UNICHROMECONFIG_H

static struct pll_map pll_value[] = {
    {CLK_25_175M,  CLE266_PLL_25_175M,  K800_PLL_25_175M,  CX700_25_175M},
    {CLK_29_581M,  CLE266_PLL_29_581M,  K800_PLL_29_581M,  CX700_29_581M},
    {CLK_26_880M,  CLE266_PLL_26_880M,  K800_PLL_26_880M,  CX700_26_880M},
    {CLK_31_490M,  CLE266_PLL_31_490M,  K800_PLL_31_490M,  CX700_31_490M},
    {CLK_31_500M,  CLE266_PLL_31_500M,  K800_PLL_31_500M,  CX700_31_500M},
    {CLK_31_728M,  CLE266_PLL_31_728M,  K800_PLL_31_728M,  CX700_31_728M},
    {CLK_32_668M,  CLE266_PLL_32_668M,  K800_PLL_32_668M,  CX700_32_668M},
    {CLK_36_000M,  CLE266_PLL_36_000M,  K800_PLL_36_000M,  CX700_36_000M},
    {CLK_40_000M,  CLE266_PLL_40_000M,  K800_PLL_40_000M,  CX700_40_000M},
    {CLK_41_291M,  CLE266_PLL_41_291M,  K800_PLL_41_291M,  CX700_41_291M},
    {CLK_43_163M,  CLE266_PLL_43_163M,  K800_PLL_43_163M,  CX700_43_163M},
    {CLK_49_500M,  CLE266_PLL_49_500M,  K800_PLL_49_500M,  CX700_49_500M},
    {CLK_52_406M,  CLE266_PLL_52_406M,  K800_PLL_52_406M,  CX700_52_406M},
    {CLK_56_250M,  CLE266_PLL_56_250M,  K800_PLL_56_250M,  CX700_56_250M},
    {CLK_65_000M,  CLE266_PLL_65_000M,  K800_PLL_65_000M,  CX700_65_000M},
    {CLK_68_179M,  CLE266_PLL_68_179M,  K800_PLL_68_179M,  CX700_68_179M},
    {CLK_78_750M,  CLE266_PLL_78_750M,  K800_PLL_78_750M,  CX700_78_750M},
    {CLK_80_136M,  CLE266_PLL_80_136M,  K800_PLL_80_136M,  CX700_80_136M},
    {CLK_83_950M,  CLE266_PLL_83_950M,  K800_PLL_83_950M,  CX700_83_950M},
    {CLK_85_860M,  CLE266_PLL_85_860M,  K800_PLL_85_860M,  CX700_85_860M},
    {CLK_94_500M,  CLE266_PLL_94_500M,  K800_PLL_94_500M,  CX700_94_500M},
    {CLK_108_000M, CLE266_PLL_108_000M, K800_PLL_108_000M, CX700_108_000M},
    {CLK_125_104M, CLE266_PLL_125_104M, K800_PLL_125_104M, CX700_125_104M},
    {CLK_133_308M, CLE266_PLL_133_308M, K800_PLL_133_308M, CX700_133_308M},
    {CLK_135_000M, CLE266_PLL_135_000M, K800_PLL_135_000M, CX700_135_000M},
    {CLK_157_500M, CLE266_PLL_157_500M, K800_PLL_157_500M, CX700_157_500M},
    {CLK_162_000M, CLE266_PLL_162_000M, K800_PLL_162_000M, CX700_162_000M},
    {CLK_202_500M, CLE266_PLL_202_500M, K800_PLL_202_500M, CX700_202_500M},
    {CLK_234_000M, CLE266_PLL_234_000M, K800_PLL_234_000M, CX700_234_000M},
    {CLK_297_500M, CLE266_PLL_297_500M, K800_PLL_297_500M, CX700_297_500M},
    {CLK_74_481M,  CLE266_PLL_74_481M,  K800_PLL_74_481M,  CX700_74_481M},
    {CLK_172_798M, CLE266_PLL_172_798M, K800_PLL_172_798M, CX700_172_798M}
};

#define NUM_TOTAL_PLL_TABLE ARRAY_SIZE(pll_value)

static struct fifo_depth_select display_fifo_depth_reg= {
    // IGA1 FIFO Depth_Select
    {IGA1_FIFO_DEPTH_SELECT_REG_NUM, {{SR17,0,7}}},
    // IGA2 FIFO Depth_Select
    {IGA2_FIFO_DEPTH_SELECT_REG_NUM, {{CR68,4,7}, {CR94,7,7}, {CR95,7,7}}}
};

static struct fifo_threshold_select fifo_threshold_select_reg= {
    // IGA1 FIFO Threshold Select
    {IGA1_FIFO_THRESHOLD_REG_NUM, {{SR16,0,5},{SR16,7,7}}},
    // IGA2 FIFO Threshold Select
    {IGA2_FIFO_THRESHOLD_REG_NUM, {{CR68,0,3}, {CR95,4,6}}}
};

static struct fifo_high_threshold_select fifo_high_threshold_select_reg= {
    // IGA1 FIFO High Threshold Select
    {IGA1_FIFO_HIGH_THRESHOLD_REG_NUM, {{SR18,0,5},{SR18,7,7}}},
    // IGA2 FIFO High Threshold Select
    {IGA2_FIFO_HIGH_THRESHOLD_REG_NUM, {{CR92,0,3}, {CR95,0,2}}}
};

static struct display_queue_expire_num display_queue_expire_num_reg= {
    // IGA1 Display Queue Expire Num
    {IGA1_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM, {{SR22,0,4}}},
    // IGA2 Display Queue Expire Num
    {IGA2_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM, {{CR94,0,6}}}
};

// Definition Offset Registers
static struct offset offset_reg = {
    // IGA1 Offset Register
    {IGA1_OFFSET_REG_NUM, {{CR13,0,7},{CR35,5,7}}},
    // IGA2 Offset Register
    {IGA2_OFFSET_REG_NUM, {{CR66,0,7},{CR67,0,1}}}
};

// Definition Fetch Count Registers
static struct fetch_count fetch_count_reg = {
    // IGA1 Fetch Count Register
    {IGA1_FETCH_COUNT_REG_NUM, {{SR1C,0,7},{SR1D,0,1}}},
    // IGA2 Fetch Count Register
    {IGA2_FETCH_COUNT_REG_NUM, {{CR65,0,7},{CR67,2,3}}}
};

// Definition Starting Address Registers
/*static static struct starting_addr starting_addr_reg = {
    // IGA1 Starting Address Register
    {IGA1_STARTING_ADDR_REG_NUM, {{CR0C,0,7},{CR0D,0,7},{CR34,0,7},{CR48,0,1}}},
    // IGA2 Starting Address Register
    {IGA2_STARTING_ADDR_REG_NUM, {{CR62,1,7},{CR63,0,7},{CR64,0,7}}}
};*/

#define IGA1_STARTING_ADDR_REG_NUM      4           // location: {CR0C,0,7},{CR0D,0,7},{CR34,0,7},{CR48,0,1}
#define IGA2_STARTING_ADDR_REG_NUM      3           // location: {CR62,1,7},{CR63,0,7},{CR64,0,7}

static struct iga1_crtc_timing iga1_crtc_reg = {
    // IGA1 Horizontal Total
    {IGA1_HOR_TOTAL_REG_NUM, {{CR00,0,7}, {CR36,3,3}}},
    // IGA1 Horizontal Addressable Video
    {IGA1_HOR_ADDR_REG_NUM, {{CR01,0,7}}},
    // IGA1 Horizontal Blank Start
    {IGA1_HOR_BLANK_START_REG_NUM, {{CR02,0,7}}},
    // IGA1 Horizontal Blank End
    {IGA1_HOR_BLANK_END_REG_NUM, {{CR03,0,4}, {CR05,7,7}, {CR33,5,5}}},
    // IGA1 Horizontal Sync Start
    {IGA1_HOR_SYNC_START_REG_NUM, {{CR04,0,7}, {CR33,4,4}}},
    // IGA1 Horizontal Sync End
    {IGA1_HOR_SYNC_END_REG_NUM, {{CR05,0,4}}},
    // IGA1 Vertical Total
    {IGA1_VER_TOTAL_REG_NUM, {{CR06,0,7}, {CR07,0,0}, {CR07,5,5}, {CR35,0,0}}},
    // IGA1 Vertical Addressable Video
    {IGA1_VER_ADDR_REG_NUM, {{CR12,0,7}, {CR07,1,1}, {CR07,6,6}, {CR35,2,2}}},
    // IGA1 Vertical Blank Start
    {IGA1_VER_BLANK_START_REG_NUM, {{CR15,0,7}, {CR07,3,3}, {CR09,5,5}, {CR35,3,3}}},
    // IGA1 Vertical Blank End
    {IGA1_VER_BLANK_END_REG_NUM, {{CR16,0,7}}},
    // IGA1 Vertical Sync Start
    {IGA1_VER_SYNC_START_REG_NUM, {{CR10,0,7}, {CR07,2,2}, {CR07,7,7}, {CR35,1,1}}},
    // IGA1 Vertical Sync End
    {IGA1_VER_SYNC_END_REG_NUM, {{CR11,0,3}}}
};

#if notyet
static struct iga2_shadow_crtc_timing iga2_shadow_crtc_reg = {
    // IGA2 Shadow Horizontal Total
    {IGA2_SHADOW_HOR_TOTAL_REG_NUM, {{CR6D,0,7}, {CR71,3,3}}},
    // IGA2 Shadow Horizontal Blank End
    {IGA2_SHADOW_HOR_BLANK_END_REG_NUM, {{CR6E,0,7}}},
    // IGA2 Shadow Vertical Total
    {IGA2_SHADOW_VER_TOTAL_REG_NUM, {{CR6F,0,7}, {CR71,0,2}}},
    // IGA2 Shadow Vertical Addressable Video
    {IGA2_SHADOW_VER_ADDR_REG_NUM, {{CR70,0,7}, {CR71,4,6}}},
    // IGA2 Shadow Vertical Blank Start
    {IGA2_SHADOW_VER_BLANK_START_REG_NUM, {{CR72,0,7}, {CR74,4,6}}},
    // IGA2 Shadow Vertical Blank End
    {IGA2_SHADOW_VER_BLANK_END_REG_NUM, {{CR73,0,7}, {CR74,0,2}}},
    // IGA2 Shadow Vertical Sync Start
    {IGA2_SHADOW_VER_SYNC_START_REG_NUM, {{CR75,0,7}, {CR76,4,6}}},
    // IGA2 Shadow Vertical Sync End
    {IGA2_SHADOW_VER_SYNC_END_REG_NUM, {{CR76,0,3}}}
};

static struct iga2_crtc_timing iga2_crtc_reg = {
    // IGA2 Horizontal Total
    {IGA2_HOR_TOTAL_REG_NUM, {{CR50,0,7}, {CR55,0,3}}},
    // IGA2 Horizontal Addressable Video
    {IGA2_HOR_ADDR_REG_NUM, {{CR51,0,7}, {CR55,4,6}}},
    // IGA2 Horizontal Blank Start
    {IGA2_HOR_BLANK_START_REG_NUM, {{CR52,0,7}, {CR54,0,2}}},
    // IGA2 Horizontal Blank End
    {IGA2_HOR_BLANK_END_REG_NUM, {{CR53,0,7}, {CR54,3,5}, {CR5D,6,6}}},
    // IGA2 Horizontal Sync Start
    {IGA2_HOR_SYNC_START_REG_NUM, {{CR56,0,7}, {CR54,6,7}, {CR5C,7,7}}},
    // IGA2 Horizontal Sync End
    {IGA2_HOR_SYNC_END_REG_NUM, {{CR57,0,7}, {CR5C,6,6}}},
    // IGA2 Vertical Total
    {IGA2_VER_TOTAL_REG_NUM, {{CR58,0,7}, {CR5D,0,2}}},
    // IGA2 Vertical Addressable Video
    {IGA2_VER_ADDR_REG_NUM, {{CR59,0,7}, {CR5D,3,5}}},
    // IGA2 Vertical Blank Start
    {IGA2_VER_BLANK_START_REG_NUM, {{CR5A,0,7}, {CR5C,0,2}}},
    // IGA2 Vertical Blank End
    {IGA2_VER_BLANK_END_REG_NUM, {{CR5B,0,7}, {CR5C,3,5}}},
    // IGA2 Vertical Sync Start
    {IGA2_VER_SYNC_START_REG_NUM, {{CR5E,0,7}, {CR5F,5,7}}},
    // IGA2 Vertical Sync End
    {IGA2_VER_SYNC_END_REG_NUM, {{CR5F,0,4}}}
};

/*static static struct _lcd_pwd_seq_timer lcd_pwd_seq_timer = {
    // LCD Power Sequence TD0
    {LCD_POWER_SEQ_TD0_REG_NUM, {{CR8B,0,7}, {CR8F,0,3}}},
    // LCD Power Sequence TD1
    {LCD_POWER_SEQ_TD1_REG_NUM, {{CR8C,0,7}, {CR8F,4,7}}},
    // LCD Power Sequence TD2
    {LCD_POWER_SEQ_TD2_REG_NUM, {{CR8D,0,7}, {CR90,0,3}}},
    // LCD Power Sequence TD3
    {LCD_POWER_SEQ_TD3_REG_NUM, {{CR8E,0,7}, {CR90,4,7}}}

};*/

static struct _lcd_scaling_factor lcd_scaling_factor = {
    // LCD Horizontal Scaling Factor Register
    {LCD_HOR_SCALING_FACTOR_REG_NUM, {{CR9F,0,1}, {CR77,0,7}, {CR79,4,5}}},
    // LCD Vertical Scaling Factor Register
    {LCD_VER_SCALING_FACTOR_REG_NUM, {{CR79,3,3}, {CR78,0,7}, {CR79,6,7}}}
};
static struct _lcd_scaling_factor lcd_scaling_factor_CLE = {
    /* LCD Horizontal Scaling Factor Register */
    {LCD_HOR_SCALING_FACTOR_REG_NUM_CLE, {{CR77,0,7}, {CR79,4,5}}},
    /* LCD Vertical Scaling Factor Register */
    {LCD_VER_SCALING_FACTOR_REG_NUM_CLE, {{CR78,0,7}, {CR79,6,7}}}
};
#endif

static struct rgbLUT palLUT_table[]= {
    // {R,G,B}
    // Index 0x00~0x03
    {0x00, 0x00, 0x00}, {0x00, 0x00, 0x2A}, {0x00, 0x2A, 0x00}, {0x00, 0x2A, 0x2A},
    // Index 0x04~0x07
    {0x2A, 0x00, 0x00}, {0x2A, 0x00, 0x2A}, {0x2A, 0x15, 0x00}, {0x2A, 0x2A, 0x2A},
    // Index 0x08~0x0B
    {0x15, 0x15, 0x15}, {0x15, 0x15, 0x3F}, {0x15, 0x3F, 0x15}, {0x15, 0x3F, 0x3F},
    // Index 0x0C~0x0F
    {0x3F, 0x15, 0x15}, {0x3F, 0x15, 0x3F}, {0x3F, 0x3F, 0x15}, {0x3F, 0x3F, 0x3F},
    // Index 0x10~0x13
    {0x00, 0x00, 0x00}, {0x05, 0x05, 0x05}, {0x08, 0x08, 0x08}, {0x0B, 0x0B, 0x0B},
    // Index 0x14~0x17
    {0x0E, 0x0E, 0x0E}, {0x11, 0x11, 0x11}, {0x14, 0x14, 0x14}, {0x18, 0x18, 0x18},
    // Index 0x18~0x1B
    {0x1C, 0x1C, 0x1C}, {0x20, 0x20, 0x20}, {0x24, 0x24, 0x24}, {0x28, 0x28, 0x28},
    // Index 0x1C~0x1F
    {0x2D, 0x2D, 0x2D}, {0x32, 0x32, 0x32}, {0x38, 0x38, 0x38}, {0x3F, 0x3F, 0x3F},
    // Index 0x20~0x23
    {0x00, 0x00, 0x3F}, {0x10, 0x00, 0x3F}, {0x1F, 0x00, 0x3F}, {0x2F, 0x00, 0x3F},
    // Index 0x24~0x27
    {0x3F, 0x00, 0x3F}, {0x3F, 0x00, 0x2F}, {0x3F, 0x00, 0x1F}, {0x3F, 0x00, 0x10},
    // Index 0x28~0x2B
    {0x3F, 0x00, 0x00}, {0x3F, 0x10, 0x00}, {0x3F, 0x1F, 0x00}, {0x3F, 0x2F, 0x00},
    // Index 0x2C~0x2F
    {0x3F, 0x3F, 0x00}, {0x2F, 0x3F, 0x00}, {0x1F, 0x3F, 0x00}, {0x10, 0x3F, 0x00},
    // Index 0x30~0x33
    {0x00, 0x3F, 0x00}, {0x00, 0x3F, 0x10}, {0x00, 0x3F, 0x1F}, {0x00, 0x3F, 0x2F},
    // Index 0x34~0x37
    {0x00, 0x3F, 0x3F}, {0x00, 0x2F, 0x3F}, {0x00, 0x1F, 0x3F}, {0x00, 0x10, 0x3F},
    // Index 0x38~0x3B
    {0x1F, 0x1F, 0x3F}, {0x27, 0x1F, 0x3F}, {0x2F, 0x1F, 0x3F}, {0x37, 0x1F, 0x3F},
    // Index 0x3C~0x3F
    {0x3F, 0x1F, 0x3F}, {0x3F, 0x1F, 0x37}, {0x3F, 0x1F, 0x2F}, {0x3F, 0x1F, 0x27},
    // Index 0x40~0x43
    {0x3F, 0x1F, 0x1F}, {0x3F, 0x27, 0x1F}, {0x3F, 0x2F, 0x1F}, {0x3F, 0x3F, 0x1F},
    // Index 0x44~0x47
    {0x3F, 0x3F, 0x1F}, {0x37, 0x3F, 0x1F}, {0x2F, 0x3F, 0x1F}, {0x27, 0x3F, 0x1F},
    // Index 0x48~0x4B
    {0x1F, 0x3F, 0x1F}, {0x1F, 0x3F, 0x27}, {0x1F, 0x3F, 0x2F}, {0x1F, 0x3F, 0x37},
    // Index 0x4C~0x4F
    {0x1F, 0x3F, 0x3F}, {0x1F, 0x37, 0x3F}, {0x1F, 0x2F, 0x3F}, {0x1F, 0x27, 0x3F},
    // Index 0x50~0x53
    {0x2D, 0x2D, 0x3F}, {0x31, 0x2D, 0x3F}, {0x36, 0x2D, 0x3F}, {0x3A, 0x2D, 0x3F},
    // Index 0x54~0x57
    {0x3F, 0x2D, 0x3F}, {0x3F, 0x2D, 0x3A}, {0x3F, 0x2D, 0x36}, {0x3F, 0x2D, 0x31},
    // Index 0x58~0x5B
    {0x3F, 0x2D, 0x2D}, {0x3F, 0x31, 0x2D}, {0x3F, 0x36, 0x2D}, {0x3F, 0x3A, 0x2D},
    // Index 0x5C~0x5F
    {0x3F, 0x3F, 0x2D}, {0x3A, 0x3F, 0x2D}, {0x36, 0x3F, 0x2D}, {0x31, 0x3F, 0x2D},
    // Index 0x60~0x63
    {0x2D, 0x3F, 0x2D}, {0x2D, 0x3F, 0x31}, {0x2D, 0x3F, 0x36}, {0x2D, 0x3F, 0x3A},
    // Index 0x64~0x67
    {0x2D, 0x3F, 0x3F}, {0x2D, 0x3A, 0x3F}, {0x2D, 0x36, 0x3F}, {0x2D, 0x31, 0x3F},
    // Index 0x68~0x6B
    {0x00, 0x00, 0x1C}, {0x07, 0x00, 0x1C}, {0x0E, 0x00, 0x1C}, {0x15, 0x00, 0x1C},
    // Index 0x6C~0x6F
    {0x1C, 0x00, 0x1C}, {0x1C, 0x00, 0x15}, {0x1C, 0x00, 0x0E}, {0x1C, 0x00, 0x07},
    // Index 0x70~0x73
    {0x1C, 0x00, 0x00}, {0x1C, 0x07, 0x00}, {0x1C, 0x0E, 0x00}, {0x1C, 0x15, 0x00},
    // Index 0x74~0x77
    {0x1C, 0x1C, 0x00}, {0x15, 0x1C, 0x00}, {0x0E, 0x1C, 0x00}, {0x07, 0x1C, 0x00},
    // Index 0x78~0x7B
    {0x00, 0x1C, 0x00}, {0x00, 0x1C, 0x07}, {0x00, 0x1C, 0x0E}, {0x00, 0x1C, 0x15},
    // Index 0x7C~0x7F
    {0x00, 0x1C, 0x1C}, {0x00, 0x15, 0x1C}, {0x00, 0x0E, 0x1C}, {0x00, 0x07, 0x1C},
    // Index 0x80~0x83
    {0x0E, 0x0E, 0x1C}, {0x11, 0x0E, 0x1C}, {0x15, 0x0E, 0x1C}, {0x18, 0x0E, 0x1C},
    // Index 0x84~0x87
    {0x1C, 0x0E, 0x1C}, {0x1C, 0x0E, 0x18}, {0x1C, 0x0E, 0x15}, {0x1C, 0x0E, 0x11},
    // Index 0x88~0x8B
    {0x1C, 0x0E, 0x0E}, {0x1C, 0x11, 0x0E}, {0x1C, 0x15, 0x0E}, {0x1C, 0x18, 0x0E},
    // Index 0x8C~0x8F
    {0x1C, 0x1C, 0x0E}, {0x18, 0x1C, 0x0E}, {0x15, 0x1C, 0x0E}, {0x11, 0x1C, 0x0E},
    // Index 0x90~0x93
    {0x0E, 0x1C, 0x0E}, {0x0E, 0x1C, 0x11}, {0x0E, 0x1C, 0x15}, {0x0E, 0x1C, 0x18},
    // Index 0x94~0x97
    {0x0E, 0x1C, 0x1C}, {0x0E, 0x18, 0x1C}, {0x0E, 0x15, 0x1C}, {0x0E, 0x11, 0x1C},
    // Index 0x98~0x9B
    {0x14, 0x14, 0x1C}, {0x16, 0x14, 0x1C}, {0x18, 0x14, 0x1C}, {0x1A, 0x14, 0x1C},
    // Index 0x9C~0x9F
    {0x1C, 0x14, 0x1C}, {0x1C, 0x14, 0x1A}, {0x1C, 0x14, 0x18}, {0x1C, 0x14, 0x16},
    // Index 0xA0~0xA3
    {0x1C, 0x14, 0x14}, {0x1C, 0x16, 0x14}, {0x1C, 0x18, 0x14}, {0x1C, 0x1A, 0x14},
    // Index 0xA4~0xA7
    {0x1C, 0x1C, 0x14}, {0x1A, 0x1C, 0x14}, {0x18, 0x1C, 0x14}, {0x16, 0x1C, 0x14},
    // Index 0xA8~0xAB
    {0x14, 0x1C, 0x14}, {0x14, 0x1C, 0x16}, {0x14, 0x1C, 0x18}, {0x14, 0x1C, 0x1A},
    // Index 0xAC~0xAF
    {0x14, 0x1C, 0x1C}, {0x14, 0x1A, 0x1C}, {0x14, 0x18, 0x1C}, {0x14, 0x16, 0x1C},
    // Index 0xB0~0xB3
    {0x00, 0x00, 0x10}, {0x04, 0x00, 0x10}, {0x08, 0x00, 0x10}, {0x0C, 0x00, 0x10},
    // Index 0xB4~0xB7
    {0x10, 0x00, 0x10}, {0x10, 0x00, 0x0C}, {0x10, 0x00, 0x08}, {0x10, 0x00, 0x04},
    // Index 0xB8~0xBB
    {0x10, 0x00, 0x00}, {0x10, 0x04, 0x00}, {0x10, 0x08, 0x00}, {0x10, 0x0C, 0x00},
    // Index 0xBC~0xBF
    {0x10, 0x10, 0x00}, {0x0C, 0x10, 0x00}, {0x08, 0x10, 0x00}, {0x04, 0x10, 0x00},
    // Index 0xC0~0xC3
    {0x00, 0x10, 0x00}, {0x00, 0x10, 0x04}, {0x00, 0x10, 0x08}, {0x00, 0x10, 0x0C},
    // Index 0xC4~0xC7
    {0x00, 0x10, 0x10}, {0x00, 0x0C, 0x10}, {0x00, 0x08, 0x10}, {0x00, 0x04, 0x10},
    // Index 0xC8~0xCB
    {0x08, 0x08, 0x10}, {0x0A, 0x08, 0x10}, {0x0C, 0x08, 0x10}, {0x0E, 0x08, 0x10},
    // Index 0xCC~0xCF
    {0x10, 0x08, 0x10}, {0x10, 0x08, 0x0E}, {0x10, 0x08, 0x0C}, {0x10, 0x08, 0x0A},
    // Index 0xD0~0xD3
    {0x10, 0x08, 0x08}, {0x10, 0x0A, 0x08}, {0x10, 0x0C, 0x08}, {0x10, 0x0E, 0x08},
    // Index 0xD4~0xD7
    {0x10, 0x10, 0x08}, {0x0E, 0x10, 0x08}, {0x0C, 0x10, 0x08}, {0x0A, 0x10, 0x08},
    // Index 0xD8~0xDB
    {0x08, 0x10, 0x08}, {0x08, 0x10, 0x0A}, {0x08, 0x10, 0x0C}, {0x08, 0x10, 0x0E},
    // Index 0xDC~0xDF
    {0x08, 0x10, 0x10}, {0x08, 0x0E, 0x10}, {0x08, 0x0C, 0x10}, {0x08, 0x0A, 0x10},
    // Index 0xE0~0xE3
    {0x0B, 0x0B, 0x10}, {0x0C, 0x0B, 0x10}, {0x0D, 0x0B, 0x10}, {0x0F, 0x0B, 0x10},
    // Index 0xE4~0xE7
    {0x10, 0x0B, 0x10}, {0x10, 0x0B, 0x0F}, {0x10, 0x0B, 0x0D}, {0x10, 0x0B, 0x0C},
    // Index 0xE8~0xEB
    {0x10, 0x0B, 0x0B}, {0x10, 0x0C, 0x0B}, {0x10, 0x0D, 0x0B}, {0x10, 0x0F, 0x0B},
    // Index 0xEC~0xEF
    {0x10, 0x10, 0x0B}, {0x0F, 0x10, 0x0B}, {0x0D, 0x10, 0x0B}, {0x0C, 0x10, 0x0B},
    // Index 0xF0~0xF3
    {0x0B, 0x10, 0x0B}, {0x0B, 0x10, 0x0C}, {0x0B, 0x10, 0x0D}, {0x0B, 0x10, 0x0F},
    // Index 0xF4~0xF7
    {0x0B, 0x10, 0x10}, {0x0B, 0x0F, 0x10}, {0x0B, 0x0D, 0x10}, {0x0B, 0x0C, 0x10},
    // Index 0xF8~0xFB
    {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
    // Index 0xFC~0xFF
    {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

#if notyet
static uint16_t red256[] = {
0x0   ,0x0   ,0x0   ,0x0   ,0xa800,0xa800,0xa800,0xa800,0x5400,0x5400,0x5400,0x5400,0xfc00,0xfc00,0xfc00,0xfc00,
0x0   ,0x1400,0x2000,0x2c00,0x3800,0x4400,0x5000,0x6000,0x7000,0x8000,0x9000,0xa000,0xb400,0xc800,0xe000,0xfc00,
0x0   ,0x4000,0x7c00,0xbc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xbc00,0x7c00,0x4000,
0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x7c00,0x9c00,0xbc00,0xdc00,0xfc00,0xfc00,0xfc00,0xfc00,
0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xdc00,0xbc00,0x9c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,
0xb400,0xc400,0xd800,0xe800,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xe800,0xd800,0xc400,
0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0x0   ,0x1c00,0x3800,0x5400,0x7000,0x7000,0x7000,0x7000,
0x7000,0x7000,0x7000,0x7000,0x7000,0x5400,0x3800,0x1c00,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,
0x3800,0x4400,0x5400,0x6000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x6000,0x5400,0x4400,
0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x5000,0x5800,0x6000,0x6800,0x7000,0x7000,0x7000,0x7000,
0x7000,0x7000,0x7000,0x7000,0x7000,0x6800,0x6000,0x5800,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,
0x0   ,0x1000,0x2000,0x3000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x3000,0x2000,0x1000,
0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x2000,0x2800,0x3000,0x3800,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x3800,0x3000,0x2800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2c00,0x3000,0x3400,0x3c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x3c00,0x3400,0x3000,
0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0
};
static uint16_t green256[] = {
0x0   ,0x0   ,0xa800,0xa800,0x0   ,0x0   ,0x5400,0xa800,0x5400,0x5400,0xfc00,0xfc00,0x5400,0x5400,0xfc00,0xfc00,
0x0   ,0x1400,0x2000,0x2c00,0x3800,0x4400,0x5000,0x6000,0x7000,0x8000,0x9000,0xa000,0xb400,0xc800,0xe000,0xfc00,
0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x7c00,0xbc00,0xfc00,0xfc00,0xfc00,0xfc00,
0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xbc00,0x7c00,0x4000,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,
0x7c00,0x9c00,0xbc00,0xdc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xdc00,0xbc00,0x9c00,
0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xc400,0xd800,0xe800,0xfc00,0xfc00,0xfc00,0xfc00,
0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xe800,0xd800,0xc400,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,
0x0   ,0x1c00,0x3800,0x5400,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x5400,0x3800,0x1c00,
0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x4400,0x5400,0x6000,0x7000,0x7000,0x7000,0x7000,
0x7000,0x7000,0x7000,0x7000,0x7000,0x6000,0x5400,0x4400,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,
0x5000,0x5800,0x6000,0x6800,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x6800,0x6000,0x5800,
0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x1000,0x2000,0x3000,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x3000,0x2000,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
0x2000,0x2800,0x3000,0x3800,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x3800,0x3000,0x2800,
0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x3000,0x3400,0x3c00,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x3c00,0x3400,0x3000,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0
};
static uint16_t blue256[] = {
0x0   ,0xa800,0x0   ,0xa800,0x0   ,0xa800,0x0   ,0xa800,0x5400,0xfc00,0x5400,0xfc00,0x5400,0xfc00,0x5400,0xfc00,
0x0   ,0x1400,0x2000,0x2c00,0x3800,0x4400,0x5000,0x6000,0x7000,0x8000,0x9000,0xa000,0xb400,0xc800,0xe000,0xfc00,
0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xbc00,0x7c00,0x4000,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,
0x0   ,0x4000,0x7c00,0xbc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xdc00,0xbc00,0x9c00,
0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x9c00,0xbc00,0xdc00,0xfc00,0xfc00,0xfc00,0xfc00,
0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xe800,0xd800,0xc400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,0xb400,
0xb400,0xc400,0xd800,0xe800,0xfc00,0xfc00,0xfc00,0xfc00,0x7000,0x7000,0x7000,0x7000,0x7000,0x5400,0x3800,0x1c00,
0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x1c00,0x3800,0x5400,0x7000,0x7000,0x7000,0x7000,
0x7000,0x7000,0x7000,0x7000,0x7000,0x6000,0x5400,0x4400,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,
0x3800,0x4400,0x5400,0x6000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x6800,0x6000,0x5800,
0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5800,0x6000,0x6800,0x7000,0x7000,0x7000,0x7000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x3000,0x2000,0x1000,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,
0x0   ,0x1000,0x2000,0x3000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x3800,0x3000,0x2800,
0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2800,0x3000,0x3800,0x4000,0x4000,0x4000,0x4000,
0x4000,0x4000,0x4000,0x4000,0x4000,0x3c00,0x3400,0x3000,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,0x2c00,
0x2c00,0x3000,0x3400,0x3c00,0x4000,0x4000,0x4000,0x4000,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0   ,0x0
};
#endif

#endif /* _DEV_PCI_UNICHROMECONFIG_H */
