/*	$NetBSD: vtpbcvar.h,v 1.4 2008/04/28 20:23:10 martin Exp $	*/

/*-
 * Copyright (c) 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <dev/pci/pcivar.h>

struct vtpbc_config {
	vaddr_t		vt_addr;	/* address of the V3 PBC */
	vaddr_t		vt_cfgbase;	/* PCI configuration space base */
	int		vt_adbase;	/* AD line base for config access */
	int		vt_rev;		/* silicon revision */

	/*
	 * These are here in order to support the old-style PCI address
	 * map used by boards with older firmware (mostly on P-4032
	 * boards).
	 */
	bus_addr_t	vt_pci_iobase;	/* PCI I/O space base */
	bus_addr_t	vt_pci_membase;	/* PCI memory space base */
	bus_addr_t	vt_dma_winbase;	/* DMA window base */
};

#ifdef _KERNEL
extern struct vtpbc_config vtpbc_configuration;
extern const char *vtpbc_revs[];
extern const int vtpbc_nrevs;

void	vtpbc_init(pci_chipset_tag_t, struct vtpbc_config *);
#endif /* _KERNEL */
