/* $NetBSD: ar9344reg.h,v 1.2 2011/07/10 23:13:23 matt Exp $ */

/*-
 * Copyright (c) 2010 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Matt Thomas of 3am Software Foundry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	_MIPS_ATHEROS_AR9344REG_H_
#define	_MIPS_ATHEROS_AR9344REG_H_

#define	AR9344_MEM0_BASE		0x00000000	/* sdram */
#define	AR9344_MEM1_BASE		0x08000000	/* sdram/flash */
#define	AR9344_MEM3_BASE		0x10000000	/* flash */
#define	AR7100_PCI_BASE			0x17001000
#define	ARCHIP_DDR_BASE			0x18000000
#define	AR9344_UART0_BASE		0x18020000	/* low speed */
#define	AR7100_UART_BASE		0x18020000	/* low speed */
#define	AR9344_USB_CONFIG_BASE		0x18030000
#define	AR9344_GPIO_BASE		0x18040000
#define	ARCHIP_PLL_BASE			0x18050000
#define	ARCHIP_RESET_BASE		0x18060000
#define	AR9344_GMAC_BASE		0x18070000
#define	AR7100_MII_BASE			0x18070000
#define	AR9344_GMAC0_INGRESS_BASE	0x18080000
#define	AR7100_GMAC0_BASE		0x18090000
#define	AR9344_MBOX_BASE		0x180A0000
#define	AR7100_GMAC1_BASE		0x180A0000
#define	AR9344_SLIC_BASE		0x180A9000
#define	AR9344_STEREO_BASE		0x180B0000
#define	AR9344_MDIO_BASE		0x180B8000
#define	AR9344_PCIE_RC_BASE		0x180C0000
#define	AR9344_PCIE_RC_BASE2		0x180F0000
#define	AR9344_WDMA_BASE		0x18100000
#define	AR9344_RTC_BASE			0x18107000
#define	AR9344_UART1_BASE		0x18150000	/* high speed */
#define	AR9344_GMAC0_BASE		0x19000000
#define	AR9344_GMAC1_BASE		0x1A000000
#define	AR9344_USB_BASE			0x1B000000
#define	AR7100_EHCI_BASE		0x1B000000
#define	AR9344_NAND_BASE		0x1B000200
#define	AR7100_OHCI_BASE		0x1C000000
#define	AR7100_SPI_BASE			0x1F000000
#define	AR9344_SPI_BASE			0x1FFF0000

/*
 * PLL registers -- offset relative to AR9344_PLL_BASE
 */
#define	ARCHIP_PLL_CPU_PLL_CONFIG		0x0000
#define	ARCHIP_PLL_DDR_PLL_CONFIG		0x0004
#define	ARCHIP_PLL_CPU_DDR_CLOCK_CONTROL	0x0008

#define	AR9344_PLL_PCIE_PLL_CONFIG		0x0010
#define	AR9344_PLL_PCIE_PLL_DITHER_DIV_MAX	0x0014
#define	AR9344_PLL_PCIE_PLL_DITHER_DIV_MIN	0x0018
#define	AR9344_PLL_PCIE_PLL_DITHER_STEP		0x001c
#define	AR9344_PLL_SWITCH_CLOCK_SPARE		0x0024
#define	AR9344_PLL_CURRENT_PCIE_PLL_DITHER	0x0028
#define	AR9344_PLL_ETH_XMII_CONTROL		0x002c
#define	AR9344_PLL_AUDIO_PLL_CONFIG		0x0030
#define	AR9344_PLL_AUDIO_PLL_MODULATION		0x0034
#define	AR9344_PLL_AUDIO_PLL_MOD_STEP		0x0038
#define	AR9344_PLL_CURRENT_AUDIO_PLL_MODULATION	0x003c
#define	AR9344_PLL_DDR_PLL_DITHER		0x0044
#define	AR9344_PLL_CPU_PLL_DITHER		0x0048

#define	AR9344_CPU_PLL_CONFIG_UPDATING		__BIT(31)
#define	AR9344_CPU_PLL_CONFIG_PLLPWD		__BIT(30)
#define	AR9344_CPU_PLL_CONFIG_OUTDIV		__BITS(19,21)
#define	AR9344_CPU_PLL_CONFIG_RANGE		__BITS(18,17)
#define	AR9344_CPU_PLL_CONFIG_REFDIV		__BITS(12,16)
#define	AR9344_CPU_PLL_CONFIG_NINT		__BITS(6,11)
#define	AR9344_CPU_PLL_CONFIG_NFRAC		__BITS(0,5)

#define	AR7100_CPU_PLL_SW_UPDATE		__BIT(31)
#define	AR7100_PLL_LOCKED			__BIT(30)
#define	AR7100_CPU_PLL_AHB_DIV			__BITS(22,20)
#define	AR7100_CPU_PLL_DDR_DIV_SEL		__BITS(19,18)
#define	AR7100_CPU_PLL_CPU_DIV_SEL		__BITS(17,16)
#define	AR7100_PLL_PLL_LOOP_BW			__BITS(15,12)
#define	AR7100_PLL_PLL_DIV_IN			__BITS(11,10)
#define	AR7100_PLL_PLL_DIV_OUT			__BITS(9,8)
#define	AR7100_PLL_PLL_FB			__BITS(7,3)
#define	AR7100_CPU_PLL_PLL_BYPASS		__BIT(1)
#define	AR7100_PLL_PLL_POWER_DOWN		__BIT(0)

#define	AR9344_DDR_PLL_CONFIG_UPDATING		__BIT(31)
#define	AR9344_DDR_PLL_CONFIG_PLLPWD		__BIT(30)
#define	AR9344_DDR_PLL_CONFIG_OUTDIV		__BITS(23,25)
#define	AR9344_DDR_PLL_CONFIG_RANGE		__BITS(21,22)
#define	AR9344_DDR_PLL_CONFIG_REFDIV		__BITS(16,20)
#define	AR9344_DDR_PLL_CONFIG_NINT		__BITS(10,15)
#define	AR9344_DDR_PLL_CONFIG_NFRAC		__BITS(0,9)

#define AR9344_CPU_DDR_CLOCK_CONTROL_AHBCLK_FROM_DDRPLL	__BIT(24)
#define AR9344_CPU_DDR_CLOCK_CONTROL_CPU_RESET_EN_BP_DEASRT	__BIT(23)
#define AR9344_CPU_DDR_CLOCK_CONTROL_CPU_RESET_EN_BP_ASRT	__BIT(22)
#define AR9344_CPU_DDR_CLOCK_CONTROL_DDRCLK_FROM_DDRPLL	__BIT(21)
#define AR9344_CPU_DDR_CLOCK_CONTROL_CPUCLK_FROM_CPUPLL	__BIT(20)
#define AR9344_CPU_DDR_CLOCK_CONTROL_AHB_POST_DIV	__BITS(15,19)
#define AR9344_CPU_DDR_CLOCK_CONTROL_DDR_POST_DIV	__BITS(10,14)
#define AR9344_CPU_DDR_CLOCK_CONTROL_CPU_POST_DIV	__BITS(5,9)
#define AR9344_CPU_DDR_CLOCK_CONTROL_AHB_PLL_BYPASS	__BIT(4)
#define AR9344_CPU_DDR_CLOCK_CONTROL_DDR_PLL_BYPASS	__BIT(3)
#define AR9344_CPU_DDR_CLOCK_CONTROL_CPU_PLL_BYPASS	__BIT(2)
#define AR9344_CPU_DDR_CLOCK_CONTROL_RESET_SWITCH	__BIT(1)

/*
 * RESET registers  -- offset relative to ARCHIP_RESET_BASE
 */
#define	ARCHIP_RESET_TIMER		0x0000
#define	ARCHIP_RESET_TIMER_RELOAD	0x0004
#define	ARCHIP_RESET_WDOG_CTL		0x0008
#define	ARCHIP_RESET_WDOG_TIMER		0x000c
#define	ARCHIP_RESET_MISC_INTSTAT	0x0010
#define	ARCHIP_RESET_MISC_INTMASK	0x0014
#define	AR9344_RESET_INTSTAT		0x0018
#define	AR7100_RESET_PCI_INTSTAT	0x0018
#define	AR9344_RESET_RESETCTL		0x001c
#define	AR7100_RESET_PCI_INTMASK	0x001c
#define	AR7100_RESET_INTSTAT		0x0020
#define	AR7100_RESET_RESETCTL		0x0024
#define	ARCHIP_RESET_REVISION		0x0090
#define	AR9344_RESET_WMAC_INTSTAT	0x00AC
#define	AR9344_RESET_BOOTSTRAP		0x00B0
#define	AR9344_RESET_MISC2		0x00BC

/* WDOG_CTL watchdog control bits */
#define	ARCHIP_WDOG_CTL_LAST			__BIT(31)
#define	ARCHIP_WDOG_CTL_IGNORE			0x00000000
#define	ARCHIP_WDOG_CTL_INT			0x00000001
#define	ARCHIP_WDOG_CTL_NMI			0x00000002
#define	ARCHIP_WDOG_CTL_RESET			0x00000003

/* Resets */
#define	AR9344_RESETCTL_I2S_RESET			__BIT(0)
#define	AR7100_RESETCTL_PCI_CORE_RESET			__BIT(0)
#define	AR9344_RESETCTL_MBOX_RESET			__BIT(1)
#define	AR7100_RESETCTL_PCI_BUS_RESET			__BIT(1)
#define	AR9344_RESETCTL_LUT_RESET			__BIT(2)
#define	AR9344_RESETCTL_USB_PHY_SUSPEND_OVERRIDE	__BIT(3)
#define	ARCHIP_RESETCTL_USB_PHY_RESET			__BIT(4)
#define	ARCHIP_RESETCTL_USB_HOST_RESET			__BIT(5)
#define	AR9344_RESETCTL_PCIE_RESET			__BIT(6)
#define	AR7100_RESETCTL_USB_OHCI_DLL_RESET		__BIT(6)
#define	AR9344_RESETCTL_PCIE_PHY_RESET			__BIT(7)
#define	AR9344_RESETCTL_ETH_SWITCH_RESET		__BIT(8)
#define	AR7100_RESETCTL_GMAC0_PHY_RESET			__BIT(8)
#define	ARCHIP_RESETCTL_GMAC0_MAC_RESET			__BIT(9)
#define	AR9344_RESETCTL_HOST_DMA_INT			__BIT(10)
#define	AR9344_RESETCTL_USB_PHY_ARESET			__BIT(11)
#define	AR9344_RESETCTL_ETH_SWITCH_ARESET		__BIT(12)
#define	AR7100_RESETCTL_GMAC1_PHY_RESET			__BIT(12)
#define	ARCHIP_RESETCTL_GMAC1_MAC_RESET			__BIT(13)
#define	AR9344_RESETCTL_NANDF_RESET			__BIT(14)
#define	AR9344_RESETCTL_USB_PHY_PLL_PWD_EXT		__BIT(15)
#define	ARCHIP_RESETCTL_DDR_RESET			__BIT(16)
#define	AR9344_RESETCTL_UART1_RESET			__BIT(17)
#define	AR7100_RESETCTL_I2S_RESET			__BIT(17)
#define	AR9344_RESETCTL_PCIEEP_RESET			__BIT(18)
#define	AR7100_RESETCTL_SLIC_RESET			__BIT(18)
#define	AR9344_RESETCTL_HOST_RESET_INT			__BIT(19)
#define	AR7100_RESETCTL_DMA_RESET			__BIT(19)
#define	ARCHIP_RESETCTL_CPU_COLD_RESET			__BIT(20)
#define	ARCHIP_RESETCTL_CPU_NMI				__BIT(21)
#define	AR9344_RESETCTL_RESET_GMAC0_MDIO		__BIT(22)
#define	AR9344_RESETCTL_RESET_GMAC1_MDIO		__BIT(23)
#define	ARCHIP_RESETCTL_FULL_CHIP_RESET			__BIT(24)
#define	AR9344_RESETCTL_CHKSUM_ACC_RESET		__BIT(25)
#define	AR9344_RESETCTL_PCIEEP_RST_INT			__BIT(26)
#define	AR9344_RESETCTL_RTC_RESET			__BIT(27)
#define	ARCHIP_RESETCTL_EXTERNAL_RESET			__BIT(28)
#define	AR9344_RESETCTL_HDMA_RESET			__BIT(29)
#define	AR9344_RESETCTL_SLIC_RESET			__BIT(30)
#define	AR9344_RESETCTL_HOST_RESET			__BIT(31)

/* Revision ids */
#define	AR9344_REVISION_WMAC_MAJOR(x)		(((x) >> 12) & 0xf)
#define	AR9344_REVISION_WMAC_MINOR(x)		(((x) >> 8) & 0xf)
#define	AR9344_REVISION_WMAC(x)			(((x) >> 8) & 0xff)
#define	AR9344_REVISION_MAJOR(x)		(((x) >> 4) & 0xf)
#define	AR9344_REVISION_MINOR(x)		(((x) >> 0) & 0xf)
#define	AR9344_REVISION_CHIPID(x)		(((x) >> 0) & 0xff)

#define	AR5311_REVISION_MAJ			0x1
#define	AR7240_REVISION_MAJ			0x4
#define	AR2313_REVISION_MAJ			0x5
#define	AR7100_REVISION_MAJ			0xA
#define	AR5315_REVISION_MAJ			0xB
#define	AR9344_REVISION_MAJ			0xC

#define	ARCHIP_AR5312				0x42
#define	ARCHIP_AR7130				0xA0
#define	ARCHIP_AR7141				0xA1
#define	ARCHIP_AR7161				0xA2
#define	ARCHIP_AR9344				0xC0
#define	ARCHIP_AR9103				0xB0
#define	ARCHIP_AR5315				0xB0

#define	ARWMAC_AR5312				0x52
#define	ARWMAC_AR5312_2				0x57
#define	ARWMAC_AR2313				0x58
#define	ARWMAC_AR2315LITE			0x86
#define	ARWMAC_AR2315				0x87
#define	ARWMAC_AR2317				0x91

#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_8	__BIT(31)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_7	__BIT(30)
#define	AR9344_BOOTSTRAP_DDR_WIDTH		__BIT(29)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_5	__BIT(28)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_4	__BIT(27)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_3	__BIT(26)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_2	__BIT(25)
#define	AR9344_BOOTSTRAP_SOFTWARE_OPTION_1	__BIT(24)
#define	AR9344_BOOTSTRAP_USB_MODE		__BIT(7)
#define	AR9344_BOOTSTRAP_EJTAG_MODE		__BIT(5)
#define	AR9344_BOOTSTRAP_REF_CLK_40		__BIT(4)
#define	AR9344_BOOTSTRAP_BOOT_SELECT		__BIT(2)
#define	AR9344_BOOTSTRAP_SDRAM_DISABLE		__BIT(1)
#define	AR9344_BOOTSTRAP_DDR_SELECT		__BIT(0)

/*
 * DDR registers  -- offset relative to ARCHIP_DDR_BASE
 */
#define	AR9344_DDR_CONFIG			0x0000
#define	AR9344_DDR_CONFIG2			0x0004
#define	AR9344_DDR_MODE_REGISTER		0x0008
#define	AR9344_DDR_EXTENDED_MOD_REGISTER	0x000c
#define	AR9344_DDR_CONTROL			0x0010
#define	AR9344_DDR_REFRESH			0x0014
#define	AR9344_DDR_RD_DATA_THIS_CYCLE		0x0018
#define	AR9344_DDR_TAP_CONTROL_0		0x001c
#define	AR9344_DDR_TAP_CONTROL_1		0x0020
#define	AR9344_DDR_TAP_CONTROL_2		0x0024
#define	AR9344_DDR_TAP_CONTROL_3		0x0028
#define	AR9344_DDR_WB_FLUSH_GMAC0		0x009c
#define	AR9344_DDR_WB_FLUSH_GMAC1		0x00a0
#define	AR9344_DDR_WB_FLUSH_USB			0x00a4
#define	AR9344_DDR_WB_FLUSH_PCIE		0x00a8
#define	AR9344_DDR_WB_FLUSH_WMAC		0x00ac
#define	AR9344_DDR_WB_FLUSH_SRC1		0x00b0
#define	AR9344_DDR_WB_FLUSH_SRC2		0x00b4
#define	AR9344_DDR_DDR2_CONFIG			0x00b8
#define	AR9344_DDR_EMR2				0x00bc
#define	AR9344_DDR_EMR3				0x00c0
#define	AR9344_AHB_MASTER_TIMEOUT_MAX		0x00cc
#define	AR9344_AHB_MASTER_TIMEOUT_CURRENT	0x00d0
#define	AR9344_AHB_MASTER_TIMEOUT_SLAVE_ADDR	0x00d4
#define	AR9344_DDR_CTL_CONFIG			0x0108
#define	AR9344_DDR_SF_CTL			0x0110
#define	AR9344_SF_TIMER				0x0114
#define	AR9344_WMAC_FLUSH			0x0128

/* memory config 1 bits */
#define	AR9344_MEM_CFG1_BANK0		__BITS(8,10)
#define	AR9344_MEM_CFG1_BANK1		__BITS(12,14)

#define	ARCHIP_REG_DDR_WB_FLUSH_GMAC0		0x009c
#define	ARCHIP_REG_DDR_WB_FLUSH_GMAC1		0x00a0
#define	ARCHIP_REG_DDR_WB_FLUSH_USB		0x00a4
#define	AR9344_REG_DDR_WB_FLUSH_PCIERC		0x00a8
#define	AR7100_REG_DDR_WB_FLUSH_PCI		0x00a8
#define	AR9344_REG_DDR_WB_FLUSH_WMAC		0x00ac
#define	AR9344_REG_DDR_WB_FLUSH_PCIEEP		0x00b0
#define	AR9344_REG_DDR_WB_FLUSH_CSUM		0x00b4

#define	AR7100_PCI_WINDOW_0			0x7c
#define	AR7100_PCI_WINDOW_1			0x80
#define	AR7100_PCI_WINDOW_2			0x84
#define	AR7100_PCI_WINDOW_3			0x88
#define	AR7100_PCI_WINDOW_4			0x8c
#define	AR7100_PCI_WINDOW_5			0x90
#define	AR7100_PCI_WINDOW_6			0x94
#define	AR7100_PCI_WINDOW_7			0x98

#define	AR7100_PCI_LCL_CFG_CMD		0x00
#define	AR7100_PCI_LCL_CFG_CMD_BE	__BITS(20,23)
#define	AR7100_PCI_LCL_CFG_CMD_CMD	__BITS(16,19)
#define	AR7100_PCI_LCL_CFG_CMD_READ	__SHIFTIN(0, AR7100_PCI_LCL_CFG_CMD_CMD)
#define	AR7100_PCI_LCL_CFG_CMD_WRITE	__SHIFTIN(1, AR7100_PCI_LCL_CFG_CMD_CMD)
#define	AR7100_PCI_LCL_CFG_CMD_ADDRESS	__BITS(0,11)
#define	AR7100_PCI_LCL_CFG_WDATA	0x04
#define	AR7100_PCI_LCL_CFG_RDATA	0x08
#define	AR7100_PCI_CFG_ADDR		0x0c
#define	AR7100_PCI_CFG_CMD		0x10
#define	AR7100_PCI_CFG_CMD_BE		__BITS(4,7)
#define	AR7100_PCI_CFG_CMD_CMD		__BITS(0,3)
#define	AR7100_PCI_CFG_WDATA		0x14
#define	AR7100_PCI_CFG_RDATA		0x18
#define	AR7100_PCI_ERROR		0x1c
#define	AR7100_PCI_ERROR_PARITY		__BIT(0)
#define	AR7100_PCI_ERROR_FATAL		__BIT(1)
#define	AR7100_PCI_ERROR_ADDR		0x20
#define	AR7100_AHB_ERROR		0x24
#define	AR7100_AHB_ERROR_ADDR		0x28

#define	AR9344_SPI_FUNCTION_SELECT			0x0000
#define	AR9344_SPI_FUNCTION_SLEECT_FUNCTION_SELECT	__BIT(0)
#define	AR9344_SPI_CONTROL				0x0004
#define	AR9344_SPI_CONTROL_TSHSL_CNT			__BITS(8,13)
#define	AR9344_SPI_CONTROL_SPI_RELOCATE			__BIT(7)
#define	AR9344_SPI_CONTROL_REMAP_DISABLE		__BIT(6)
#define	AR9344_SPI_CONTROL_CLOCK_DIVIDER		__BITS(0,5)
#define	AR9344_SPI_IO_CONTROL				0x0008
#define	AR9344_SPI_IO_CONTROL_IO_CS2_DISABLE		__BIT(18)
#define	AR9344_SPI_IO_CONTROL_IO_CS1_DISABLE		__BIT(17)
#define	AR9344_SPI_IO_CONTROL_IO_CS0_DISABLE		__BIT(16)
#define	AR9344_SPI_IO_CONTROL_IO_CLK			__BIT(8)
#define	AR9344_SPI_IO_CONTROL_IO_DO			__BIT(0)
#define	AR9344_SPI_READ_DATA				0x000c
#define	AR9344_SPI_SHIFT_DATAOUT			0x0010
#define	AR9344_SPI_SHIFT_CNT				0x0014
#define	AR9344_SPI_SHIFT_CNT_SHIFT_EN			__BIT(31)
#define	AR9344_SPI_SHIFT_CNT_SHIFT_CHNL_2		__BIT(30)
#define	AR9344_SPI_SHIFT_CNT_SHIFT_CHNL_1		__BIT(29)
#define	AR9344_SPI_SHIFT_CNT_SHIFT_CHNL_0		__BIT(28)
#define	AR9344_SPI_SHIFT_CNT_SHIFT_CLKOUT		__BIT(27)
#define	AR9344_SPI_SHIFT_CNT_TERMINATE			__BIT(26)
#define	AR9344_SPI_SHIFT_CNT_SHIFT_COUNT		__BITS(0,6)
#define	AR9344_SPI_SHIFT_DATAIN				0x0018

/* helper macro for accessing system registers without bus space */
#define	REGVAL(x)	*((volatile uint32_t *)(MIPS_PHYS_TO_KSEG1((x))))
#define	GETRESETREG(x)		REGVAL((x) + ARCHIP_RESET_BASE)
#define	PUTRESETREG(x,v)	(REGVAL((x) + ARCHIP_RESET_BASE)) = (v)
#define	GETPLLREG(x)		REGVAL((x) + ARCHIP_PLL_BASE)
#define	PUTPLLREG(x,v)		(REGVAL((x) + ARCHIP_PLL_BASE)) = (v)
#define	GETDDRREG(x)		REGVAL((x) + ARCHIP_DDR_BASE)
#define	PUTDDRREG(x,v)		(REGVAL((x) + ARCHIP_DDR_BASE)) = (v)

/*
 * Interrupts.
 */
#define	AR9344_CPU_IRQ_PCIERC		0
#define	AR7100_CPU_IRQ_PCI		0
#define	ARCHIP_CPU_IRQ_USB		1
#define	ARCHIP_CPU_IRQ_GMAC0		2
#define	ARCHIP_CPU_IRQ_GMAC1		3
#define	ARCHIP_CPU_IRQ_MISC		4
#define	ARCHIP_CPU_IRQ_TIMER		5
#define	AR9344_CPU_IRQ_PCIEEP_HSTDMA	6

#define	AR9344_MISC_IRQ_TIMER		0
#define	AR9344_MISC_IRQ_ERROR		1
#define	AR9344_MISC_IRQ_GPIO		2
#define	AR9344_MISC_IRQ_UART0		3
#define	AR9344_MISC_IRQ_WDOG		4
#define	AR9344_MISC_IRQ_PC		5
#define	AR9344_MISC_IRQ_UART1		6
#define	AR9344_MISC_IRQ_MBOX		7
#define	AR9344_MISC_IRQ_TIMER2		8
#define	AR9344_MISC_IRQ_TIMER3		9
#define	AR9344_MISC_IRQ_TIMER4		10
#define	AR9344_MISC_IRQ_DDR_PERF	11
#define	AR9344_MISC_IRQ_SW_MAC		12
#define	AR9344_MISC_IRQ_LUTS_AGER	13
#define	AR9344_MISC_IRQ_RES14		14
#define	AR9344_MISC_IRQ_CHKSUM_ACC	15
#define	AR9344_MISC_IRQ_DDR_SF_ENTRY	16
#define	AR9344_MISC_IRQ_DDR_SF_EXIT	17
#define	AR9344_MISC_IRQ_DDR_ACT_IN_SF	18
#define	AR9344_MISC_IRQ_SLIC		19
#define	AR9344_MISC_IRQ_WOW		20
#define	AR9344_MISC_IRQ_NANDF		21

#define	AR7100_MISC_IRQ_TIMER		0
#define	AR7100_MISC_IRQ_ERROR		1
#define	AR7100_MISC_IRQ_GPIO		2
#define	AR7100_MISC_IRQ_UART0		3
#define	AR7100_MISC_IRQ_WDOG		4
#define	AR7100_MISC_IRQ_PC		5
#define	AR7100_MISC_IRQ_OHCI		6
#define	AR7100_MISC_IRQ_DMA		7

#define	AR9344_WMAC_IRQ_WMAC_MISC_INT	0
#define	AR9344_WMAC_IRQ_WMAC_TX_INT	1
#define	AR9344_WMAC_IRQ_WMAC_RXLP_INT	2
#define	AR9344_WMAC_IRQ_WMAC_RXHP_INT	3
#define	AR9344_WMAC_IRQ_PCIE_RC_INT	4
#define	AR9344_WMAC_IRQ_PCIE_RC_INT0	5
#define	AR9344_WMAC_IRQ_PCIE_RC_INT1	6
#define	AR9344_WMAC_IRQ_PCIE_RC_INT2	7
#define	AR9344_WMAC_IRQ_PCIE_RC_INT3	8

#endif	/* _MIPS_ATHEROS_AR9344REG_H_ */
