#!/usr/bin/env python
# vim:fileencoding=utf-8
# License: BSD Copyright: 2017, Kovid Goyal <kovid at kovidgoyal.net>

from __future__ import (absolute_import, division, print_function,
                        unicode_literals)

html5_entities = {
# ENTITY_DATA {{{
    'aacute': 'á',
    'abreve': 'ă',
    'ac': '∾',
    'acd': '∿',
    'ace': '∾̳',
    'acirc': 'â',
    'acute': '´',
    'acy': 'а',
    'aelig': 'æ',
    'af': '\u2061',
    'afr': '𝔞',
    'agrave': 'à',
    'alefsym': 'ℵ',
    'aleph': 'ℵ',
    'alpha': 'α',
    'amacr': 'ā',
    'amalg': '⨿',
    'amp': '&',
    'and': '∧',
    'andand': '⩕',
    'andd': '⩜',
    'andslope': '⩘',
    'andv': '⩚',
    'ang': '∠',
    'ange': '⦤',
    'angle': '∠',
    'angmsd': '∡',
    'angmsdaa': '⦨',
    'angmsdab': '⦩',
    'angmsdac': '⦪',
    'angmsdad': '⦫',
    'angmsdae': '⦬',
    'angmsdaf': '⦭',
    'angmsdag': '⦮',
    'angmsdah': '⦯',
    'angrt': '∟',
    'angrtvb': '⊾',
    'angrtvbd': '⦝',
    'angsph': '∢',
    'angst': 'Å',
    'angzarr': '⍼',
    'aogon': 'ą',
    'aopf': '𝕒',
    'ap': '≈',
    'apacir': '⩯',
    'ape': '≊',
    'apid': '≋',
    'apos': "'",
    'applyfunction': '\u2061',
    'approx': '≈',
    'approxeq': '≊',
    'aring': 'å',
    'ascr': '𝒶',
    'assign': '≔',
    'ast': '*',
    'asymp': '≈',
    'asympeq': '≍',
    'atilde': 'ã',
    'auml': 'ä',
    'awconint': '∳',
    'awint': '⨑',
    'backcong': '≌',
    'backepsilon': '϶',
    'backprime': '‵',
    'backsim': '∽',
    'backsimeq': '⋍',
    'backslash': '∖',
    'barv': '⫧',
    'barvee': '⊽',
    'barwed': '⌅',
    'barwedge': '⌅',
    'bbrk': '⎵',
    'bbrktbrk': '⎶',
    'bcong': '≌',
    'bcy': 'б',
    'bdquo': '„',
    'becaus': '∵',
    'because': '∵',
    'bemptyv': '⦰',
    'bepsi': '϶',
    'bernou': 'ℬ',
    'bernoullis': 'ℬ',
    'beta': 'β',
    'beth': 'ℶ',
    'between': '≬',
    'bfr': '𝔟',
    'bigcap': '⋂',
    'bigcirc': '◯',
    'bigcup': '⋃',
    'bigodot': '⨀',
    'bigoplus': '⨁',
    'bigotimes': '⨂',
    'bigsqcup': '⨆',
    'bigstar': '★',
    'bigtriangledown': '▽',
    'bigtriangleup': '△',
    'biguplus': '⨄',
    'bigvee': '⋁',
    'bigwedge': '⋀',
    'bkarow': '⤍',
    'blacklozenge': '⧫',
    'blacksquare': '▪',
    'blacktriangle': '▴',
    'blacktriangledown': '▾',
    'blacktriangleleft': '◂',
    'blacktriangleright': '▸',
    'blank': '␣',
    'blk12': '▒',
    'blk14': '░',
    'blk34': '▓',
    'block': '█',
    'bne': '=⃥',
    'bnequiv': '≡⃥',
    'bnot': '⌐',
    'bopf': '𝕓',
    'bot': '⊥',
    'bottom': '⊥',
    'bowtie': '⋈',
    'boxbox': '⧉',
    'boxdl': '┐',
    'boxdr': '┌',
    'boxh': '─',
    'boxhd': '┬',
    'boxhu': '┴',
    'boxminus': '⊟',
    'boxplus': '⊞',
    'boxtimes': '⊠',
    'boxul': '┘',
    'boxur': '└',
    'boxv': '│',
    'boxvh': '┼',
    'boxvl': '┤',
    'boxvr': '├',
    'bprime': '‵',
    'breve': '˘',
    'brvbar': '¦',
    'bscr': '𝒷',
    'bsemi': '⁏',
    'bsim': '∽',
    'bsime': '⋍',
    'bsol': '\\',
    'bsolb': '⧅',
    'bsolhsub': '⟈',
    'bull': '•',
    'bullet': '•',
    'bump': '≎',
    'bumpe': '≏',
    'bumpeq': '≏',
    'cacute': 'ć',
    'cap': '∩',
    'capand': '⩄',
    'capbrcup': '⩉',
    'capcap': '⩋',
    'capcup': '⩇',
    'capdot': '⩀',
    'capitaldifferentiald': 'ⅅ',
    'caps': '∩︀',
    'caret': '⁁',
    'caron': 'ˇ',
    'cayleys': 'ℭ',
    'ccaps': '⩍',
    'ccaron': 'č',
    'ccedil': 'ç',
    'ccirc': 'ĉ',
    'cconint': '∰',
    'ccups': '⩌',
    'ccupssm': '⩐',
    'cdot': 'ċ',
    'cedil': '¸',
    'cedilla': '¸',
    'cemptyv': '⦲',
    'cent': '¢',
    'centerdot': '·',
    'cfr': '𝔠',
    'chcy': 'ч',
    'check': '✓',
    'checkmark': '✓',
    'chi': 'χ',
    'cir': '○',
    'circ': 'ˆ',
    'circeq': '≗',
    'circlearrowleft': '↺',
    'circlearrowright': '↻',
    'circledast': '⊛',
    'circledcirc': '⊚',
    'circleddash': '⊝',
    'circledot': '⊙',
    'circledr': '®',
    'circleds': 'Ⓢ',
    'circleminus': '⊖',
    'circleplus': '⊕',
    'circletimes': '⊗',
    'cire': '≗',
    'cirfnint': '⨐',
    'cirmid': '⫯',
    'cirscir': '⧂',
    'clockwisecontourintegral': '∲',
    'closecurlydoublequote': '”',
    'closecurlyquote': '’',
    'clubs': '♣',
    'clubsuit': '♣',
    'colon': ':',
    'colone': '≔',
    'coloneq': '≔',
    'comma': ',',
    'commat': '@',
    'comp': '∁',
    'compfn': '∘',
    'complement': '∁',
    'complexes': 'ℂ',
    'cong': '≅',
    'congdot': '⩭',
    'congruent': '≡',
    'conint': '∮',
    'contourintegral': '∮',
    'copf': '𝕔',
    'coprod': '∐',
    'coproduct': '∐',
    'copy': '©',
    'copysr': '℗',
    'counterclockwisecontourintegral': '∳',
    'crarr': '↵',
    'cross': '✗',
    'cscr': '𝒸',
    'csub': '⫏',
    'csube': '⫑',
    'csup': '⫐',
    'csupe': '⫒',
    'ctdot': '⋯',
    'cudarrl': '⤸',
    'cudarrr': '⤵',
    'cuepr': '⋞',
    'cuesc': '⋟',
    'cularr': '↶',
    'cularrp': '⤽',
    'cup': '∪',
    'cupbrcap': '⩈',
    'cupcap': '⩆',
    'cupcup': '⩊',
    'cupdot': '⊍',
    'cupor': '⩅',
    'cups': '∪︀',
    'curarr': '↷',
    'curarrm': '⤼',
    'curlyeqprec': '⋞',
    'curlyeqsucc': '⋟',
    'curlyvee': '⋎',
    'curlywedge': '⋏',
    'curren': '¤',
    'curvearrowleft': '↶',
    'curvearrowright': '↷',
    'cuvee': '⋎',
    'cuwed': '⋏',
    'cwconint': '∲',
    'cwint': '∱',
    'cylcty': '⌭',
    'dagger': '†',
    'daleth': 'ℸ',
    'darr': '↓',
    'dash': '‐',
    'dashv': '⊣',
    'dbkarow': '⤏',
    'dblac': '˝',
    'dcaron': 'ď',
    'dcy': 'д',
    'dd': 'ⅆ',
    'ddagger': '‡',
    'ddarr': '⇊',
    'ddotrahd': '⤑',
    'ddotseq': '⩷',
    'deg': '°',
    'del': '∇',
    'delta': 'δ',
    'demptyv': '⦱',
    'dfisht': '⥿',
    'dfr': '𝔡',
    'dhar': '⥥',
    'dharl': '⇃',
    'dharr': '⇂',
    'diacriticalacute': '´',
    'diacriticaldot': '˙',
    'diacriticaldoubleacute': '˝',
    'diacriticalgrave': '`',
    'diacriticaltilde': '˜',
    'diam': '⋄',
    'diamond': '⋄',
    'diamondsuit': '♦',
    'diams': '♦',
    'die': '¨',
    'differentiald': 'ⅆ',
    'digamma': 'ϝ',
    'disin': '⋲',
    'div': '÷',
    'divide': '÷',
    'divideontimes': '⋇',
    'divonx': '⋇',
    'djcy': 'ђ',
    'dlcorn': '⌞',
    'dlcrop': '⌍',
    'dollar': '$',
    'dopf': '𝕕',
    'dot': '˙',
    'dotdot': '⃜',
    'doteq': '≐',
    'doteqdot': '≑',
    'dotequal': '≐',
    'dotminus': '∸',
    'dotplus': '∔',
    'dotsquare': '⊡',
    'doublebarwedge': '⌆',
    'doublecontourintegral': '∯',
    'doubledot': '¨',
    'doubledownarrow': '⇓',
    'doubleleftarrow': '⇐',
    'doubleleftrightarrow': '⇔',
    'doublelefttee': '⫤',
    'doublelongleftarrow': '⟸',
    'doublelongleftrightarrow': '⟺',
    'doublelongrightarrow': '⟹',
    'doublerightarrow': '⇒',
    'doublerighttee': '⊨',
    'doubleuparrow': '⇑',
    'doubleupdownarrow': '⇕',
    'doubleverticalbar': '∥',
    'downarrow': '↓',
    'downarrowbar': '⤓',
    'downarrowuparrow': '⇵',
    'downbreve': '̑',
    'downdownarrows': '⇊',
    'downharpoonleft': '⇃',
    'downharpoonright': '⇂',
    'downleftrightvector': '⥐',
    'downleftteevector': '⥞',
    'downleftvector': '↽',
    'downleftvectorbar': '⥖',
    'downrightteevector': '⥟',
    'downrightvector': '⇁',
    'downrightvectorbar': '⥗',
    'downtee': '⊤',
    'downteearrow': '↧',
    'drbkarow': '⤐',
    'drcorn': '⌟',
    'drcrop': '⌌',
    'dscr': '𝒹',
    'dscy': 'ѕ',
    'dsol': '⧶',
    'dstrok': 'đ',
    'dtdot': '⋱',
    'dtri': '▿',
    'dtrif': '▾',
    'duarr': '⇵',
    'duhar': '⥯',
    'dwangle': '⦦',
    'dzcy': 'џ',
    'dzigrarr': '⟿',
    'eacute': 'é',
    'easter': '⩮',
    'ecaron': 'ě',
    'ecir': '≖',
    'ecirc': 'ê',
    'ecolon': '≕',
    'ecy': 'э',
    'eddot': '⩷',
    'edot': 'ė',
    'ee': 'ⅇ',
    'efdot': '≒',
    'efr': '𝔢',
    'eg': '⪚',
    'egrave': 'è',
    'egs': '⪖',
    'egsdot': '⪘',
    'el': '⪙',
    'element': '∈',
    'elinters': '⏧',
    'ell': 'ℓ',
    'els': '⪕',
    'elsdot': '⪗',
    'emacr': 'ē',
    'empty': '∅',
    'emptyset': '∅',
    'emptysmallsquare': '◻',
    'emptyv': '∅',
    'emptyverysmallsquare': '▫',
    'emsp': '\u2003',
    'emsp13': '\u2004',
    'emsp14': '\u2005',
    'eng': 'ŋ',
    'ensp': '\u2002',
    'eogon': 'ę',
    'eopf': '𝕖',
    'epar': '⋕',
    'eparsl': '⧣',
    'eplus': '⩱',
    'epsi': 'ε',
    'epsilon': 'ε',
    'epsiv': 'ϵ',
    'eqcirc': '≖',
    'eqcolon': '≕',
    'eqsim': '≂',
    'eqslantgtr': '⪖',
    'eqslantless': '⪕',
    'equal': '⩵',
    'equals': '=',
    'equaltilde': '≂',
    'equest': '≟',
    'equilibrium': '⇌',
    'equiv': '≡',
    'equivdd': '⩸',
    'eqvparsl': '⧥',
    'erarr': '⥱',
    'erdot': '≓',
    'escr': 'ℯ',
    'esdot': '≐',
    'esim': '≂',
    'eta': 'η',
    'eth': 'ð',
    'euml': 'ë',
    'euro': '€',
    'excl': '!',
    'exist': '∃',
    'exists': '∃',
    'expectation': 'ℰ',
    'exponentiale': 'ⅇ',
    'fallingdotseq': '≒',
    'fcy': 'ф',
    'female': '♀',
    'ffilig': 'ﬃ',
    'fflig': 'ﬀ',
    'ffllig': 'ﬄ',
    'ffr': '𝔣',
    'filig': 'ﬁ',
    'filledsmallsquare': '◼',
    'filledverysmallsquare': '▪',
    'fjlig': 'fj',
    'flat': '♭',
    'fllig': 'ﬂ',
    'fltns': '▱',
    'fnof': 'ƒ',
    'fopf': '𝕗',
    'forall': '∀',
    'fork': '⋔',
    'forkv': '⫙',
    'fouriertrf': 'ℱ',
    'fpartint': '⨍',
    'frac12': '½',
    'frac13': '⅓',
    'frac14': '¼',
    'frac15': '⅕',
    'frac16': '⅙',
    'frac18': '⅛',
    'frac23': '⅔',
    'frac25': '⅖',
    'frac34': '¾',
    'frac35': '⅗',
    'frac38': '⅜',
    'frac45': '⅘',
    'frac56': '⅚',
    'frac58': '⅝',
    'frac78': '⅞',
    'frasl': '⁄',
    'frown': '⌢',
    'fscr': '𝒻',
    'gacute': 'ǵ',
    'gamma': 'γ',
    'gammad': 'ϝ',
    'gap': '⪆',
    'gbreve': 'ğ',
    'gcedil': 'Ģ',
    'gcirc': 'ĝ',
    'gcy': 'г',
    'gdot': 'ġ',
    'ge': '≥',
    'gel': '⋛',
    'geq': '≥',
    'geqq': '≧',
    'geqslant': '⩾',
    'ges': '⩾',
    'gescc': '⪩',
    'gesdot': '⪀',
    'gesdoto': '⪂',
    'gesdotol': '⪄',
    'gesl': '⋛︀',
    'gesles': '⪔',
    'gfr': '𝔤',
    'gg': '≫',
    'ggg': '⋙',
    'gimel': 'ℷ',
    'gjcy': 'ѓ',
    'gl': '≷',
    'gla': '⪥',
    'gle': '⪒',
    'glj': '⪤',
    'gnap': '⪊',
    'gnapprox': '⪊',
    'gne': '⪈',
    'gneq': '⪈',
    'gneqq': '≩',
    'gnsim': '⋧',
    'gopf': '𝕘',
    'grave': '`',
    'greaterequal': '≥',
    'greaterequalless': '⋛',
    'greaterfullequal': '≧',
    'greatergreater': '⪢',
    'greaterless': '≷',
    'greaterslantequal': '⩾',
    'greatertilde': '≳',
    'gscr': 'ℊ',
    'gsim': '≳',
    'gsime': '⪎',
    'gsiml': '⪐',
    'gt': '>',
    'gtcc': '⪧',
    'gtcir': '⩺',
    'gtdot': '⋗',
    'gtlpar': '⦕',
    'gtquest': '⩼',
    'gtrapprox': '⪆',
    'gtrarr': '⥸',
    'gtrdot': '⋗',
    'gtreqless': '⋛',
    'gtreqqless': '⪌',
    'gtrless': '≷',
    'gtrsim': '≳',
    'gvertneqq': '≩︀',
    'gvne': '≩︀',
    'hacek': 'ˇ',
    'hairsp': '\u200a',
    'half': '½',
    'hamilt': 'ℋ',
    'hardcy': 'ъ',
    'harr': '↔',
    'harrcir': '⥈',
    'harrw': '↭',
    'hat': '^',
    'hbar': 'ℏ',
    'hcirc': 'ĥ',
    'hearts': '♥',
    'heartsuit': '♥',
    'hellip': '…',
    'hercon': '⊹',
    'hfr': '𝔥',
    'hilbertspace': 'ℋ',
    'hksearow': '⤥',
    'hkswarow': '⤦',
    'hoarr': '⇿',
    'homtht': '∻',
    'hookleftarrow': '↩',
    'hookrightarrow': '↪',
    'hopf': '𝕙',
    'horbar': '―',
    'horizontalline': '─',
    'hscr': '𝒽',
    'hslash': 'ℏ',
    'hstrok': 'ħ',
    'humpdownhump': '≎',
    'humpequal': '≏',
    'hybull': '⁃',
    'hyphen': '‐',
    'iacute': 'í',
    'ic': '\u2063',
    'icirc': 'î',
    'icy': 'и',
    'idot': 'İ',
    'iecy': 'е',
    'iexcl': '¡',
    'iff': '⇔',
    'ifr': '𝔦',
    'igrave': 'ì',
    'ii': 'ⅈ',
    'iiiint': '⨌',
    'iiint': '∭',
    'iinfin': '⧜',
    'iiota': '℩',
    'ijlig': 'ĳ',
    'im': 'ℑ',
    'imacr': 'ī',
    'image': 'ℑ',
    'imaginaryi': 'ⅈ',
    'imagline': 'ℐ',
    'imagpart': 'ℑ',
    'imath': 'ı',
    'imof': '⊷',
    'imped': 'Ƶ',
    'implies': '⇒',
    'in': '∈',
    'incare': '℅',
    'infin': '∞',
    'infintie': '⧝',
    'inodot': 'ı',
    'int': '∫',
    'intcal': '⊺',
    'integers': 'ℤ',
    'integral': '∫',
    'intercal': '⊺',
    'intersection': '⋂',
    'intlarhk': '⨗',
    'intprod': '⨼',
    'invisiblecomma': '\u2063',
    'invisibletimes': '\u2062',
    'iocy': 'ё',
    'iogon': 'į',
    'iopf': '𝕚',
    'iota': 'ι',
    'iprod': '⨼',
    'iquest': '¿',
    'iscr': '𝒾',
    'isin': '∈',
    'isindot': '⋵',
    'isine': '⋹',
    'isins': '⋴',
    'isinsv': '⋳',
    'isinv': '∈',
    'it': '\u2062',
    'itilde': 'ĩ',
    'iukcy': 'і',
    'iuml': 'ï',
    'jcirc': 'ĵ',
    'jcy': 'й',
    'jfr': '𝔧',
    'jmath': 'ȷ',
    'jopf': '𝕛',
    'jscr': '𝒿',
    'jsercy': 'ј',
    'jukcy': 'є',
    'kappa': 'κ',
    'kappav': 'ϰ',
    'kcedil': 'ķ',
    'kcy': 'к',
    'kfr': '𝔨',
    'kgreen': 'ĸ',
    'khcy': 'х',
    'kjcy': 'ќ',
    'kopf': '𝕜',
    'kscr': '𝓀',
    'laarr': '⇚',
    'lacute': 'ĺ',
    'laemptyv': '⦴',
    'lagran': 'ℒ',
    'lambda': 'λ',
    'lang': '⟨',
    'langd': '⦑',
    'langle': '⟨',
    'lap': '⪅',
    'laplacetrf': 'ℒ',
    'laquo': '«',
    'larr': '←',
    'larrb': '⇤',
    'larrbfs': '⤟',
    'larrfs': '⤝',
    'larrhk': '↩',
    'larrlp': '↫',
    'larrpl': '⤹',
    'larrsim': '⥳',
    'larrtl': '↢',
    'lat': '⪫',
    'latail': '⤙',
    'late': '⪭',
    'lates': '⪭︀',
    'lbarr': '⤌',
    'lbbrk': '❲',
    'lbrace': '{',
    'lbrack': '[',
    'lbrke': '⦋',
    'lbrksld': '⦏',
    'lbrkslu': '⦍',
    'lcaron': 'ľ',
    'lcedil': 'ļ',
    'lceil': '⌈',
    'lcub': '{',
    'lcy': 'л',
    'ldca': '⤶',
    'ldquo': '“',
    'ldquor': '„',
    'ldrdhar': '⥧',
    'ldrushar': '⥋',
    'ldsh': '↲',
    'le': '≤',
    'leftanglebracket': '⟨',
    'leftarrow': '←',
    'leftarrowbar': '⇤',
    'leftarrowrightarrow': '⇆',
    'leftarrowtail': '↢',
    'leftceiling': '⌈',
    'leftdoublebracket': '⟦',
    'leftdownteevector': '⥡',
    'leftdownvector': '⇃',
    'leftdownvectorbar': '⥙',
    'leftfloor': '⌊',
    'leftharpoondown': '↽',
    'leftharpoonup': '↼',
    'leftleftarrows': '⇇',
    'leftrightarrow': '↔',
    'leftrightarrows': '⇆',
    'leftrightharpoons': '⇋',
    'leftrightsquigarrow': '↭',
    'leftrightvector': '⥎',
    'lefttee': '⊣',
    'leftteearrow': '↤',
    'leftteevector': '⥚',
    'leftthreetimes': '⋋',
    'lefttriangle': '⊲',
    'lefttrianglebar': '⧏',
    'lefttriangleequal': '⊴',
    'leftupdownvector': '⥑',
    'leftupteevector': '⥠',
    'leftupvector': '↿',
    'leftupvectorbar': '⥘',
    'leftvector': '↼',
    'leftvectorbar': '⥒',
    'leg': '⋚',
    'leq': '≤',
    'leqq': '≦',
    'leqslant': '⩽',
    'les': '⩽',
    'lescc': '⪨',
    'lesdot': '⩿',
    'lesdoto': '⪁',
    'lesdotor': '⪃',
    'lesg': '⋚︀',
    'lesges': '⪓',
    'lessapprox': '⪅',
    'lessdot': '⋖',
    'lesseqgtr': '⋚',
    'lesseqqgtr': '⪋',
    'lessequalgreater': '⋚',
    'lessfullequal': '≦',
    'lessgreater': '≶',
    'lessgtr': '≶',
    'lessless': '⪡',
    'lesssim': '≲',
    'lessslantequal': '⩽',
    'lesstilde': '≲',
    'lfisht': '⥼',
    'lfloor': '⌊',
    'lfr': '𝔩',
    'lg': '≶',
    'lge': '⪑',
    'lhar': '⥢',
    'lhard': '↽',
    'lharu': '↼',
    'lharul': '⥪',
    'lhblk': '▄',
    'ljcy': 'љ',
    'll': '≪',
    'llarr': '⇇',
    'llcorner': '⌞',
    'lleftarrow': '⇚',
    'llhard': '⥫',
    'lltri': '◺',
    'lmidot': 'ŀ',
    'lmoust': '⎰',
    'lmoustache': '⎰',
    'lnap': '⪉',
    'lnapprox': '⪉',
    'lne': '⪇',
    'lneq': '⪇',
    'lneqq': '≨',
    'lnsim': '⋦',
    'loang': '⟬',
    'loarr': '⇽',
    'lobrk': '⟦',
    'longleftarrow': '⟵',
    'longleftrightarrow': '⟷',
    'longmapsto': '⟼',
    'longrightarrow': '⟶',
    'looparrowleft': '↫',
    'looparrowright': '↬',
    'lopar': '⦅',
    'lopf': '𝕝',
    'loplus': '⨭',
    'lotimes': '⨴',
    'lowast': '∗',
    'lowbar': '_',
    'lowerleftarrow': '↙',
    'lowerrightarrow': '↘',
    'loz': '◊',
    'lozenge': '◊',
    'lozf': '⧫',
    'lpar': '(',
    'lparlt': '⦓',
    'lrarr': '⇆',
    'lrcorner': '⌟',
    'lrhar': '⇋',
    'lrhard': '⥭',
    'lrm': '\u200e',
    'lrtri': '⊿',
    'lsaquo': '‹',
    'lscr': '𝓁',
    'lsh': '↰',
    'lsim': '≲',
    'lsime': '⪍',
    'lsimg': '⪏',
    'lsqb': '[',
    'lsquo': '‘',
    'lsquor': '‚',
    'lstrok': 'ł',
    'lt': '<',
    'ltcc': '⪦',
    'ltcir': '⩹',
    'ltdot': '⋖',
    'lthree': '⋋',
    'ltimes': '⋉',
    'ltlarr': '⥶',
    'ltquest': '⩻',
    'ltri': '◃',
    'ltrie': '⊴',
    'ltrif': '◂',
    'ltrpar': '⦖',
    'lurdshar': '⥊',
    'luruhar': '⥦',
    'lvertneqq': '≨︀',
    'lvne': '≨︀',
    'macr': '¯',
    'male': '♂',
    'malt': '✠',
    'maltese': '✠',
    'map': '↦',
    'mapsto': '↦',
    'mapstodown': '↧',
    'mapstoleft': '↤',
    'mapstoup': '↥',
    'marker': '▮',
    'mcomma': '⨩',
    'mcy': 'м',
    'mdash': '—',
    'mddot': '∺',
    'measuredangle': '∡',
    'mediumspace': '\u205f',
    'mellintrf': 'ℳ',
    'mfr': '𝔪',
    'mho': '℧',
    'micro': 'µ',
    'mid': '∣',
    'midast': '*',
    'midcir': '⫰',
    'middot': '·',
    'minus': '−',
    'minusb': '⊟',
    'minusd': '∸',
    'minusdu': '⨪',
    'minusplus': '∓',
    'mlcp': '⫛',
    'mldr': '…',
    'mnplus': '∓',
    'models': '⊧',
    'mopf': '𝕞',
    'mp': '∓',
    'mscr': '𝓂',
    'mstpos': '∾',
    'mu': 'μ',
    'multimap': '⊸',
    'mumap': '⊸',
    'nabla': '∇',
    'nacute': 'ń',
    'nang': '∠⃒',
    'nap': '≉',
    'nape': '⩰̸',
    'napid': '≋̸',
    'napos': 'ŉ',
    'napprox': '≉',
    'natur': '♮',
    'natural': '♮',
    'naturals': 'ℕ',
    'nbsp': '\xa0',
    'nbump': '≎̸',
    'nbumpe': '≏̸',
    'ncap': '⩃',
    'ncaron': 'ň',
    'ncedil': 'ņ',
    'ncong': '≇',
    'ncongdot': '⩭̸',
    'ncup': '⩂',
    'ncy': 'н',
    'ndash': '–',
    'ne': '≠',
    'nearhk': '⤤',
    'nearr': '↗',
    'nearrow': '↗',
    'nedot': '≐̸',
    'negativemediumspace': '\u200b',
    'negativethickspace': '\u200b',
    'negativethinspace': '\u200b',
    'negativeverythinspace': '\u200b',
    'nequiv': '≢',
    'nesear': '⤨',
    'nesim': '≂̸',
    'nestedgreatergreater': '≫',
    'nestedlessless': '≪',
    'newline': '\n',
    'nexist': '∄',
    'nexists': '∄',
    'nfr': '𝔫',
    'nge': '≱',
    'ngeq': '≱',
    'ngeqq': '≧̸',
    'ngeqslant': '⩾̸',
    'nges': '⩾̸',
    'ngg': '⋙̸',
    'ngsim': '≵',
    'ngt': '≯',
    'ngtr': '≯',
    'ngtv': '≫̸',
    'nharr': '↮',
    'nhpar': '⫲',
    'ni': '∋',
    'nis': '⋼',
    'nisd': '⋺',
    'niv': '∋',
    'njcy': 'њ',
    'nlarr': '↚',
    'nldr': '‥',
    'nle': '≰',
    'nleftarrow': '↚',
    'nleftrightarrow': '↮',
    'nleq': '≰',
    'nleqq': '≦̸',
    'nleqslant': '⩽̸',
    'nles': '⩽̸',
    'nless': '≮',
    'nll': '⋘̸',
    'nlsim': '≴',
    'nlt': '≮',
    'nltri': '⋪',
    'nltrie': '⋬',
    'nltv': '≪̸',
    'nmid': '∤',
    'nobreak': '\u2060',
    'nonbreakingspace': '\xa0',
    'nopf': '𝕟',
    'not': '¬',
    'notcongruent': '≢',
    'notcupcap': '≭',
    'notdoubleverticalbar': '∦',
    'notelement': '∉',
    'notequal': '≠',
    'notequaltilde': '≂̸',
    'notexists': '∄',
    'notgreater': '≯',
    'notgreaterequal': '≱',
    'notgreaterfullequal': '≧̸',
    'notgreatergreater': '≫̸',
    'notgreaterless': '≹',
    'notgreaterslantequal': '⩾̸',
    'notgreatertilde': '≵',
    'nothumpdownhump': '≎̸',
    'nothumpequal': '≏̸',
    'notin': '∉',
    'notindot': '⋵̸',
    'notine': '⋹̸',
    'notinva': '∉',
    'notinvb': '⋷',
    'notinvc': '⋶',
    'notlefttriangle': '⋪',
    'notlefttrianglebar': '⧏̸',
    'notlefttriangleequal': '⋬',
    'notless': '≮',
    'notlessequal': '≰',
    'notlessgreater': '≸',
    'notlessless': '≪̸',
    'notlessslantequal': '⩽̸',
    'notlesstilde': '≴',
    'notnestedgreatergreater': '⪢̸',
    'notnestedlessless': '⪡̸',
    'notni': '∌',
    'notniva': '∌',
    'notnivb': '⋾',
    'notnivc': '⋽',
    'notprecedes': '⊀',
    'notprecedesequal': '⪯̸',
    'notprecedesslantequal': '⋠',
    'notreverseelement': '∌',
    'notrighttriangle': '⋫',
    'notrighttrianglebar': '⧐̸',
    'notrighttriangleequal': '⋭',
    'notsquaresubset': '⊏̸',
    'notsquaresubsetequal': '⋢',
    'notsquaresuperset': '⊐̸',
    'notsquaresupersetequal': '⋣',
    'notsubset': '⊂⃒',
    'notsubsetequal': '⊈',
    'notsucceeds': '⊁',
    'notsucceedsequal': '⪰̸',
    'notsucceedsslantequal': '⋡',
    'notsucceedstilde': '≿̸',
    'notsuperset': '⊃⃒',
    'notsupersetequal': '⊉',
    'nottilde': '≁',
    'nottildeequal': '≄',
    'nottildefullequal': '≇',
    'nottildetilde': '≉',
    'notverticalbar': '∤',
    'npar': '∦',
    'nparallel': '∦',
    'nparsl': '⫽⃥',
    'npart': '∂̸',
    'npolint': '⨔',
    'npr': '⊀',
    'nprcue': '⋠',
    'npre': '⪯̸',
    'nprec': '⊀',
    'npreceq': '⪯̸',
    'nrarr': '↛',
    'nrarrc': '⤳̸',
    'nrarrw': '↝̸',
    'nrightarrow': '↛',
    'nrtri': '⋫',
    'nrtrie': '⋭',
    'nsc': '⊁',
    'nsccue': '⋡',
    'nsce': '⪰̸',
    'nscr': '𝓃',
    'nshortmid': '∤',
    'nshortparallel': '∦',
    'nsim': '≁',
    'nsime': '≄',
    'nsimeq': '≄',
    'nsmid': '∤',
    'nspar': '∦',
    'nsqsube': '⋢',
    'nsqsupe': '⋣',
    'nsub': '⊄',
    'nsube': '⊈',
    'nsubset': '⊂⃒',
    'nsubseteq': '⊈',
    'nsubseteqq': '⫅̸',
    'nsucc': '⊁',
    'nsucceq': '⪰̸',
    'nsup': '⊅',
    'nsupe': '⊉',
    'nsupset': '⊃⃒',
    'nsupseteq': '⊉',
    'nsupseteqq': '⫆̸',
    'ntgl': '≹',
    'ntilde': 'ñ',
    'ntlg': '≸',
    'ntriangleleft': '⋪',
    'ntrianglelefteq': '⋬',
    'ntriangleright': '⋫',
    'ntrianglerighteq': '⋭',
    'nu': 'ν',
    'num': '#',
    'numero': '№',
    'numsp': '\u2007',
    'nvap': '≍⃒',
    'nvdash': '⊬',
    'nvge': '≥⃒',
    'nvgt': '>⃒',
    'nvharr': '⤄',
    'nvinfin': '⧞',
    'nvlarr': '⤂',
    'nvle': '≤⃒',
    'nvlt': '<⃒',
    'nvltrie': '⊴⃒',
    'nvrarr': '⤃',
    'nvrtrie': '⊵⃒',
    'nvsim': '∼⃒',
    'nwarhk': '⤣',
    'nwarr': '↖',
    'nwarrow': '↖',
    'nwnear': '⤧',
    'oacute': 'ó',
    'oast': '⊛',
    'ocir': '⊚',
    'ocirc': 'ô',
    'ocy': 'о',
    'odash': '⊝',
    'odblac': 'ő',
    'odiv': '⨸',
    'odot': '⊙',
    'odsold': '⦼',
    'oelig': 'œ',
    'ofcir': '⦿',
    'ofr': '𝔬',
    'ogon': '˛',
    'ograve': 'ò',
    'ogt': '⧁',
    'ohbar': '⦵',
    'ohm': 'Ω',
    'oint': '∮',
    'olarr': '↺',
    'olcir': '⦾',
    'olcross': '⦻',
    'oline': '‾',
    'olt': '⧀',
    'omacr': 'ō',
    'omega': 'ω',
    'omicron': 'ο',
    'omid': '⦶',
    'ominus': '⊖',
    'oopf': '𝕠',
    'opar': '⦷',
    'opencurlydoublequote': '“',
    'opencurlyquote': '‘',
    'operp': '⦹',
    'oplus': '⊕',
    'or': '∨',
    'orarr': '↻',
    'ord': '⩝',
    'order': 'ℴ',
    'orderof': 'ℴ',
    'ordf': 'ª',
    'ordm': 'º',
    'origof': '⊶',
    'oror': '⩖',
    'orslope': '⩗',
    'orv': '⩛',
    'os': 'Ⓢ',
    'oscr': 'ℴ',
    'oslash': 'ø',
    'osol': '⊘',
    'otilde': 'õ',
    'otimes': '⊗',
    'otimesas': '⨶',
    'ouml': 'ö',
    'ovbar': '⌽',
    'overbar': '‾',
    'overbrace': '⏞',
    'overbracket': '⎴',
    'overparenthesis': '⏜',
    'par': '∥',
    'para': '¶',
    'parallel': '∥',
    'parsim': '⫳',
    'parsl': '⫽',
    'part': '∂',
    'partiald': '∂',
    'pcy': 'п',
    'percnt': '%',
    'period': '.',
    'permil': '‰',
    'perp': '⊥',
    'pertenk': '‱',
    'pfr': '𝔭',
    'phi': 'φ',
    'phiv': 'ϕ',
    'phmmat': 'ℳ',
    'phone': '☎',
    'pi': 'π',
    'pitchfork': '⋔',
    'piv': 'ϖ',
    'planck': 'ℏ',
    'planckh': 'ℎ',
    'plankv': 'ℏ',
    'plus': '+',
    'plusacir': '⨣',
    'plusb': '⊞',
    'pluscir': '⨢',
    'plusdo': '∔',
    'plusdu': '⨥',
    'pluse': '⩲',
    'plusminus': '±',
    'plusmn': '±',
    'plussim': '⨦',
    'plustwo': '⨧',
    'pm': '±',
    'poincareplane': 'ℌ',
    'pointint': '⨕',
    'popf': '𝕡',
    'pound': '£',
    'pr': '≺',
    'prap': '⪷',
    'prcue': '≼',
    'pre': '⪯',
    'prec': '≺',
    'precapprox': '⪷',
    'preccurlyeq': '≼',
    'precedes': '≺',
    'precedesequal': '⪯',
    'precedesslantequal': '≼',
    'precedestilde': '≾',
    'preceq': '⪯',
    'precnapprox': '⪹',
    'precneqq': '⪵',
    'precnsim': '⋨',
    'precsim': '≾',
    'prime': '′',
    'primes': 'ℙ',
    'prnap': '⪹',
    'prne': '⪵',
    'prnsim': '⋨',
    'prod': '∏',
    'product': '∏',
    'profalar': '⌮',
    'profline': '⌒',
    'profsurf': '⌓',
    'prop': '∝',
    'proportion': '∷',
    'proportional': '∝',
    'propto': '∝',
    'prsim': '≾',
    'prurel': '⊰',
    'pscr': '𝓅',
    'psi': 'ψ',
    'puncsp': '\u2008',
    'qfr': '𝔮',
    'qint': '⨌',
    'qopf': '𝕢',
    'qprime': '⁗',
    'qscr': '𝓆',
    'quaternions': 'ℍ',
    'quatint': '⨖',
    'quest': '?',
    'questeq': '≟',
    'quot': '"',
    'raarr': '⇛',
    'race': '∽̱',
    'racute': 'ŕ',
    'radic': '√',
    'raemptyv': '⦳',
    'rang': '⟩',
    'rangd': '⦒',
    'range': '⦥',
    'rangle': '⟩',
    'raquo': '»',
    'rarr': '→',
    'rarrap': '⥵',
    'rarrb': '⇥',
    'rarrbfs': '⤠',
    'rarrc': '⤳',
    'rarrfs': '⤞',
    'rarrhk': '↪',
    'rarrlp': '↬',
    'rarrpl': '⥅',
    'rarrsim': '⥴',
    'rarrtl': '↣',
    'rarrw': '↝',
    'ratail': '⤚',
    'ratio': '∶',
    'rationals': 'ℚ',
    'rbarr': '⤍',
    'rbbrk': '❳',
    'rbrace': '}',
    'rbrack': ']',
    'rbrke': '⦌',
    'rbrksld': '⦎',
    'rbrkslu': '⦐',
    'rcaron': 'ř',
    'rcedil': 'ŗ',
    'rceil': '⌉',
    'rcub': '}',
    'rcy': 'р',
    'rdca': '⤷',
    'rdldhar': '⥩',
    'rdquo': '”',
    'rdquor': '”',
    'rdsh': '↳',
    're': 'ℜ',
    'real': 'ℜ',
    'realine': 'ℛ',
    'realpart': 'ℜ',
    'reals': 'ℝ',
    'rect': '▭',
    'reg': '®',
    'reverseelement': '∋',
    'reverseequilibrium': '⇋',
    'reverseupequilibrium': '⥯',
    'rfisht': '⥽',
    'rfloor': '⌋',
    'rfr': '𝔯',
    'rhar': '⥤',
    'rhard': '⇁',
    'rharu': '⇀',
    'rharul': '⥬',
    'rho': 'ρ',
    'rhov': 'ϱ',
    'rightanglebracket': '⟩',
    'rightarrow': '→',
    'rightarrowbar': '⇥',
    'rightarrowleftarrow': '⇄',
    'rightarrowtail': '↣',
    'rightceiling': '⌉',
    'rightdoublebracket': '⟧',
    'rightdownteevector': '⥝',
    'rightdownvector': '⇂',
    'rightdownvectorbar': '⥕',
    'rightfloor': '⌋',
    'rightharpoondown': '⇁',
    'rightharpoonup': '⇀',
    'rightleftarrows': '⇄',
    'rightleftharpoons': '⇌',
    'rightrightarrows': '⇉',
    'rightsquigarrow': '↝',
    'righttee': '⊢',
    'rightteearrow': '↦',
    'rightteevector': '⥛',
    'rightthreetimes': '⋌',
    'righttriangle': '⊳',
    'righttrianglebar': '⧐',
    'righttriangleequal': '⊵',
    'rightupdownvector': '⥏',
    'rightupteevector': '⥜',
    'rightupvector': '↾',
    'rightupvectorbar': '⥔',
    'rightvector': '⇀',
    'rightvectorbar': '⥓',
    'ring': '˚',
    'risingdotseq': '≓',
    'rlarr': '⇄',
    'rlhar': '⇌',
    'rlm': '\u200f',
    'rmoust': '⎱',
    'rmoustache': '⎱',
    'rnmid': '⫮',
    'roang': '⟭',
    'roarr': '⇾',
    'robrk': '⟧',
    'ropar': '⦆',
    'ropf': '𝕣',
    'roplus': '⨮',
    'rotimes': '⨵',
    'roundimplies': '⥰',
    'rpar': ')',
    'rpargt': '⦔',
    'rppolint': '⨒',
    'rrarr': '⇉',
    'rrightarrow': '⇛',
    'rsaquo': '›',
    'rscr': '𝓇',
    'rsh': '↱',
    'rsqb': ']',
    'rsquo': '’',
    'rsquor': '’',
    'rthree': '⋌',
    'rtimes': '⋊',
    'rtri': '▹',
    'rtrie': '⊵',
    'rtrif': '▸',
    'rtriltri': '⧎',
    'ruledelayed': '⧴',
    'ruluhar': '⥨',
    'rx': '℞',
    'sacute': 'ś',
    'sbquo': '‚',
    'sc': '≻',
    'scap': '⪸',
    'scaron': 'š',
    'sccue': '≽',
    'sce': '⪰',
    'scedil': 'ş',
    'scirc': 'ŝ',
    'scnap': '⪺',
    'scne': '⪶',
    'scnsim': '⋩',
    'scpolint': '⨓',
    'scsim': '≿',
    'scy': 'с',
    'sdot': '⋅',
    'sdotb': '⊡',
    'sdote': '⩦',
    'searhk': '⤥',
    'searr': '↘',
    'searrow': '↘',
    'sect': '§',
    'semi': ';',
    'seswar': '⤩',
    'setminus': '∖',
    'setmn': '∖',
    'sext': '✶',
    'sfr': '𝔰',
    'sfrown': '⌢',
    'sharp': '♯',
    'shchcy': 'щ',
    'shcy': 'ш',
    'shortdownarrow': '↓',
    'shortleftarrow': '←',
    'shortmid': '∣',
    'shortparallel': '∥',
    'shortrightarrow': '→',
    'shortuparrow': '↑',
    'shy': '\xad',
    'sigma': 'σ',
    'sigmaf': 'ς',
    'sigmav': 'ς',
    'sim': '∼',
    'simdot': '⩪',
    'sime': '≃',
    'simeq': '≃',
    'simg': '⪞',
    'simge': '⪠',
    'siml': '⪝',
    'simle': '⪟',
    'simne': '≆',
    'simplus': '⨤',
    'simrarr': '⥲',
    'slarr': '←',
    'smallcircle': '∘',
    'smallsetminus': '∖',
    'smashp': '⨳',
    'smeparsl': '⧤',
    'smid': '∣',
    'smile': '⌣',
    'smt': '⪪',
    'smte': '⪬',
    'smtes': '⪬︀',
    'softcy': 'ь',
    'sol': '/',
    'solb': '⧄',
    'solbar': '⌿',
    'sopf': '𝕤',
    'spades': '♠',
    'spadesuit': '♠',
    'spar': '∥',
    'sqcap': '⊓',
    'sqcaps': '⊓︀',
    'sqcup': '⊔',
    'sqcups': '⊔︀',
    'sqrt': '√',
    'sqsub': '⊏',
    'sqsube': '⊑',
    'sqsubset': '⊏',
    'sqsubseteq': '⊑',
    'sqsup': '⊐',
    'sqsupe': '⊒',
    'sqsupset': '⊐',
    'sqsupseteq': '⊒',
    'squ': '□',
    'square': '□',
    'squareintersection': '⊓',
    'squaresubset': '⊏',
    'squaresubsetequal': '⊑',
    'squaresuperset': '⊐',
    'squaresupersetequal': '⊒',
    'squareunion': '⊔',
    'squarf': '▪',
    'squf': '▪',
    'srarr': '→',
    'sscr': '𝓈',
    'ssetmn': '∖',
    'ssmile': '⌣',
    'sstarf': '⋆',
    'star': '☆',
    'starf': '★',
    'straightepsilon': 'ϵ',
    'straightphi': 'ϕ',
    'strns': '¯',
    'sub': '⊂',
    'subdot': '⪽',
    'sube': '⊆',
    'subedot': '⫃',
    'submult': '⫁',
    'subne': '⊊',
    'subplus': '⪿',
    'subrarr': '⥹',
    'subset': '⊂',
    'subseteq': '⊆',
    'subseteqq': '⫅',
    'subsetequal': '⊆',
    'subsetneq': '⊊',
    'subsetneqq': '⫋',
    'subsim': '⫇',
    'subsub': '⫕',
    'subsup': '⫓',
    'succ': '≻',
    'succapprox': '⪸',
    'succcurlyeq': '≽',
    'succeeds': '≻',
    'succeedsequal': '⪰',
    'succeedsslantequal': '≽',
    'succeedstilde': '≿',
    'succeq': '⪰',
    'succnapprox': '⪺',
    'succneqq': '⪶',
    'succnsim': '⋩',
    'succsim': '≿',
    'suchthat': '∋',
    'sum': '∑',
    'sung': '♪',
    'sup': '⊃',
    'sup1': '¹',
    'sup2': '²',
    'sup3': '³',
    'supdot': '⪾',
    'supdsub': '⫘',
    'supe': '⊇',
    'supedot': '⫄',
    'superset': '⊃',
    'supersetequal': '⊇',
    'suphsol': '⟉',
    'suphsub': '⫗',
    'suplarr': '⥻',
    'supmult': '⫂',
    'supne': '⊋',
    'supplus': '⫀',
    'supset': '⊃',
    'supseteq': '⊇',
    'supseteqq': '⫆',
    'supsetneq': '⊋',
    'supsetneqq': '⫌',
    'supsim': '⫈',
    'supsub': '⫔',
    'supsup': '⫖',
    'swarhk': '⤦',
    'swarr': '↙',
    'swarrow': '↙',
    'swnwar': '⤪',
    'szlig': 'ß',
    'tab': '	',
    'target': '⌖',
    'tau': 'τ',
    'tbrk': '⎴',
    'tcaron': 'ť',
    'tcedil': 'ţ',
    'tcy': 'т',
    'tdot': '⃛',
    'telrec': '⌕',
    'tfr': '𝔱',
    'there4': '∴',
    'therefore': '∴',
    'theta': 'θ',
    'thetasym': 'ϑ',
    'thetav': 'ϑ',
    'thickapprox': '≈',
    'thicksim': '∼',
    'thickspace': '\u205f\u200a',
    'thinsp': '\u2009',
    'thinspace': '\u2009',
    'thkap': '≈',
    'thksim': '∼',
    'thorn': 'þ',
    'tilde': '˜',
    'tildeequal': '≃',
    'tildefullequal': '≅',
    'tildetilde': '≈',
    'times': '×',
    'timesb': '⊠',
    'timesbar': '⨱',
    'timesd': '⨰',
    'tint': '∭',
    'toea': '⤨',
    'top': '⊤',
    'topbot': '⌶',
    'topcir': '⫱',
    'topf': '𝕥',
    'topfork': '⫚',
    'tosa': '⤩',
    'tprime': '‴',
    'trade': '™',
    'triangle': '▵',
    'triangledown': '▿',
    'triangleleft': '◃',
    'trianglelefteq': '⊴',
    'triangleq': '≜',
    'triangleright': '▹',
    'trianglerighteq': '⊵',
    'tridot': '◬',
    'trie': '≜',
    'triminus': '⨺',
    'tripledot': '⃛',
    'triplus': '⨹',
    'trisb': '⧍',
    'tritime': '⨻',
    'trpezium': '⏢',
    'tscr': '𝓉',
    'tscy': 'ц',
    'tshcy': 'ћ',
    'tstrok': 'ŧ',
    'twixt': '≬',
    'twoheadleftarrow': '↞',
    'twoheadrightarrow': '↠',
    'uacute': 'ú',
    'uarr': '↑',
    'uarrocir': '⥉',
    'ubrcy': 'ў',
    'ubreve': 'ŭ',
    'ucirc': 'û',
    'ucy': 'у',
    'udarr': '⇅',
    'udblac': 'ű',
    'udhar': '⥮',
    'ufisht': '⥾',
    'ufr': '𝔲',
    'ugrave': 'ù',
    'uhar': '⥣',
    'uharl': '↿',
    'uharr': '↾',
    'uhblk': '▀',
    'ulcorn': '⌜',
    'ulcorner': '⌜',
    'ulcrop': '⌏',
    'ultri': '◸',
    'umacr': 'ū',
    'uml': '¨',
    'underbar': '_',
    'underbrace': '⏟',
    'underbracket': '⎵',
    'underparenthesis': '⏝',
    'union': '⋃',
    'unionplus': '⊎',
    'uogon': 'ų',
    'uopf': '𝕦',
    'uparrow': '↑',
    'uparrowbar': '⤒',
    'uparrowdownarrow': '⇅',
    'updownarrow': '↕',
    'upequilibrium': '⥮',
    'upharpoonleft': '↿',
    'upharpoonright': '↾',
    'uplus': '⊎',
    'upperleftarrow': '↖',
    'upperrightarrow': '↗',
    'upsi': 'υ',
    'upsih': 'ϒ',
    'upsilon': 'υ',
    'uptee': '⊥',
    'upteearrow': '↥',
    'upuparrows': '⇈',
    'urcorn': '⌝',
    'urcorner': '⌝',
    'urcrop': '⌎',
    'uring': 'ů',
    'urtri': '◹',
    'uscr': '𝓊',
    'utdot': '⋰',
    'utilde': 'ũ',
    'utri': '▵',
    'utrif': '▴',
    'uuarr': '⇈',
    'uuml': 'ü',
    'uwangle': '⦧',
    'vangrt': '⦜',
    'varepsilon': 'ϵ',
    'varkappa': 'ϰ',
    'varnothing': '∅',
    'varphi': 'ϕ',
    'varpi': 'ϖ',
    'varpropto': '∝',
    'varr': '↕',
    'varrho': 'ϱ',
    'varsigma': 'ς',
    'varsubsetneq': '⊊︀',
    'varsubsetneqq': '⫋︀',
    'varsupsetneq': '⊋︀',
    'varsupsetneqq': '⫌︀',
    'vartheta': 'ϑ',
    'vartriangleleft': '⊲',
    'vartriangleright': '⊳',
    'vbar': '⫨',
    'vbarv': '⫩',
    'vcy': 'в',
    'vdash': '⊢',
    'vdashl': '⫦',
    'vee': '∨',
    'veebar': '⊻',
    'veeeq': '≚',
    'vellip': '⋮',
    'verbar': '|',
    'vert': '|',
    'verticalbar': '∣',
    'verticalline': '|',
    'verticalseparator': '❘',
    'verticaltilde': '≀',
    'verythinspace': '\u200a',
    'vfr': '𝔳',
    'vltri': '⊲',
    'vnsub': '⊂⃒',
    'vnsup': '⊃⃒',
    'vopf': '𝕧',
    'vprop': '∝',
    'vrtri': '⊳',
    'vscr': '𝓋',
    'vsubne': '⊊︀',
    'vsupne': '⊋︀',
    'vvdash': '⊪',
    'vzigzag': '⦚',
    'wcirc': 'ŵ',
    'wedbar': '⩟',
    'wedge': '∧',
    'wedgeq': '≙',
    'weierp': '℘',
    'wfr': '𝔴',
    'wopf': '𝕨',
    'wp': '℘',
    'wr': '≀',
    'wreath': '≀',
    'wscr': '𝓌',
    'xcap': '⋂',
    'xcirc': '◯',
    'xcup': '⋃',
    'xdtri': '▽',
    'xfr': '𝔵',
    'xharr': '⟷',
    'xi': 'ξ',
    'xlarr': '⟵',
    'xmap': '⟼',
    'xnis': '⋻',
    'xodot': '⨀',
    'xopf': '𝕩',
    'xoplus': '⨁',
    'xotime': '⨂',
    'xrarr': '⟶',
    'xscr': '𝓍',
    'xsqcup': '⨆',
    'xuplus': '⨄',
    'xutri': '△',
    'xvee': '⋁',
    'xwedge': '⋀',
    'yacute': 'ý',
    'yacy': 'я',
    'ycirc': 'ŷ',
    'ycy': 'ы',
    'yen': '¥',
    'yfr': '𝔶',
    'yicy': 'ї',
    'yopf': '𝕪',
    'yscr': '𝓎',
    'yucy': 'ю',
    'yuml': 'ÿ',
    'zacute': 'ź',
    'zcaron': 'ž',
    'zcy': 'з',
    'zdot': 'ż',
    'zeetrf': 'ℨ',
    'zerowidthspace': '\u200b',
    'zeta': 'ζ',
    'zfr': '𝔷',
    'zhcy': 'ж',
    'zigrarr': '⇝',
    'zopf': '𝕫',
    'zscr': '𝓏',
    'zwj': '\u200d',
    'zwnj': '\u200c',
# }}}
}


if __name__ == '__main__':
    import re
    from html5lib.constants import entities
    entities = {k.lower().replace(';', ''): entities[k] for k in entities}
    lines = []

    for k in sorted(entities):
        lines.append("    '%s': %r," % (k, entities[k]))

    with open(__file__, 'r+b') as f:
        raw = f.read().decode('utf-8')
        raw = re.sub(r'^# ENTITY_DATA {{{.+^# }}}',
                     '# ENTITY_DATA {{{\n' + '\n'.join(lines) + '\n# }}}',
                     raw, flags=re.M | re.DOTALL)
        f.seek(0), f.truncate()
        f.write(raw.encode('utf-8'))
