# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0
from __future__ import annotations

'''Client for the unit test of QSharedMemory'''

import os
import sys

from pathlib import Path
FILE = Path(__file__).resolve()
sys.path.append(os.fspath(FILE.parents[1]))
from init_paths import init_test_paths  # noqa: E402
init_test_paths(False)

from PySide6.QtCore import QSharedMemory  # noqa: E402


def read_string(shared_memory):
    """Read out a null-terminated string from the QSharedMemory"""
    mv = memoryview(shared_memory.constData())
    result = ''
    for i in range(shared_memory.size()):
        char = mv[i]
        if not char:
            break
        result += chr(char)
    return result


if __name__ == '__main__':
    if len(sys.argv) != 2:
        print('Pass segment name', file=sys.stderr)
        sys.exit(-1)
    shared_memory = QSharedMemory(sys.argv[1])
    name = "I have no name"     # Fixme: What should be there?
    if not shared_memory.attach(QSharedMemory.AccessMode.ReadOnly):
        raise SystemError(f'attach to "{name}" failed')
    if not shared_memory.lock():
        raise SystemError(f'lock of "{name}" failed')
    data = read_string(shared_memory)
    shared_memory.unlock()
    shared_memory.detach()
    sys.stdout.write(data)
    sys.exit(0)
