#ifdef __cplusplus
extern "C" {
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <config.h>
#include <uuid/uuid.h>

#ifdef __cplusplus
}
#endif


/* 2 hex digits per byte + 4 separators + 1 trailing null */
#define UUID_BUF_SZ 37


MODULE = UUID		PACKAGE = UUID


void
generate(str)
    SV * str
    PROTOTYPE: $
    INIT:
    uuid_t uuid;
    CODE:
    uuid_generate(uuid);
    sv_setpvn(str, (char*)uuid, sizeof(uuid_t));

void
generate_random(str)
    SV * str
    PROTOTYPE: $
    INIT:
    uuid_t uuid;
    CODE:
    uuid_generate_random( uuid );
    sv_setpvn(str, (char*)uuid, sizeof(uuid_t));

void
generate_time(str)
    SV * str
    PROTOTYPE: $
    INIT:
    uuid_t uuid;
    CODE:
    uuid_generate_time( uuid );
    sv_setpvn(str, (char*)uuid, sizeof(uuid_t));

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse(SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse_lower(SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse_upper(SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

int
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    uuid_t uuid;
    CODE:
    RETVAL = uuid_parse(SvGROW(in, UUID_BUF_SZ+1), uuid);
    if( !RETVAL )
        sv_setpvn(out, (char*)uuid, sizeof(uuid_t));
    OUTPUT:
    RETVAL

void
clear(in)
    SV * in
    PROTOTYPE: $
    INIT:
    uuid_t uuid;
    CODE:
    uuid_clear(uuid);
    sv_setpvn(in, (char*)uuid, sizeof(uuid_t));

int
is_null(in)
    SV * in
    PROTOTYPE: $
    CODE:
    if( SvCUR(in) != sizeof(uuid_t) )
        RETVAL = 0;
    else
        RETVAL = uuid_is_null(SvGROW(in, sizeof(uuid_t)+1));
    OUTPUT:
    RETVAL

void
copy(dst, src)
    SV * dst
    SV * src
    INIT:
    uuid_t uuid;
    CODE:
    if( SvCUR(src) != sizeof(uuid_t) )
        uuid_clear(uuid);
    else
        uuid_copy(uuid, SvGROW(src, sizeof(uuid_t)+1));
    sv_setpvn(dst, (char*)uuid, sizeof(uuid_t));

int
compare(uu1, uu2)
    SV * uu1
    SV * uu2
    CODE:
    RETVAL = uuid_compare( SvGROW(uu1, sizeof(uuid_t)+1), SvGROW(uu2, sizeof(uuid_t)+1) );
    OUTPUT:
    RETVAL

int
type(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = uuid_type(SvGROW(in, sizeof(uuid_t)+1));
    OUTPUT:
    RETVAL

time_t
time(in)
    SV * in
    PROTOTYPE: $
    INIT:
    struct timeval tv;
    CODE:
    RETVAL = uuid_time(SvGROW(in, sizeof(uuid_t)+1), &tv);
    OUTPUT:
    RETVAL

int
variant(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = uuid_variant(SvGROW(in, sizeof(uuid_t)+1));
    OUTPUT:
    RETVAL

SV*
uuid()
    PROTOTYPE:
    INIT:
    uuid_t uuid;
    unsigned char str[UUID_BUF_SZ];
    CODE:
    uuid_generate(uuid);
    uuid_unparse(uuid, str);
    RETVAL = newSVpvn(str, UUID_BUF_SZ-1);
    OUTPUT:
    RETVAL
