/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDDictionaryWrapper;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDDefaultAttributeObject;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDUserAttributeObject;

public abstract class PDAttributeObject
extends PDDictionaryWrapper {
    private PDStructureElement structureElement;

    public static PDAttributeObject create(COSDictionary dictionary) {
        String owner = dictionary.getNameAsString(COSName.O);
        if ("UserProperties".equals(owner)) {
            return new PDUserAttributeObject(dictionary);
        }
        return new PDDefaultAttributeObject(dictionary);
    }

    private PDStructureElement getStructureElement() {
        return this.structureElement;
    }

    protected void setStructureElement(PDStructureElement structureElement) {
        this.structureElement = structureElement;
    }

    public PDAttributeObject() {
    }

    public PDAttributeObject(COSDictionary dictionary) {
        super(dictionary);
    }

    public String getOwner() {
        return this.getCOSDictionary().getNameAsString(COSName.O);
    }

    protected void setOwner(String owner) {
        this.getCOSDictionary().setName(COSName.O, owner);
    }

    public boolean isEmpty() {
        return this.getCOSDictionary().size() == 1 && this.getOwner() != null;
    }

    protected void potentiallyNotifyChanged(Object oldValue, Object newValue) {
        if (this.isValueChanged(oldValue, newValue)) {
            this.notifyChanged();
        }
    }

    private boolean isValueChanged(Object oldValue, Object newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    protected void notifyChanged() {
        if (this.getStructureElement() != null) {
            this.getStructureElement().attributeChanged(this);
        }
    }

    public String toString() {
        return "O=" + this.getOwner();
    }

    protected static String arrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
        }
        return sb.append(']').toString();
    }

    protected static String arrayToString(float[] array) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
        }
        return sb.append(']').toString();
    }
}

