#!/usr/bin/perl

package eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. MaximumUnpaidItemStrikesInfoType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType

=head1 DESCRIPTION

Container for MaximumUnpaidItemStrikes buyer requirement in item listings.
A similar tag, BuyerRequirements.MaximumUnpaidItemStrikes has been deprecated.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::PeriodCodeType;


my @gaProperties = ( [ 'Count', 'xs:int', '', '', '' ]
	, [ 'Period', 'ns:PeriodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PeriodCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCount()

Maximum allowed unpaid item strikes against the buyer.
If the limit is reached, the buyer can not bid on this item.
Used with Period.

Max: Default: 2
Min: 
  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  OnlyTheseValues: 2, 3, 4, 5

#    Argument: 'xs:int'

=cut

sub setCount {
  my $self = shift;
  $self->{'Count'} = shift
}

=head2 getCount()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally
  OnlyTheseValues: 2, 3, 4, 5

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  OnlyTheseValues: 2, 3, 4, 5

#    Returns: 'xs:int'

=cut

sub getCount {
  my $self = shift;
  return $self->{'Count'};
}


=head2 setPeriod()

If a buyer fails to pay for an item, they incur
an unpaid item strike on their account. The Period and Count elements
allow a seller to specify that only buyers with a specified number of
item strikes (or less) within a given period of time can bid on their
item. If a buyer has more strikes than specified within these limits,
the buyer can not bid on this item.
The Period is the past number of days (last 60 days, last 180 days, etc.)
within which the unpaid item buyer strikes are calculated.
Used with Count.

Max: Default: Days_30
Min: 
  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  OnlyTheseValues: Days_30, Days_180, Days_360

#    Argument: 'ns:PeriodCodeType'

=cut

sub setPeriod {
  my $self = shift;
  $self->{'Period'} = shift
}

=head2 getPeriod()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally
  OnlyTheseValues: Days_30, Days_180, Days_360

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  OnlyTheseValues: Days_30, Days_180, Days_360

#    Returns: 'ns:PeriodCodeType'

=cut

sub getPeriod {
  my $self = shift;
  return $self->{'Period'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
