#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

ΟΙΚΟΥΜΕΝΙΚΗ ΔΙΑΚΗΡΥΞΗ ΓΙΑ ΤΑ ΑΝΘΡΩΠΙΝΑ ΔΙΚΑΙΩΜΑΤΑ
10 ΔΕΚΕΜΒΡΙΟΥ 1948

ΠΡΟΟΙΜΙΟ
Επειδή η αναγνώριση της αξιοπρέπειας, που είναι σύμφυτη σε όλα τα μέλη της ανθρώπινης οικογένειας, καθώς και των ίσων και αναπαλλοτρίωτων δικαιωμάτων τους αποτελεί το θεμέλιο της ελευθερίας, της δικαιοσύνης και της ειρήνης στον κόσμο.

Επειδή η παραγνώριση και η περιφρόνηση των δικαιωμάτων του ανθρώπου οδήγησαν σε πράξεις βαρβαρότητας, που εξεγείρουν την ανθρώπινη συνείδηση, και η προοπτική ενός κόσμου όπου οι άνθρωποι θα είναι ελεύθεροι να μιλούν και να πιστεύουν, λυτρωμένοι από τον τρόμο και την αθλιότητα, έχει διακηρυχθεί ως η πιο υψηλή επιδίωξη του ανθρώπου.

Επειδή έχει ουσιαστική σημασία να προστατεύονται τα ανθρώπινα δικαιώματα από ένα καθεστώς δικαίου, ώστε ο άνθρωπος να μην αναγκάζεται να προσφεύγει, ως έσχατο καταφύγιο, στην εξέγερση κατά της τυραννίας και της καταπίεσης.

Επειδή έχει ουσιαστική σημασία να ενθαρρύνεται η ανάπτυξη φιλικών σχέσεων ανάμεσα στα έθνη.

Επειδή, με τον καταστατικό Χάρτη, οι λαοί των Ηνωμένων Εθνών διακήρυξαν και πάλι την πίστη τους στα θεμελιακά δικαιώματα του ανθρώπου, στην αξιοπρέπεια και την αξία της ανθρώπινης προσωπικότητας, στην ισότητα δικαιωμάτων ανδρών και γυναικών, και διακήρυξαν πως είναι αποφασισμένοι να συντελέσουν στην κοινωνική πρόοδο και να δημιουργήσουν καλύτερες συνθήκες ζωής στα πλαίσια μιας ευρύτερης ελευθερίας.

Επειδή τα κράτη μέλη ανέλαβαν την υποχρέωση να εξασφαλίσουν, σε συνεργασία με τον Οργανισμό των Ηνωμένων Εθνών, τον αποτελεσματικό σεβασμό των δικαιωμάτων του ανθρώπου και των θεμελιακών ελευθεριών σε όλο τον κόσμο.

Επειδή η ταυτότητα αντιλήψεων ως προς τα δικαιώματα και τις ελευθερίες αυτές έχει εξαιρετική σημασία για να εκπληρωθεί πέρα ως πέρα αυτή η υποχρέωση,

Η ΓΕΝΙΚΗ ΣΥΝΕΛΕΥΣΗ

Διακηρύσσει ότι η παρούσα Οικουμενική Διακήρυξη των Δικαιωμάτων του Ανθρώπου αποτελεί το κοινό ιδανικό στο οποίο πρέπει να κατατείνουν όλοι οι λαοί και όλα τα έθνη, έτσι ώστε κάθε άτομο και κάθε όργανο της κοινωνίας, με τη Διακήρυξη αυτή διαρκώς στη σκέψη, να καταβάλλει, με τη διδασκαλία και την παιδεία, κάθε προσπάθεια για να αναπτυχθεί ο σεβασμός των δικαιωμάτων και των ελευθεριών αυτών, και να εξασφαλιστεί προοδευτικά, με εσωτερικά και διεθνή μέσα, η παγκόσμια και αποτελεσματική εφαρμογή τους, τόσο ανάμεσα στους λαούς των ίδιων των κρατών μελών όσο και ανάμεσα στους πληθυσμούς χωρών που βρίσκονται στη δικαιοδοσία τους.

ΑΡΘΡΟ 1
'Ολοι οι άνθρωποι γεννιούνται ελεύθεροι και ίσοι στην αξιοπρέπεια και τα δικαιώματα. Είναι προικισμένοι με λογική και συνείδηση, και οφείλουν να συμπεριφέρονται μεταξύ τους με πνεύμα αδελφοσύνης.

ΑΡΘΡΟ 2
Κάθε άνθρωπος δικαιούται να επικαλείται όλα τα δικαιώματα και όλες τις ελευθερίες που προκηρύσσει η παρούσα Διακήρυξη, χωρίς καμία απολύτως διάκριση, ειδικότερα ως προς τη φυλή, το χρώμα, το φύλο, τη γλώσσα, τις θρησκείες, τις πολιτικές ή οποιεσδήποτε άλλες πεποιθήσεις, την εθνική ή κοινωνική καταγωγή, την περιουσία, τη γέννηση ή οποιαδήποτε άλλη κατάσταση.

Δεν θα μπορεί ακόμα να γίνεται καμία διάκριση εξαιτίας του πολιτικού, νομικού ή διεθνούς καθεστώτος της χώρας από την οποία προέρχεται κανείς, είτε πρόκειται για χώρα ή εδαφική περιοχή ανεξάρτητη, υπό κηδεμονία ή υπεξουσία, ή που βρίσκεται υπό οποιονδήποτε άλλον περιορισμό κυριαρχίας.

ΑΡΘΡΟ 3
Κάθε άτομο έχει δικαίωμα στη ζωή, την ελευθερία και την προσωπική του ασφάλεια.

ΑΡΘΡΟ 4
Κανείς δεν επιτρέπεται να ζει υπό καθεστώς δουλείας, ολικής ή μερικής. Η δουλεία και το δουλεμπόριο υπό οποιαδήποτε μορφή απαγορεύονται.

ΑΡΘΡΟ 5
Κανείς δεν επιτρέπεται να υποβάλλεται σε βασανιστήρια ούτε σε ποινή ή μεταχείριση σκληρή, απάνθρωπη ή ταπεινωτική.

ΑΡΘΡΟ 6
Καθένας, όπου και αν βρίσκεται, έχει δικαίωμα στην αναγνώριση της νομικής του προσωπικότητας.

ΑΡΘΡΟ 7
'Ολοι είναι ίσοι απέναντι στον νόμο και έχουν δικαίωμα σε ίση προστασία του νόμου, χωρίς καμία απολύτως διάκριση. 'Ολοι έχουν δικαίωμα σε ίση προστασία από κάθε διάκριση που θα παραβίαζε την παρούσα Διακήρυξη και από κάθε πρόκληση για μια τέτοια δυσμενή διάκριση.

ΑΡΘΡΟ 8
Καθένας έχει δικαίωμα να ασκεί αποτελεσματικά ένδικα μέσα στα αρμόδια εθνικά δικαστήρια κατά των πράξεων που παραβιάζουν τα θεμελιακά δικαιώματα τα οποία του αναγνωρίζουν το Σύνταγμα και ο νόμος.

ΑΡΘΡΟ 9
Κανείς δεν μπορεί να συλλαμβάνεται, να κρατείται ή να εξορίζεται αυθαίρετα.

ΑΡΘΡΟ 10
Καθένας έχει δικαίωμα, με πλήρη ισότητα, να εκδικάζεται η υπόθεσή του δίκαια και δημόσια, από δικαστήριο ανεξάρτητο και αμερόληπτο, που θα αποφασίσει είτε για τα δικαιώματα και τις υποχρεώσεις του είτε, σε περίπτωση ποινικής διαδικασίας, για το βάσιμο της κατηγορίας που στρέφεται εναντίον του.

ΑΡΘΡΟ 11
Κάθε κατηγορούμενος για ποινικό αδίκημα πρέπει να θεωρείται αθώος, ωσότου διαπιστωθεί η ενοχή του σύμφωνα με τον νόμο, σε ποινική δίκη, κατά την οποία θα του έχουν εξασφαλιστεί όλες οι απαραίτητες για την υπεράσπισή του εγγυήσεις.
Κανείς δεν θα καταδικάζεται για πράξεις ή παραλείψεις που, κατά τον χρόνο που τελέστηκαν, δεν συνιστούσαν αξιόποινο αδίκημα κατά το εσωτερικό ή το διεθνές δίκαιο. Επίσης, δεν επιβάλλεται ποινή βαρύτερη από εκείνη που ίσχυε κατά τον χρόνο που τελέστηκε η αξιόποινη πράξη.
ΑΡΘΡΟ 12
Κανείς δεν επιτρέπεται να υποστεί αυθαίρετες επεμβάσεις στην ιδιωτική του ζωή, την οικογένεια, την κατοικία ή την αλληλογραφία του, ούτε προσβολές της τιμής και της υπόληψης του. Καθένας έχει το δικαίωμα να τον προστατεύουν οι νόμοι από επεμβάσεις και προσβολές αυτού του είδους.

ΑΡΘΡΟ 13
Καθένας έχει το δικαίωμα να κυκλοφορεί ελεύθερα και να εκλέγει τον τόπο της διαμονής του στο εσωτερικό ενός κράτους.
Καθένας έχει το δικαίωμα να εγκαταλείπει οποιαδήποτε χώρα, ακόμα και τη δική του, και να επιστρέφει σε αυτήν.
ΑΡΘΡΟ 14
Κάθε άτομο που καταδιώκεται έχει το δικαίωμα να ζητά άσυλο και του παρέχεται άσυλο σε άλλες χώρες.
Το δικαίωμα αυτό δεν μπορεί κανείς να το επικαλεστεί, σε περίπτωση δίωξης για πραγματικό αδίκημα του κοινού ποινικού δικαίου ή για ενέργειες αντίθετες προς τους σκοπούς και τις αρχές του ΟΗΕ.
ΑΡΘΡΟ 15
Καθένας έχει το δικαίωμα μιας ιθαγένειας.
Κανείς δεν μπορεί να στερηθεί αυθαίρετα την ιθαγένειά του ούτε το δικαίωμα να αλλάξει ιθαγένεια.
ΑΡΘΡΟ 16
Από τη στιγμή που θα φθάσουν σε ηλικία γάμου, ο άνδρας και η γυναίκα, χωρίς κανένα περιορισμό εξαιτίας της φυλής, της εθνικότητας ή της θρησκείας, έχουν το δικαίωμα να παντρεύονται και να ιδρύουν οικογένεια. Και οι δύο έχουν ίσα δικαιώματα ως προς τον γάμο, κατά τη διάρκεια του γάμου και κατά τη διάλυσή του.
Γάμος δεν μπορεί να συναφθεί παρά μόνο με ελεύθερη και πλήρη συναίνεση των μελλονύμφων.
Η οικογένεια είναι το φυσικό και το βασικό στοιχείο της κοινωνίας και έχει το δικαίωμα προστασίας από την κοινωνία και το κράτος.
ΑΡΘΡΟ 17
Κάθε άτομο, μόνο του ή με άλλους μαζί, έχει το δικαίωμα της ιδιοκτησίας.
Κανείς δεν μπορεί να στερηθεί αυθαίρετα την ιδιοκτησία του.
ΑΡΘΡΟ 18
Κάθε άτομο έχει το δικαίωμα της ελευθερίας της σκέψης, της συνείδησης και της θρησκείας. Στο δικαίωμα αυτό περιλαμβάνεται η ελευθερία για την αλλαγή της θρησκείας ή πεποιθήσεων, όπως και η ελευθερία να εκδηλώνει κανείς τη θρησκεία του ή τις θρησκευτικές του πεποιθήσεις, μόνος ή μαζί με άλλους, δημόσια ή ιδιωτικά, με τη διδασκαλία, την άσκηση, τη λατρεία και με την τέλεση θρησκευτικών τελετών.

ΑΡΘΡΟ 19
Καθένας έχει το δικαίωμα της ελευθερίας της γνώμης και της έκφρασης, που σημαίνει το δικαίωμα να μην υφίσταται δυσμενείς συνέπειες για τις γνώμες του, και το δικαίωμα να αναζητεί, να παίρνει και να διαδίδει πληροφορίες και ιδέες, με οποιοδήποτε μέσο έκφρασης, και από όλο τον κόσμο.

ΑΡΘΡΟ 20
Καθένας έχει το δικαίωμα να συνέρχεται και να συνεταιρίζεται ελεύθερα και για ειρηνικούς σκοπούς.
Κανείς δεν μπορεί να υποχρεωθεί να συμμετέχει σε ορισμένο σωματείο.
ΑΡΘΡΟ 21
Καθένας έχει το δικαίωμα να συμμετέχει στη διακυβέρνηση της χώρας του, άμεσα ή έμμεσα, με αντιπροσώπους ελεύθερα εκλεγμένους.
Καθένας έχει το δικαίωμα να γίνεται δεκτός, υπό ίσους όρους, στις δημόσιες υπηρεσίες της χώρας του.
Η λαϊκή θέληση είναι το θεμέλιο της κρατικής εξουσίας. Η θέληση αυτή πρέπει να εκφράζεται με τίμιες εκλογές, οι οποίες πρέπει να διεξάγονται περιοδικά, με καθολική, ίση και μυστική ψηφοφορία, ή με αντίστοιχη διαδικασία που να εξασφαλίζει την ελευθερία της εκλογής.
ΑΡΘΡΟ 22
Κάθε άτομο, ως μέλος του κοινωνικού συνόλου, έχει δικαίωμα κοινωνικής προστασίας. Η κοινωνία, με την εθνική πρωτοβουλία και τη διεθνή συνεργασία, ανάλογα πάντα με την οργάνωση και τις οικονομικές δυνατότητες κάθε κράτους, έχει χρέος να του εξασφαλίσει την ικανοποίηση των οικονομικών, κοινωνικών και πολιτιστικών δικαιωμάτων που είναι απαραίτητα για την αξιοπρέπεια και την ελεύθερη ανάπτυξη της προσωπικότητάς του.

ΑΡΘΡΟ 23
Καθένας έχει το δικαίωμα να εργάζεται και να επιλέγει ελεύθερα το επάγγελμά του, να έχει δίκαιες και ικανοποιητικές συνθήκες δουλειάς και να προστατεύεται από την ανεργεία.
'Ολοι, χωρίς καμία διάκριση, έχουν το δικαίωμα ίσης αμοιβής για ίση εργασία.
Κάθε εργαζόμενος έχει δικαίωμα δίκαιης και ικανοποιητικής αμοιβής, που να εξασφαλίζει σε αυτόν και την οικογένειά του συνθήκες ζωής άξιες στην ανθρώπινη αξιοπρέπεια. Η αμοιβή της εργασίας, αν υπάρχει, πρέπει να συμπληρώνεται με άλλα μέσα κοινωνικής προστασίας.
Καθένας έχει το δικαίωμα να ιδρύει μαζί με άλλους συνδικάτα και να συμμετέχει σε συνδικάτα για την προάσπιση των συμφερόντων του.
ΑΡΘΡΟ 24
Καθένας έχει το δικαίωμα στην ανάπαυση, σε ελεύθερο χρόνο, και ιδιαίτερα, σε λογικό περιορισμό του χρόνου εργασίας και σε περιοδικές άδειες με πλήρεις αποδοχές.

ΑΡΘΡΟ 25
Καθένας έχει δικαίωμα σε ένα βιοτικό επίπεδο ικανό να εξασφαλίσει στον ίδιο και στην οικογένεια του υγεία και ευημερία, και ειδικότερα τροφή, ρουχισμό, κατοικία, ιατρική περίθαλψη όπως και τις απαραίτητες κοινωνικές υπηρεσίες. 'Εχει ακόμα δικαίωμα σε ασφάλιση για την ανεργία, την αρρώστια, την αναπηρία, τη χηρεία, τη γεροντική ηλικία, όπως και για όλες τις άλλες περιπτώσεις που στερείται τα μέσα της συντήρησής του, εξαιτίας περιστάσεων ανεξαρτήτων της θέλησης του.
Η μητρότητα και η παιδική ηλικία έχουν δικαίωμα ειδικής μέριμνας και περίθαλψης. 'Ολα τα παιδιά, ανεξάρτητα αν είναι νόμιμα ή εξώγαμα, απολαμβάνουν την ίδια κοινωνική προστασία.
ΑΡΘΡΟ 26
Καθένας έχει δικαίωμα στην εκπαίδευση. Η εκπαίδευση πρέπει να παρέχεται δωρεάν, τουλάχιστον στη στοιχειώδη και βασική βαθμίδα της. Η στοιχειώδης εκπαίδευση είναι υποχρεωτική. Η τεχνική και επαγγελματική εκπαίδευση πρέπει να εξασφαλίζεται για όλους. Η πρόσβαση στην ανώτατη παιδεία πρέπει να είναι ανοικτή σε όλους, υπό ίσους όρους, ανάλογα με τις ικανότητες τους.
Η εκπαίδευση πρέπει να αποβλέπει στην πλήρη ανάπτυξη της ανθρώπινης προσωπικότητας και στην ενίσχυση του σεβασμού των ανθρωπίνων δικαιωμάτων και των θεμελιακών ελευθεριών. Πρέπει να προάγει την κατανόηση, την ανεκτικότητα και τη φιλία ανάμεσα σε όλα τα έθνη και σε όλες τις φυλές και τις θρησκευτικές ομάδες, και να ευνοεί την ανάπτυξη των δραστηριοτήτων των Ηνωμένων Εθνών για τη διατήρηση της ειρήνης.
Οι γονείς έχουν, κατά προτεραιότητα, το δικαίωμα να επιλέγουν το είδος της παιδείας που θα δοθεί στα παιδιά τους.
ΑΡΘΡΟ 27
Καθένας έχει το δικαίωμα να συμμετέχει ελεύθερα στην πνευματική ζωή της κοινότητας, να χαίρεται τις καλές τέχνες και να μετέχει στην επιστημονική πρόοδο και στα αγαθά της.
Καθένας έχει το δικαίωμα να προστατεύονται τα ηθικά και υλικά συμφέροντά του που απορρέουν από κάθε είδους επιστημονική, λογοτεχνική ή καλλιτεχνική παραγωγή του.
ΑΡΘΡΟ 28
Καθένας έχει το δικαίωμα να επικρατεί μια κοινωνική και διεθνής τάξη, μέσα στην οποία τα δικαιώματα και οι ελευθερίες που προκηρύσσει η παρούσα Διακήρυξη να μπορούν να πραγματώνονται σε όλη τους την έκταση.

ΑΡΘΡΟ 29
Το άτομο έχει καθήκοντα απέναντι στην κοινότητα, μέσα στα πλαίσια της οποίας και μόνο είναι δυνατή η ελεύθερη και ολοκληρωμένη ανάπτυξη της προσωπικότητάς του.
Στην άσκηση των δικαιωμάτων του και στην απόλαυση των ελευθεριών του κανείς δεν υπόκειται παρά μόνο στους περιορισμούς που ορίζονται από τους νόμους, με αποκλειστικό σκοπό να εξασφαλίζεται η αναγνώριση και ο σεβασμός των δικαιωμάτων και των ελευθεριών των άλλων, και να ικανοποιούνται οι δίκαιες απαιτήσεις της ηθικής, της δημόσιας τάξης και του γενικού καλού, σε μια δημοκρατική κοινωνία.
Τα δικαιώματα αυτά και οι ελευθερίες δεν μπορούν, σε καμία περίπτωση, να ασκούνται αντίθετα προς τους σκοπούς και τις αρχές των Ηνωμένων Εθνών.
ΑΡΘΡΟ 30
Καμιά διάταξη της παρούσας Διακήρυξης δεν μπορεί να ερμηνευθεί ότι παρέχει σε ένα κράτος, σε μια ομάδα ή σε ένα άτομο οποιοδήποτε δικαίωμα να επιδίδεται σε ενέργειες ή να εκτελεί πράξεις που αποβλέπουν στην άρνηση των δικαιωμάτων και των ελευθεριών που εξαγγέλλονται σε αυτήν.


TEXT

is(Text::Guess::Language->guess($text),'el','is el');

done_testing;
