# Generated by default/object.tt
package Paws::FMS::DnsRuleGroupPriorityConflictViolation;
  use Moose;
  has ConflictingPolicyId => (is => 'ro', isa => 'Str');
  has ConflictingPriority => (is => 'ro', isa => 'Int');
  has UnavailablePriorities => (is => 'ro', isa => 'ArrayRef[Int]');
  has ViolationTarget => (is => 'ro', isa => 'Str');
  has ViolationTargetDescription => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::DnsRuleGroupPriorityConflictViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::DnsRuleGroupPriorityConflictViolation object:

  $service_obj->Method(Att1 => { ConflictingPolicyId => $value, ..., ViolationTargetDescription => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::DnsRuleGroupPriorityConflictViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->ConflictingPolicyId

=head1 DESCRIPTION

A rule group that Firewall Manager tried to associate with a VPC has
the same priority as a rule group that's already associated.

=head1 ATTRIBUTES


=head2 ConflictingPolicyId => Str

The ID of the Firewall Manager DNS Firewall policy that was already
applied to the VPC. This policy contains the rule group that's already
associated with the VPC.


=head2 ConflictingPriority => Int

The priority setting of the two conflicting rule groups.


=head2 UnavailablePriorities => ArrayRef[Int]

The priorities of rule groups that are already associated with the VPC.
To retry your operation, choose priority settings that aren't in this
list for the rule groups in your new DNS Firewall policy.


=head2 ViolationTarget => Str

The ID of the VPC.


=head2 ViolationTargetDescription => Str

A description of the violation that specifies the VPC and the rule
group that's already associated with it.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

