# Generated by default/object.tt
package Paws::LexModelsV2::ExportResourceSpecification;
  use Moose;
  has BotExportSpecification => (is => 'ro', isa => 'Paws::LexModelsV2::BotExportSpecification', request_name => 'botExportSpecification', traits => ['NameInRequest']);
  has BotLocaleExportSpecification => (is => 'ro', isa => 'Paws::LexModelsV2::BotLocaleExportSpecification', request_name => 'botLocaleExportSpecification', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::ExportResourceSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::ExportResourceSpecification object:

  $service_obj->Method(Att1 => { BotExportSpecification => $value, ..., BotLocaleExportSpecification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::ExportResourceSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->BotExportSpecification

=head1 DESCRIPTION

Provides information about the bot or bot locale that you want to
export. You can specify the C<botExportSpecification> or the
C<botLocaleExportSpecification>, but not both.

=head1 ATTRIBUTES


=head2 BotExportSpecification => L<Paws::LexModelsV2::BotExportSpecification>

Parameters for exporting a bot.


=head2 BotLocaleExportSpecification => L<Paws::LexModelsV2::BotLocaleExportSpecification>

Parameters for exporting a bot locale.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

