/*
 * Copyright 1995-2016 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the OpenSSL license (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

/*
 * NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */

#ifndef HEADER_HWCRHK_ERR_H
# define HEADER_HWCRHK_ERR_H

#ifdef  __cplusplus
extern "C" {
#endif

/* BEGIN ERROR CODES */
static void ERR_load_HWCRHK_strings(void);
static void ERR_unload_HWCRHK_strings(void);
static void ERR_HWCRHK_error(int function, int reason, char *file, int line);
# define HWCRHKerr(f,r) ERR_HWCRHK_error((f),(r),OPENSSL_FILE,OPENSSL_LINE)

/* Error codes for the HWCRHK functions. */

/* Function codes. */
# define HWCRHK_F_HWCRHK_CTRL                             100
# define HWCRHK_F_HWCRHK_FINISH                           101
# define HWCRHK_F_HWCRHK_GET_PASS                         102
# define HWCRHK_F_HWCRHK_INIT                             103
# define HWCRHK_F_HWCRHK_INSERT_CARD                      104
# define HWCRHK_F_HWCRHK_LOAD_PRIVKEY                     105
# define HWCRHK_F_HWCRHK_LOAD_PUBKEY                      106
# define HWCRHK_F_HWCRHK_MOD_EXP                          107
# define HWCRHK_F_HWCRHK_RAND_BYTES                       108
# define HWCRHK_F_HWCRHK_RSA_MOD_EXP                      109
# define HWCRHK_F_BIND_HELPER                             110
# define HWCRHK_F_HWCRHK_MUTEX_INIT                       111

/* Reason codes. */
# define HWCRHK_R_ALREADY_LOADED                          100
# define HWCRHK_R_BIO_WAS_FREED                           101
# define HWCRHK_R_CHIL_ERROR                              102
# define HWCRHK_R_CTRL_COMMAND_NOT_IMPLEMENTED            103
# define HWCRHK_R_DSO_FAILURE                             104
# define HWCRHK_R_MISSING_KEY_COMPONENTS                  105
# define HWCRHK_R_NOT_INITIALISED                         106
# define HWCRHK_R_NOT_LOADED                              107
# define HWCRHK_R_NO_CALLBACK                             108
# define HWCRHK_R_NO_KEY                                  109
# define HWCRHK_R_PRIVATE_KEY_ALGORITHMS_DISABLED         110
# define HWCRHK_R_REQUEST_FAILED                          111
# define HWCRHK_R_REQUEST_FALLBACK                        112
# define HWCRHK_R_UNIT_FAILURE                            113

#ifdef  __cplusplus
}
#endif
#endif
