use strict;
use warnings;

use Test::More tests => 8;
use blib;

my $perl = $^X;
ok($perl, "perl executable can be found: [$perl]");

my $result = `$perl -e'print 1;'`;
ok($result, "perl can be executed: [$result]");

my $example = 't/basic1.xml';
ok(-e $example, "example file exists: [$example]");

$result = `$perl $example`;
ok($result, "example file can be run by perl: [".length($result)." bytes]");

my $expected = '<h1>1, 2, 3, 4, 5, 6, 7, 8, 9, 10</h1>';
like($result, qr($expected), "print result is like expected: [$expected]");

$expected = '<h2>abcdef</h2>';
like($result, qr($expected), "multiple prints like expected: [$expected]");

$expected = '<h3>xyz</h3>';
like($result, qr($expected), "package and sub output like expected: [$expected]");

$expected = "<b>snap</b><b>snap</b><b>snap</b>";
like($result, qr($expected), "result of loop is like expected: [$expected]");


print $result;