/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class LivingSpace {
    private final Participant p;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final ComponentType headType;
    private final ComponentType tailType;
    private final LivingSpace previous;
    private LivingSpace next;
    private final Real posB;
    private Real posC;
    private Real posD;

    public String toString() {
        return this.p.getCode() + " B=" + this.posB.getCurrentValue() + "/C=" + LivingSpace.currentValue(this.posC) + "/D=" + LivingSpace.currentValue(this.posD);
    }

    private static String currentValue(Real real) {
        if (real == null) {
            return null;
        }
        return "" + real.getCurrentValue();
    }

    public LivingSpace(Participant participant, ParticipantEnglober participantEnglober, Skin skin, ISkinParam iSkinParam, Real real, LivingSpace livingSpace) {
        this.p = participant;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.posB = real;
        this.previous = livingSpace;
        if (participant.getType() == ParticipantType.PARTICIPANT) {
            this.headType = ComponentType.PARTICIPANT_HEAD;
            this.tailType = ComponentType.PARTICIPANT_TAIL;
        } else if (participant.getType() == ParticipantType.ACTOR) {
            this.headType = ComponentType.ACTOR_HEAD;
            this.tailType = ComponentType.ACTOR_TAIL;
        } else if (participant.getType() == ParticipantType.BOUNDARY) {
            this.headType = ComponentType.BOUNDARY_HEAD;
            this.tailType = ComponentType.BOUNDARY_TAIL;
        } else if (participant.getType() == ParticipantType.CONTROL) {
            this.headType = ComponentType.CONTROL_HEAD;
            this.tailType = ComponentType.CONTROL_TAIL;
        } else if (participant.getType() == ParticipantType.ENTITY) {
            this.headType = ComponentType.ENTITY_HEAD;
            this.tailType = ComponentType.ENTITY_TAIL;
        } else if (participant.getType() == ParticipantType.DATABASE) {
            this.headType = ComponentType.DATABASE_HEAD;
            this.tailType = ComponentType.DATABASE_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void drawHead(UGraphic uGraphic) {
        Component component = this.skin.createComponent(this.headType, null, this.skinParam, this.p.getDisplay(false));
        Dimension2D dimension2D = component.getPreferredDimension(uGraphic.getStringBounder());
        Area area = new Area(dimension2D);
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    public Dimension2D getHeadPreferredDimension(StringBounder stringBounder) {
        Component component = this.skin.createComponent(this.headType, null, this.skinParam, this.p.getDisplay(false));
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        return this.getHeadPreferredDimension(stringBounder).getWidth();
    }

    public Real getPosC(StringBounder stringBounder) {
        if (this.posC == null) {
            this.posC = this.posB.addFixed(this.getPreferredWidth(stringBounder) / 2.0);
        }
        return this.posC;
    }

    public Real getPosD(StringBounder stringBounder) {
        if (this.posD == null) {
            this.posD = this.posB.addFixed(this.getPreferredWidth(stringBounder));
        }
        return this.posD;
    }

    public Real getPosB() {
        return this.posB;
    }

    public final LivingSpace getNext() {
        return this.next;
    }

    final void setNext(LivingSpace livingSpace) {
        this.next = livingSpace;
    }
}

