const TAG_CONTENT_ATTRIBUTE = "tagContent";

var tag  = window.arguments[0];
var attr = new Array();

function editTagInit() {
	
	var hasContent = false;
	
	// adjust window size
	window.sizeToContent();
	
	// initialize the edit dialog. find all input fields. 
	// the id's of these input fields are the tag attribute names 
	// we can handle. a special tag attribute/input id called "tagContent" is 
	// used for tags which can contain CDATA (like style/script).
	var tagnames = ["textbox", "menulist"];
	for(var i=0; i<tagnames.length; i++) {
		var tags = getByEl(tagnames[i]);
		for(var child=0; child<tags.length; child++) {
			var found = false;
			// make sure we don't have it already
			for(var aix=0; aix<attr.length; aix++) {
				if (attr[i] == tags[child].id) {
					found = true;
					break;
				}
			}
				
			if (!found)
				attr[attr.length] = tags[child].id;
		}
	}
		
	var attrNames = "";
	
	// read tag attributes
	for(var i=0; i<attr.length; i++) {
		var attrName = attr[i];
		var a = null;
		
		attrNames += " " + attrName;
		
		if (attrName == TAG_CONTENT_ATTRIBUTE) {
			hasContent = true;
//			opener.p("we have content");
			continue;
		}
		
		if ( (a = tag.getAttribute(attrName)) ) {
			var input = document.getElementById(attrName);
			opener.p(a);
			if ( input.tagName == "textbox") {
				// handle url picker href input's
				if(attrName == "href") {
					if (document.getElementById(attrName+"Input"))
						document.getElementById(attrName+"Input").value = a
					else 
						input.value = a;
				} else {
					input.value = a;
				}
				
//				opener.p("editTagInit(); textbox");
			} else if (input.tagName == "menulist") {
				if (input.getAttribute("editable")) {
					input.value = a;
//					opener.p("editTagInit(); editable menulist");
				} else {
//					opener.p("editTagInit(); uneditable menulist: " + attrName + ", items: " + input.childNodes.length);
//					opener.p(input.id);
					var options = input.childNodes.item(0).childNodes;
					for(var ii=0; ii<options.length; ii++) {
						if (options.item(ii).value == a) {
							input.selectedIndex = ii;
							break;
						}
					} // end for
				}
			} else {
				alert("editTagInit(); unknown input box type");
			}
		}
	} // end for
	
	// find the tag's content (tags may have content stored in different 
	// locations depending on type and attributes).
	if (hasContent) {
		if (tag.nodeType == COMMENT_NODE) {
			document.getElementById(TAG_CONTENT_ATTRIBUTE).value = tag.nodeValue;
		} else if (tag.firstChild) {
			// remove \r\n in title's source 
			// for display in a one line input field
			if (tag.tagName.toLowerCase() == "title") { 
				// aaa lovely, we can uses regexes in JS, yikes!
				var rExp = /[\r\n]/g;
				document.getElementById(TAG_CONTENT_ATTRIBUTE).value = 
					tag.firstChild.nodeValue.replace(rExp, "");
			} else {
				document.getElementById(TAG_CONTENT_ATTRIBUTE).value = 
					tag.firstChild.nodeValue;
			}
		} else { /* naaa, we don't have content */ }
	}
	
	if (tag.tagName && tag.tagName.toLowerCase() == "meta") {
		tagMetaSelectCommand(getById("name"));
		tagMetaSelectCommand(getById("http-equiv"));
	}
		
	// global startup
	// Startup();
}

function updateTag() {
	// create a new tag with our properties and then replace the existing
	var tag_attr = {};
	var tag_body = null;
	
	// fetch all attributes:
	for(var i=0; i<attr.length; i++) {
		var name  = attr[i];
		//opener.htmlMetaConsole.consoleOut("Fetching attr: " + name);
		
		var el = {};
		var value = null;
		if (name == "href" && document.getElementById(name+"Input"))
			el = document.getElementById(name+"Input");
		else 
			el = document.getElementById(name);
		
		if (!el) {
			alert("no input box found for attribute: " + name);
			continue;
		}
		
		value = getValue(el);
		//opener.htmlMetaConsole.consoleOut(value);
		
		if (value != '')
			if (name == TAG_CONTENT_ATTRIBUTE) {
				tag_body = value;
			} else
				tag_attr[name] = value;
	}
	
	//opener.htmlMetaConsole.consoleOut("Done fetching, updating.");
	if (tag.createNew)
		opener.htmlHeader.insertTag(tag_attr, tag_body);
	else
		opener.htmlHeader.replaceTag(tag_attr, tag_body);
	
	window.close();
}

function getValue(el) {
	if(el.disabled) {
		//alert(el.id + " is disabled.");
		return "";
	}
	
	switch(el.tagName) {
		case "textbox":
			return el.value;
			break;
		case "menulist":
			if(el.value)
				return el.value;
			else
				return el.label;
			break;
		default:
			return "";	
	}
}

function tagMetaSelectCommand(el) {
	var myself = document.getElementById(el.id);
	var other  = document.getElementById((el.id =="name") ? "http-equiv" : "name");
	
	if (myself.label == '') {
		other.disabled = false;
		myself.disabled = false;
	} else {
		other.disabled = true;
		myself.disabled = false;
	}
	
	return true;
}

function removeTag() {
	// reference active tag
	var refTag = opener.htmlHeader.removeTag();
	window.close();
}