/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl
implements NodeList {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMNodeList getInstance() {
        return this.getInstanceAsnsIDOMNodeList();
    }

    protected NodeListImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public NodeListImpl(nsIDOMNodeList mozInst) {
        this((nsISupports)mozInst);
    }

    public static NodeListImpl getDOMInstance(nsIDOMNodeList mozInst) {
        NodeListImpl node = (NodeListImpl)instances.get(mozInst);
        return node == null ? new NodeListImpl(mozInst) : node;
    }

    public nsIDOMNodeList getInstanceAsnsIDOMNodeList() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMNodeList)this.moz.queryInterface("{a6cf907d-15b3-11d2-932e-00805f8add32}");
    }

    public Node item(final int index) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeListImpl.this.getInstanceAsnsIDOMNodeList().item((long)index);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getLength() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                long result = NodeListImpl.this.getInstanceAsnsIDOMNodeList().getLength();
                return (int)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

