/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.DOMConfigurationImpl;
import org.mozilla.dom.DOMImplementationImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.NodeListImpl;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.events.EventImpl;
import org.mozilla.dom.ranges.RangeImpl;
import org.mozilla.dom.traversal.NodeFilterImpl;
import org.mozilla.dom.traversal.NodeIteratorImpl;
import org.mozilla.dom.traversal.TreeWalkerImpl;
import org.mozilla.dom.views.AbstractViewImpl;
import org.mozilla.interfaces.nsIDOM3Document;
import org.mozilla.interfaces.nsIDOMAbstractView;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMCDATASection;
import org.mozilla.interfaces.nsIDOMComment;
import org.mozilla.interfaces.nsIDOMDOMConfiguration;
import org.mozilla.interfaces.nsIDOMDOMImplementation;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentEvent;
import org.mozilla.interfaces.nsIDOMDocumentFragment;
import org.mozilla.interfaces.nsIDOMDocumentRange;
import org.mozilla.interfaces.nsIDOMDocumentTraversal;
import org.mozilla.interfaces.nsIDOMDocumentType;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEntityReference;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeFilter;
import org.mozilla.interfaces.nsIDOMNodeIterator;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMProcessingInstruction;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsIDOMTreeWalker;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class DocumentImpl
extends NodeImpl
implements Document,
DocumentView,
DocumentRange,
DocumentEvent,
DocumentTraversal {
    public nsIDOMDocument getInstance() {
        return this.getInstanceAsnsIDOMDocument();
    }

    public DocumentImpl(nsIDOMDocument mozInst) {
        super((nsIDOMNode)mozInst);
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocument mozInst) {
        DocumentImpl node = (DocumentImpl)instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }

    public nsIDOMDocument getInstanceAsnsIDOMDocument() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDocument)this.moz.queryInterface("{a6cf9075-15b3-11d2-932e-00805f8add32}");
    }

    public Attr createAttribute(final String name) {
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createAttribute(name);
                return (Attr)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node adoptNode(Node source) {
        final nsIDOMNode mozSource = source != null ? ((NodeImpl)source).getInstance() : null;
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = DOM3MozObject.adoptNode(mozSource);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Element createElement(final String tagName) {
        Callable<Element> c = new Callable<Element>(){

            @Override
            public Element call() {
                nsIDOMElement result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createElement(tagName);
                return (Element)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public ProcessingInstruction createProcessingInstruction(final String target, final String data) {
        Callable<ProcessingInstruction> c = new Callable<ProcessingInstruction>(){

            @Override
            public ProcessingInstruction call() {
                nsIDOMProcessingInstruction result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createProcessingInstruction(target, data);
                return (ProcessingInstruction)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DOMConfiguration getDomConfig() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<DOMConfiguration> c = new Callable<DOMConfiguration>(){

            @Override
            public DOMConfiguration call() {
                nsIDOMDOMConfiguration result = DOM3MozObject.getDomConfig();
                return new DOMConfigurationImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Comment createComment(final String data) {
        Callable<Comment> c = new Callable<Comment>(){

            @Override
            public Comment call() {
                nsIDOMComment result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createComment(data);
                return (Comment)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DocumentType getDoctype() {
        Callable<DocumentType> c = new Callable<DocumentType>(){

            @Override
            public DocumentType call() {
                nsIDOMDocumentType result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getDoctype();
                return (DocumentType)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void normalizeDocument() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.normalizeDocument();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public String getInputEncoding() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getInputEncoding();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean getXmlStandalone() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOM3MozObject.getXmlStandalone();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setXmlVersion(final String xmlVersion) {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.setXmlVersion(xmlVersion);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public Node importNode(Node importedNode, final boolean deep) {
        final nsIDOMNode mozImportednode = importedNode != null ? ((NodeImpl)importedNode).getInstance() : null;
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = DocumentImpl.this.getInstanceAsnsIDOMDocument().importNode(mozImportednode, deep);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setDocumentURI(final String documentURI) {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.setDocumentURI(documentURI);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public CDATASection createCDATASection(final String data) {
        Callable<CDATASection> c = new Callable<CDATASection>(){

            @Override
            public CDATASection call() {
                nsIDOMCDATASection result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createCDATASection(data);
                return (CDATASection)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getXmlVersion() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getXmlVersion();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NodeList getElementsByTagName(final String tagname) {
        Callable<NodeList> c = new Callable<NodeList>(){

            @Override
            public NodeList call() {
                nsIDOMNodeList result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getElementsByTagName(tagname);
                return new NodeListImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Element createElementNS(final String namespaceURI, final String qualifiedName) {
        Callable<Element> c = new Callable<Element>(){

            @Override
            public Element call() {
                nsIDOMElement result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createElementNS(namespaceURI, qualifiedName);
                return (Element)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NodeList getElementsByTagNameNS(final String namespaceURI, final String localName) {
        Callable<NodeList> c = new Callable<NodeList>(){

            @Override
            public NodeList call() {
                nsIDOMNodeList result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getElementsByTagNameNS(namespaceURI, localName);
                return new NodeListImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node renameNode(Node n, final String namespaceURI, final String qualifiedName) {
        final nsIDOMNode mozN = n != null ? ((NodeImpl)n).getInstance() : null;
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = DOM3MozObject.renameNode(mozN, namespaceURI, qualifiedName);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public EntityReference createEntityReference(final String name) {
        Callable<EntityReference> c = new Callable<EntityReference>(){

            @Override
            public EntityReference call() {
                nsIDOMEntityReference result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createEntityReference(name);
                return (EntityReference)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setStrictErrorChecking(final boolean strictErrorChecking) {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.setStrictErrorChecking(strictErrorChecking);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public DocumentFragment createDocumentFragment() {
        Callable<DocumentFragment> c = new Callable<DocumentFragment>(){

            @Override
            public DocumentFragment call() {
                nsIDOMDocumentFragment result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createDocumentFragment();
                return (DocumentFragment)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DOMImplementation getImplementation() {
        Callable<DOMImplementation> c = new Callable<DOMImplementation>(){

            @Override
            public DOMImplementation call() {
                nsIDOMDOMImplementation result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getImplementation();
                return new DOMImplementationImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean getStrictErrorChecking() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOM3MozObject.getStrictErrorChecking();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setXmlStandalone(final boolean xmlStandalone) {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Runnable r = new Runnable(){

            public void run() {
                DOM3MozObject.setXmlStandalone(xmlStandalone);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public String getXmlEncoding() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getXmlEncoding();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Element getDocumentElement() {
        Callable<Element> c = new Callable<Element>(){

            @Override
            public Element call() {
                nsIDOMElement result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getDocumentElement();
                return (Element)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Element getElementById(final String elementId) {
        Callable<Element> c = new Callable<Element>(){

            @Override
            public Element call() {
                nsIDOMElement result = DocumentImpl.this.getInstanceAsnsIDOMDocument().getElementById(elementId);
                return (Element)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getDocumentURI() {
        final nsIDOM3Document DOM3MozObject = (nsIDOM3Document)this.getInstance().queryInterface("{2e0e9ea1-72ab-4d9e-bdeb-ca64e1abeba4}");
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = DOM3MozObject.getDocumentURI();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Attr createAttributeNS(final String namespaceURI, final String qualifiedName) {
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createAttributeNS(namespaceURI, qualifiedName);
                return (Attr)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Text createTextNode(final String data) {
        Callable<Text> c = new Callable<Text>(){

            @Override
            public Text call() {
                nsIDOMText result = DocumentImpl.this.getInstanceAsnsIDOMDocument().createTextNode(data);
                return (Text)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DocumentImpl(nsIDOMDocumentView mozInst) {
        super((nsISupports)mozInst);
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocumentView mozInst) {
        DocumentImpl node = (DocumentImpl)instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }

    public nsIDOMDocumentView getInstanceAsnsIDOMDocumentView() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDocumentView)this.moz.queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
    }

    public AbstractView getDefaultView() {
        Callable<AbstractView> c = new Callable<AbstractView>(){

            @Override
            public AbstractView call() {
                nsIDOMAbstractView result = DocumentImpl.this.getInstanceAsnsIDOMDocumentView().getDefaultView();
                return new AbstractViewImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DocumentImpl(nsIDOMDocumentRange mozInst) {
        super((nsISupports)mozInst);
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocumentRange mozInst) {
        DocumentImpl node = (DocumentImpl)instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }

    public nsIDOMDocumentRange getInstanceAsnsIDOMDocumentRange() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDocumentRange)this.moz.queryInterface("{7b9badc6-c9bc-447a-8670-dbd195aed24b}");
    }

    public Range createRange() {
        Callable<Range> c = new Callable<Range>(){

            @Override
            public Range call() {
                nsIDOMRange result = DocumentImpl.this.getInstanceAsnsIDOMDocumentRange().createRange();
                return new RangeImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DocumentImpl(nsIDOMDocumentEvent mozInst) {
        super((nsISupports)mozInst);
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocumentEvent mozInst) {
        DocumentImpl node = (DocumentImpl)instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }

    public nsIDOMDocumentEvent getInstanceAsnsIDOMDocumentEvent() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDocumentEvent)this.moz.queryInterface("{46b91d66-28e2-11d4-ab1e-0010830123b4}");
    }

    public Event createEvent(final String eventType) {
        Callable<Event> c = new Callable<Event>(){

            @Override
            public Event call() {
                nsIDOMEvent result = DocumentImpl.this.getInstanceAsnsIDOMDocumentEvent().createEvent(eventType);
                return new EventImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public DocumentImpl(nsIDOMDocumentTraversal mozInst) {
        super((nsISupports)mozInst);
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocumentTraversal mozInst) {
        DocumentImpl node = (DocumentImpl)instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }

    public nsIDOMDocumentTraversal getInstanceAsnsIDOMDocumentTraversal() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDocumentTraversal)this.moz.queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
    }

    public TreeWalker createTreeWalker(Node root, final int whatToShow, NodeFilter filter, final boolean entityReferenceExpansion) {
        final nsIDOMNode mozRoot = root != null ? ((NodeImpl)root).getInstance() : null;
        final nsIDOMNodeFilter mozFilter = filter != null ? ((NodeFilterImpl)filter).getInstance() : null;
        Callable<TreeWalker> c = new Callable<TreeWalker>(){

            @Override
            public TreeWalker call() {
                nsIDOMTreeWalker result = DocumentImpl.this.getInstanceAsnsIDOMDocumentTraversal().createTreeWalker(mozRoot, (long)whatToShow, mozFilter, entityReferenceExpansion);
                return new TreeWalkerImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NodeIterator createNodeIterator(Node root, final int whatToShow, NodeFilter filter, final boolean entityReferenceExpansion) {
        final nsIDOMNode mozRoot = root != null ? ((NodeImpl)root).getInstance() : null;
        final nsIDOMNodeFilter mozFilter = filter != null ? ((NodeFilterImpl)filter).getInstance() : null;
        Callable<NodeIterator> c = new Callable<NodeIterator>(){

            @Override
            public NodeIterator call() {
                nsIDOMNodeIterator result = DocumentImpl.this.getInstanceAsnsIDOMDocumentTraversal().createNodeIterator(mozRoot, (long)whatToShow, mozFilter, entityReferenceExpansion);
                return new NodeIteratorImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

