/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla.writer;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import org.l10nZilla.Phrase;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.writer.translationsWriter;

public class mozPOWriter
extends translationsWriter {
    private String languageCode;
    private String fileName;
    private OutputStream fout;
    private BufferedOutputStream bout;
    private OutputStreamWriter out;

    public mozPOWriter(String install, String destination) {
        super(install, destination);
        try {
            this.fout = new FileOutputStream(destination);
            this.bout = new BufferedOutputStream(this.fout);
            this.out = new OutputStreamWriter((OutputStream)this.bout, "UTF-8");
            this.out.write("# PO file generated by L10NZilla. \n");
            this.out.write("# Copyright (C) 2001 Free Software Foundation, Inc. \n");
            this.out.write("# Dewi Jones (dewi.jones@gwelywiwr.org)  , 2002 \n");
            this.out.write("msgid \"\"\n");
            this.out.write("msgstr \"\"\n");
            this.out.write("\"Project-Id-Version: PACKAGE VERSION\\n\" \n");
            this.out.write("\"POT-Creation-Date: YEAR-MO-DA HO:MI+ZONE\\n\"\n");
            this.out.write("\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"\n");
            this.out.write("\"Last-Translator: FULL NAME <LL@li.org>\\n\"\n");
            this.out.write("\"Language-Team: LANGUAGE <la@li.org>\\n\"\n");
            this.out.write("\"MIME-Version: 1.0\\n\"\n");
            this.out.write("\"Content-Type: text/plain; charset=utf-8\\n\"\n");
            this.out.write("\"Content-Transfer-Encoding: 8bit\\n\"\n");
        }
        catch (Exception e) {
            System.out.println("Error constructing PO writer");
            System.exit(1);
        }
    }

    public void prepareExportFile() {
    }

    public void exportFile(TranslationFile currentFile) {
        this.fileName = String.valueOf(String.valueOf(currentFile.getFilePath())).concat(String.valueOf(String.valueOf(currentFile.getFileName())));
    }

    public void exportPhrase(Phrase currentPhrase) {
        StringTokenizer sourceLines = null;
        try {
            this.out.write("\r\n");
            this.out.write(String.valueOf(String.valueOf(new StringBuffer("# ").append(currentPhrase.getKey()).append("\n"))));
            this.out.write(String.valueOf(String.valueOf(new StringBuffer("# ").append(this.fileName).append("\r\n"))));
            sourceLines = new StringTokenizer(currentPhrase.getText(), "\n");
            if (sourceLines.hasMoreTokens()) {
                this.out.write(String.valueOf(String.valueOf(new StringBuffer("msgid \"").append(sourceLines.nextToken()).append("\"\n"))));
                while (sourceLines.hasMoreTokens()) {
                    this.out.write(String.valueOf(String.valueOf(new StringBuffer("\"").append(sourceLines.nextToken()).append("\"\n"))));
                }
            } else {
                this.out.write(String.valueOf(String.valueOf(new StringBuffer("msgid \"").append(currentPhrase.getText()).append("\"\n"))));
            }
            if (currentPhrase.getText().equalsIgnoreCase(currentPhrase.getTranslatedText())) {
                this.out.write("msgstr \"\"\n");
            } else {
                this.out.write(String.valueOf(String.valueOf(new StringBuffer("msgstr \"").append(currentPhrase.getTranslatedText()).append("\"\n"))));
            }
        }
        catch (Exception e) {
            System.out.println("Error writing PO entry");
            System.exit(1);
        }
    }

    public void concludeExportFile() {
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            System.out.println("Error closing PO file ");
            System.exit(1);
        }
    }

    public String getTargetLanguageCode() {
        return this.languageCode;
    }

    public void setTargetLanguageCode(String targetLanguage) {
        this.languageCode = targetLanguage;
    }

    public boolean needTranslatorObject() {
        return true;
    }
}

