;;; d-make-faces.el --- My personal font preferences

;; Copyright (C) 2006-2011 Davin Pearson

;; Author/Maintainer: m4_davin_pearson
;; Keywords: Font lock syntax highlighting
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This file contains definitions of fonts that are used in the file
;; d-flock.el.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-make-faces)

;;; Known Bugs:

;; None!

;;; Code:

;;
;; ENSURES THAT CERTAIN FONTS EXIST:
;;
(require 'font-lock)

;;(defun checkpoint (x) (message "*** d-make-faces checkpoint %s" x))

;;(checkpoint 0)

(global-set-key "\C-c\C-l" 'd-fonts)

(defmacro d-quote (&rest ignored))

;;(checkpoint 1)

(defun d-fonts--init-base-colours ()

  (progn
    (make-face 'default)
    (set-face-background 'default bg-colour)
    (if prefs-bg-black-p
        (set-face-foreground 'default "#fff")
      (set-face-foreground 'default "#000"))
    ;;(set-face-background 'default "#ffffff")
    (make-face-unbold 'default)
    )

  (progn
    (make-face 'bold)
    (set-face-background 'bold bg-colour)
    (make-face-bold 'bold))

  (progn
    (make-face 'font-lock-regexp-grouping-backslash)
    (set-face-foreground 'font-lock-regexp-grouping-backslash "#080")
    (set-face-background 'font-lock-regexp-grouping-backslash "#ccf")
    (make-face 'font-lock-regexp-grouping-construct)
    (set-face-foreground 'font-lock-regexp-grouping-construct "#080")
    (set-face-background 'font-lock-regexp-grouping-construct "#ccf")
    )

  (progn ;; BLUE:

    (make-face 'fg:blue)
    (if prefs-bg-black-p
        (set-face-foreground 'fg:blue "#6666ff")
      (set-face-foreground 'fg:blue "#0000ff")
      (make-face-bold 'fg:blue))

    (make-face 'fg:lightblue)
    (set-face-foreground 'fg:lightblue (if prefs-bg-black-p "#77aaff" "#0000ff"))
    (set-face-background 'fg:lightblue bg-colour)
    (if (not prefs-bg-black-p)
        (make-face-bold 'fg:lightblue)))

  (progn ;; BROWN:

    (make-face 'bg:brown)
    (set-face-background 'bg:brown "#aa7755")
    (set-face-foreground 'bg:brown bg-colour)
    (make-face 'fg:brown)
    (make-face-bold 'fg:brown)
    (set-face-foreground 'fg:brown "#aa7755"))

  (progn ;; CYAN:

    (make-face 'fg:cyan)
    (make-face-bold 'fg:cyan)
    (set-face-foreground 'fg:cyan "dark cyan")

    (make-face 'fg:lightcyan)
    (make-face-bold 'fg:lightcyan)
    (if prefs-bg-black-p
        (set-face-foreground 'fg:lightcyan "#0ff")
      (set-face-foreground 'fg:lightcyan "#0aa"))
    (set-face-background 'fg:lightcyan bg-colour)
    (setq fg:lightcyan 'fg:lightcyan)

    (make-face 'fg:cyan)
    (make-face 'bg:cyan)
    (set-face-background 'bg:cyan "dark cyan")
    (set-face-foreground 'bg:cyan bg-colour))

  (progn ;; GRAY:

    (make-face 'fg:darkgray)
    (set-face-foreground 'fg:darkgray "#888")

    (make-face 'bg:lightgray)
    (set-face-background 'bg:lightgray "#ccc")
    (set-face-foreground 'bg:lightgray "black")

    (make-face 'fg:lightgray)
    (if prefs-bg-black-p
        (progn
          (set-face-foreground 'fg:lightgray "#ccc")
          ;;(set-face-foreground
          )
      (progn
        (set-face-foreground 'fg:lightgray "#888")
        (set-face-background 'fg:lightgray bg-colour-lighter)))
    )

  (progn ;; GREEN:

    (make-face 'fg:green)
    (make-face-bold 'fg:green)
    (if prefs-bg-black-p
        (set-face-foreground 'fg:green "#0b0")
      (set-face-foreground 'fg:green "#0b0"))

    (make-face 'bg:green)
    (set-face-background 'bg:green "#00cc00")
    (set-face-foreground 'bg:green bg-colour)

    (make-face 'bg:lightgreen)
    (set-face-background 'bg:lightgreen "lightgreen")
    (set-face-foreground 'bg:lightgreen "black")

    (make-face 'fg:lightgreen)
    (if prefs-bg-black-p
        (set-face-foreground 'fg:lightgreen "#0d4")
      (set-face-foreground 'fg:lightgreen "#5c5"))
    (if (not prefs-bg-black-p)
        (make-face-bold 'fg:lightgreen))
    )

  (progn
    (make-face 'd-checkpoint-face)
    (set-face-foreground 'd-checkpoint-face "#c0c")
    (set-face-background 'd-checkpoint-face "#fff")
    (make-face-bold 'd-checkpoint-face))

  (progn
    (make-face 'd-debug-face)
    (set-face-foreground 'd-debug-face "#f00")
    (set-face-background 'd-debug-face "#fff")
    (make-face-bold 'd-debug-face))

  (progn ;; ORANGE:
    (make-face 'fg:orange)
    (make-face-bold 'fg:orange)
    (set-face-foreground 'fg:orange "#f80"))

  (progn ;; MAGENTA:
    (make-face 'fg:magenta)
    (make-face-bold 'fg:magenta)
    (set-face-foreground 'fg:magenta "magenta")

    (make-face 'bg:magenta)
    (set-face-background 'bg:magenta "magenta")
    (set-face-foreground 'bg:magenta bg-colour)

    (make-face 'fg:lightmagenta)
    (make-face-bold 'fg:lightmagenta)
    (set-face-foreground 'fg:lightmagenta "magenta")

    ;;
    ;; TODO: sdfasdfadfdf
    ;;
    (progn
      (make-face 'bg:lightmagenta)
      (make-face-bold 'bg:lightmagenta)
      (set-face-background 'bg:lightmagenta "magenta")
      (set-face-foreground 'bg:lightmagenta "white"))
    )

  (progn ;; RED:

    (make-face 'fg:red)
    (make-face-bold 'fg:red)
    (set-face-foreground 'fg:red "red")

    (make-face 'bg:red)
    (if prefs-bg-black-p
        (progn
          (set-face-background 'bg:red "#e00")
          (set-face-foreground 'bg:red bg-colour))
      (set-face-background 'bg:red "#f44")
      (set-face-foreground 'bg:red "#fff"))

    (progn
      (make-face 'fg:lightred)
      (set-face-foreground 'fg:lightred "#f33")
      ;;(set-face-background 'fg:lightred bg-colour)
      (if (not prefs-bg-black-p)
          (make-face-bold 'fg:lightred)))

    (progn
      (make-face 'bg:lightred)
      (set-face-foreground 'bg:lightred (if prefs-bg-black-p "black" "white"))
      (set-face-background 'bg:lightred "red"))

    )

  (progn ;; WHITE:

    (make-face 'fg:white)
    (make-face-bold 'fg:white)
    (if prefs-bg-black-p
        (progn
          (set-face-foreground 'fg:white "white")
          )
      (progn
        (set-face-foreground 'fg:white "black")
        ;;(set-face-background 'fg:white bg-colour-lighter)
        )))

  (progn ;; YELLOW:

    (make-face 'fg:yellow)
    (make-face-bold 'fg:yellow)
    (if prefs-bg-black-p
        (progn
          (set-face-foreground 'fg:yellow "yellow")
          (set-face-background 'fg:yellow bg-colour))
      (progn
        (set-face-foreground 'fg:yellow "yellow")
        (set-face-background 'fg:yellow "black")))

    (progn
      (make-face 'bg:yellow)
      (set-face-background 'bg:yellow "yellow")
      (set-face-foreground 'bg:yellow "black")
      (make-face-bold 'bg:yellow)))

  )

;;(checkpoint 2)

(defun d-fonts--init-pairs ()

  (progn
    (make-face 'd-face-blue-and-white)
    (set-face-foreground 'd-face-blue-and-white (if prefs-bg-black-p "white" "white"))
    (set-face-background 'd-face-blue-and-white
                         (cond
                          (prefs-bg-black-p "#44c")
                          (prefs-lcd-emacs-p "#aaf")
                          (t "#8888ff")))
    )

  (make-face 'd-face-red-and-white)
  (set-face-foreground 'd-face-red-and-white (if prefs-bg-black-p "white" "white"))
  (set-face-background 'd-face-red-and-white
                       (cond
                        (prefs-bg-black-p "red")
                        (prefs-lcd-emacs-p "#f00")
                        (t "#f00")))

  (make-face 'd-face-red-and-yellow)
  (set-face-foreground 'd-face-red-and-yellow "#ff0")
  (set-face-background 'd-face-red-and-yellow "#e00")

  (progn
    (make-face 'd-face-green-and-black)
    (set-face-foreground 'd-face-green-and-black (if prefs-bg-black-p "white" "black"))
    (set-face-background 'd-face-green-and-black (if prefs-bg-black-p "#080" "#8f8")))

  (progn
    (make-face 'd-face-green-and-yellow)
    (make-face-bold 'd-face-green-and-yellow)
    (set-face-background 'd-face-green-and-yellow (if prefs-bg-black-p "#080" "#8f8"))
    (set-face-foreground 'd-face-green-and-yellow (if prefs-bg-black-p "#ff0" "#000000"))
    )

  )

;;(checkpoint 3)

(defun d-fonts--init-d--faces ()

  (progn
    (copy-face 'fg:lightred 'd-face-link)
    (set-face-underline-p 'd-face-link t))

  (progn
    (copy-face 'fg:lightblue 'd-face-line)
    (set-face-underline-p 'd-face-line t))

  (progn
    (if prefs-bg-black-p
        (copy-face 'fg:cyan 'd-face-html-entity)
      (make-face 'd-face-html-entity))
    (make-face-bold 'd-face-html-entity)
    (if (not prefs-bg-black-p)
        (set-face-foreground 'd-face-html-entity "#f00")))

  (progn
    (make-face 'd-face-cc-global)
    (set-face-foreground 'd-face-cc-global "#0c0")
    (set-face-background 'd-face-cc-global bg-colour)
    (make-face-bold 'd-face-cc-global)
    ) ;; *cool-man*

  (progn
    (make-face 'd-face-el-d-stuff)
    (make-face-bold 'd-face-el-d-stuff)
    (set-face-foreground 'd-face-el-d-stuff (if prefs-bg-black-p "#cccc88" "#2244cc"))
    (copy-face 'fg:lightblue 'd-face-el-d-stuff2)
    (make-face-bold 'd-face-el-d-stuff2)
    )

  (progn
    (make-face 'd-face-lisp++-keywords)
    (set-face-background 'd-face-lisp++-keywords "#8f8")
    (set-face-foreground 'd-face-lisp++-keywords "#000000")
    (make-face-bold 'd-face-lisp++-keywords))

  (d-quote 123)

  (copy-face 'fg:lightgreen 'd-face-el-quote)
  ;;(set-face-background 'd-face-el-quote "#0ff")
  ;;(set-face-foreground 'd-face-el-quote "#f00")

  (progn
    (make-face 'd-face-property)
    (make-face-bold 'd-face-property)
    (set-face-foreground 'd-face-property "#f90")

    (make-face 'd-face-property-inverse)
    (make-face-bold 'd-face-property-inverse)
    (set-face-background 'd-face-property-inverse "#f90")
    (set-face-foreground 'd-face-property-inverse "#fff"))

  ;; oridinary comment appears in font-lock-comment-face
  ;;; super comment    appears in d-face-super-comment
  (progn
    (make-face 'd-face-super-comment)
    (set-face-foreground 'd-face-super-comment (if prefs-bg-black-p "#0f0" "#f00"))
    (set-face-background 'd-face-super-comment bg-colour)
    (when (not prefs-bg-black-p)
      (make-face-bold 'd-face-super-comment)
      (make-face-italic 'd-face-super-comment)
      )
    (copy-face 'd-face-super-comment 'font-lock-doc-face)
    (copy-face 'd-face-super-comment 'font-lock-doc-string-face)
    )

  (progn
    ;; MY CPLUSPLUS FACES:
    (make-face 'd-face-cc-clib)
    (make-face-bold 'd-face-cc-clib)
    (set-face-foreground 'd-face-cc-clib (if prefs-bg-black-p "#a88" "#844"))
    (copy-face 'd-face-cc-clib 'd-face-cc-allegro)
    (copy-face 'd-face-cc-clib 'd-face-cc-libd)
    (copy-face 'd-face-cc-clib 'd-face-cc-opengl)

    (make-face 'd-face-cc-ctor-dtor)
    (set-face-foreground 'd-face-cc-ctor-dtor (if prefs-bg-black-p "#f44" "#f0f"))
    (make-face-bold 'd-face-cc-ctor-dtor)

    (progn
      (make-face 'd-face-cc-debugging)
      (set-face-background 'd-face-cc-debugging "green")
      (make-face-bold 'd-face-cc-debugging))

    (progn
      (make-face 'd-face-cc-private)
      (make-face-bold 'd-face-cc-private)
      (set-face-foreground 'd-face-cc-private "black")
      ;;(set-face-background 'd-face-cc-private "#fcc")
      (set-face-background 'd-face-cc-private "#ffbbbb")
      )
    )

  (make-face 'd-face-m4-dnl)
  (set-face-background 'd-face-m4-dnl (if prefs-bg-black-p "#aa7755" "#fc9"))
  (set-face-foreground 'd-face-m4-dnl "black")

  (progn
    (make-face 'd-face-special-reference)
    (make-face-bold 'd-face-special-reference)
    (if prefs-bg-black-p
        (progn
          (set-face-foreground 'd-face-special-reference "#fff")
          (set-face-background 'd-face-special-reference "#666"))
      (progn
        (set-face-foreground 'd-face-special-reference "black")
        (set-face-background 'd-face-special-reference bg-colour-lighter))))

  (if (not (and os-type--mswindows-p emacs-dialect--gnuemacs-p))
      (make-face-bold 'd-face-special-reference))

  (copy-face 'bg:lightmagenta 'd-face-makefile-space)
  (make-face 'd-face-makefile-tab)
  (set-face-background 'd-face-makefile-tab "#cfc")
  (copy-face 'd-face-red-and-white 'd-face-linefeed)

  (copy-face 'bg:red 'd-face-m4)
  (set-face-background 'd-face-m4 (if prefs-bg-black-p "#f00" "#faa"))

  (make-face 'd-face-m5)
  (set-face-background 'd-face-m5 "lightgreen")
  (set-face-foreground 'd-face-m5 "black")

  (make-face 'd-face-m6)
  (set-face-background 'd-face-m6 "#ccf")
  (set-face-foreground 'd-face-m6 "black")

  (if prefs-bg-black-p
      (set-face-foreground 'd-face-m4 "#000000")
    (set-face-foreground 'd-face-m4 "#000000"))

  (progn
    (make-face 'd-face-cc-illegal-type)
    (make-face-bold 'd-face-cc-illegal-type)
    (set-face-foreground 'd-face-cc-illegal-type "red")
    (set-face-background 'd-face-cc-illegal-type "#0ff")
    (copy-face 'd-face-cc-illegal-type 'd-face-cc-searching)
    )

  (progn
    (make-face 'd-face-makefile-dollar-dollar)
    (set-face-background 'd-face-makefile-dollar-dollar (if prefs-bg-black-p "#090" "#8f8"))
    (set-face-foreground 'd-face-makefile-dollar-dollar (if prefs-bg-black-p "#fff" "#000000"))
    (copy-face 'd-face-makefile-dollar-dollar 'd-face-makefile-dollar-dollar-highlight)
    (make-face-bold 'd-face-makefile-dollar-dollar-highlight)
    ;;(make-face 'd-face-makefile-dollar-dollar-highlight)
    ;;(set-face-background 'd-face-makefile-dollar-dollar-highlight (if prefs-bg-black-p "#8b0" "#8f8"))
    ;;(set-face-foreground 'd-face-makefile-dollar-dollar-highlight (if prefs-bg-black-p "#ff0" "#fff"))
    )

  (progn
    (make-face 'mmm-default-submode-face)
    (set-face-foreground 'mmm-default-submode-face nil)
    ;;(set-face-foreground 'mmm-default-submode-face "#fff")
    (set-face-background 'mmm-default-submode-face nil)
    (make-face-bold 'mmm-default-submode-face)
    ;;(make-face-unbold 'mmm-default-submode-face)
    )

  (progn
    (copy-face 'd-face-cc-illegal-type 'd-face-cc-digits)
    (set-face-background 'd-face-cc-digits bg-colour)

    (if prefs-bg-black-p
        (progn
          (set-face-background 'd-face-cc-digits "#666")
          (set-face-foreground 'd-face-cc-digits "#fff")
          )
      ;;(set-face-foreground 'd-face-cc-digits "#000000")
      ;;(set-face-background 'd-face-cc-digits "#e8d4ff")
      (set-face-background 'd-face-cc-digits bg-colour)
      (set-face-foreground 'd-face-cc-digits "#f0f"))

    )
  )

;;(checkpoint 4)

;; (d-fonts--init-standard-font-lock)
(defun d-fonts--init-standard-font-lock ()

  (progn
    ;;
    ;; NOTE: Version 22 bindings
    ;;
    (make-face 'mode-line-buffer-id)
    (make-face 'tabbar-default-face)
    (set-face-foreground 'tabbar-default-face "#000000")
    (set-face-background 'tabbar-default-face "#eee")
    )

  (progn
    (make-face 'underline)
    (set-face-underline-p 'underline t))

  (progn
    (make-face 'bold-underline)
    (make-face-bold 'bold-underline)
    (set-face-underline-p 'bold-underline t))
;;
;;  (progn
;;    (make-face 'bold-italic)
;;    (make-face-bold 'bold-italic)
;;    (make-face-italic 'bold-italic))
;;
  ;;(set-face-foreground 'italic "#0af")
  ;;(set-face-foreground 'bold "#dd0")
  ;;(copy-face 'fg:lightcyan             'bold-italic)

  ;;(copy-face 'bg:lightmagenta          'highlight)

  (copy-face 'fg:lightcyan             'font-lock-type-face)
  (copy-face 'd-face-blue-and-white    'font-lock-string-face)
  (setq font-lock-string-face          'font-lock-string-face)
  (make-face-bold 'font-lock-string-face)
  ;;(set-face-background 'font-lock-string-face (if prefs-bg-black-p "#0000ff"  "#dedeff"))

  (progn
    (set-face-foreground 'font-lock-type-face (if prefs-bg-black-p "#00ffff" "#0000ff"))
    (make-face-bold 'font-lock-type-face)
    (set-face-foreground 'font-lock-variable-name-face (if prefs-bg-black-p "#009999" "#0011ff")))

  (progn
    (make-face 'font-lock-comment-face)
    ;;(set-face-background 'font-lock-comment-face bg-colour)
    (set-face-foreground 'font-lock-comment-face
                         (cond
                          (prefs-bg-black-p  "#080")
                          (prefs-lcd-emacs-p "#888")
                          (t "#060")))
    (when (not prefs-bg-black-p)
      (make-face-unbold 'font-lock-comment-face)
      (make-face-italic 'font-lock-comment-face)
      ;;(set-face-attribute 'font-lock-comment-face nil '((:slant . italic) (:weight bold)))
      ))

  ;;
  ;; comment
  ;;
  (progn
    (make-face 'font-lock-keyword-face)
    (if prefs-bg-black-p
        (progn
          (copy-face 'fg:lightred 'font-lock-keyword-face)
          ;;(set-face-foreground 'font-lock-keyword-face "white")
          ))
    (set-face-foreground 'font-lock-keyword-face "#000")
    (make-face-bold 'font-lock-keyword-face)
    )

  (if prefs-bg-black-p
      (copy-face 'fg:white 'font-lock-reference-face)
    (copy-face 'fg:lightgray 'font-lock-reference-face))

  (set-face-background 'font-lock-reference-face bg-colour-lighter)

  (progn
    (if prefs-bg-black-p
        (copy-face 'fg:yellow 'font-lock-function-name-face)
      (copy-face 'bg:yellow 'font-lock-function-name-face))
    (make-face-bold 'font-lock-function-name-face))

  (if prefs-bg-black-p
      (copy-face 'bg:green 'show-paren-match-face)
    (copy-face 'd-face-cc-illegal-type 'show-paren-match-face)
    (set-face-foreground 'show-paren-match-face "#000")
    )
  (if emacs-dialect--xemacs-p (copy-face 'show-paren-match-face 'paren-match))

  (set-face-underline-p 'font-lock-reference-face t)

  (progn
    (make-face 'font-lock-builtin-face)
    (make-face-bold 'font-lock-builtin-face)
    (set-face-foreground 'font-lock-builtin-face "#f00")
    ;;(set-face-background 'font-lock-builtin-face "#0f0")
    ;;(set-face-background 'font-lock-builtin-face bg-colour-lighter)
    )

  (progn
    (make-face 'font-lock-constant-face)
    (make-face-bold 'font-lock-constant-face)

    (if (not prefs-bg-black-p)
        (set-face-foreground 'font-lock-constant-face "#f00"))

    (d-quote (if prefs-bg-black-p
               (set-face-background 'font-lock-constant-face "#000000")
             (progn
               (set-face-foreground 'font-lock-constant-face "black")
               (set-face-background 'font-lock-constant-face bg-colour-lighter)))))

  (progn
    (make-face 'highlight)
    (set-face-foreground 'highlight "#fff")
    (set-face-background 'highlight "#88f"))

  (progn
    (make-face 'region)
    (set-face-foreground 'region "#fff")
    (set-face-background 'region (if prefs-bg-black-p "#f4a" "#f8a")))

  (progn
    (make-face 'font-lock-warning-face)
    (set-face-foreground 'font-lock-warning-face "red")
    ;;(set-face-background 'font-lock-warning-face bg-colour-lighter)
    (make-face-bold 'font-lock-warning-face))

  (if (not (and os-type--mswindows-p emacs-dialect--gnuemacs-p))
      (make-face-bold 'font-lock-warning-face))

  (make-face 'secondary-selection)
  (set-face-foreground 'secondary-selection "lightgreen")
  (copy-face 'd-face-cc-searching 'secondary-selection)

  (copy-face 'bg:lightmagenta 'info-menu-5)
  (copy-face 'fg:lightcyan 'info-node)

  (copy-face 'bold 'info-xref)
  (set-face-underline-p 'info-xref t)
  (set-face-foreground 'info-xref "#00f")1

  (copy-face 'region                   'd-face-cc-searching)
  (copy-face 'fg:darkgray              'dired-face-permissions)
  (set-face-background                 'dired-face-permissions bg-colour-lighter)
  (copy-face 'fg:white                 'modeline-buffer-id)

  (copy-face 'bold 'dired-symlink)

  (progn
    (copy-face 'd-face-blue-and-white 'dired-marked)
    (make-face-bold 'dired-marked)
    (copy-face 'd-face-red-and-white  'dired-flagged)
    (set-face-background 'dired-flagged "#ff6677")
    (make-face-bold 'dired-flagged)

    (copy-face 'fg:lightblue          'dired-directory)
    (make-face-bold 'dired-directory)
    (set-face-background 'dired-directory bg-colour)
    (set-face-foreground 'dired-directory "#4433ff")
    (copy-face 'fg:green              'd-face-path)
    )

  (copy-face 'd-face-blue-and-white      'dired-face-marked)
  (copy-face 'd-face-red-and-white       'dired-face-flagged)
  (copy-face 'region                     'zmacs-region)
  (copy-face 'region                     'primary-selection)
  (copy-face 'font-lock-reference-face   'font-lock-preprocessor-face)
  (copy-face 'fg:lightgray               'modeline-mousable)
  (copy-face 'fg:red                     'modeline-mousable-minor-mode)

  (copy-face (if prefs-bg-black-p 'fg:lightred 'fg:lightblue) 'diary-face)

  (when emacs-dialect--xemacs-p
    (set-face-foreground 'blue       "#88f")
    (copy-face 'fg:lightblue         'hyper-apropos-hyperlink)
    (copy-face 'fg:lightred          'hyper-apropos-documentation)
    (copy-face 'fg:lightblue         'custom-group-tag-face)
    (copy-face 'fg:darkgray          'dired-face-boring)
    (set-face-foreground             'dired-face-boring "#888")
    (copy-face 'fg:lightgray         'dired-face-permissions)
    (set-face-foreground             'dired-face-permissions "#999")
    (copy-face 'fg:lightcyan         'dired-face-symlink)
    ;;(copy-face 'd-face-green-and-yellow 'isearch)
    (copy-face 'd-face-green-and-white 'isearch-secondary)
    (copy-face 'bg:lightgray         'modeline-buffer-id)
    ;;(copy-face 'bg:lightgray 'widget-button-face)
    )

  (progn
    (make-face 'isearch-lazy-highlight-face)
    (set-face-foreground 'isearch-lazy-highlight-face "#000000")
    (set-face-background 'isearch-lazy-highlight-face "#0ff"))

  (copy-face 'd-face-blue-and-white  'secondary-selection)

  (progn
    (set-face-background 'isearch "#000000")
    (set-face-foreground 'isearch "#ff0000")
    (make-face-bold 'isearch))

  (progn
    (make-face 'dired-directory)
    (make-face-bold 'dired-directory)
    (set-face-foreground 'dired-directory "#00f"))

  )

;;(checkpoint 5)

(safe-require 'dired-colours)
(setq prefs-bg-black-p nil)

(defun d-fonts ()
  (interactive)

  ;;(checkpoint 7)

  (setq prefs-bg-black-p (not prefs-bg-black-p))

  (setq bg-colour (if prefs-bg-black-p
                      (if (string= user-login-name "root") "#ff8888" "#262626")
                    (if (string= user-login-name "root") "#ffdddd" "#fff")))

  ;;(setq bg-colour "#ffffff")

  (setq bg-colour-lighter (if prefs-bg-black-p "#444" "#eee"))
  (setq bg-colour-lighter-lighter (if prefs-bg-black-p "#555" "#ddd"))

  (if (not emacs-dialect--xemacs-p) (set-background-color bg-colour))

  (setq cursor-colour (if prefs-bg-black-p "#ffff00" "#88cc88"))
  (setq cursor-colour (if prefs-bg-black-p "#ffff00" "#000000"))
  ;;(setq cursor-colour "#ff0000")
  ;;
  (when (not emacs-dialect--xemacs-p)
    (make-face 'cursor)
    (set-face-background 'cursor cursor-colour)
    (set-face-foreground 'cursor "black"))

  (if emacs-dialect--xemacs-p
      (progn
        (make-face 'text-cursor)
        (set-face-background 'text-cursor cursor-colour)
        (set-face-foreground 'text-cursor "#000000")))


  ;; (copy-face 'fg:yellow 'border)
  ;;(set-face-foreground 'default "black")
  (set-face-foreground 'default (if prefs-bg-black-p  "lightgray" "black"))

  (if (string= (user-real-login-name) "root")
      (set-face-background 'default "#660000")
    (set-face-background 'default bg-colour))
  ;;(set-face-background 'default "#ffffff")

  (make-face 'modeline)
  (set-face-background 'modeline "grey")
  (set-face-foreground 'modeline "black")

  (progn
    (make-face-italic 'bold-italic)
    (make-face-italic 'italic)
    (set-face-underline-p 'italic nil)
    )

  ;;(checkpoint 8)
  (d-fonts--init-base-colours)
  ;;(checkpoint 10)
  (d-fonts--init-pairs)
  ;;(checkpoint 11)
  (d-fonts--init-d--faces)
  ;;(checkpoint 12)
  (d-fonts--init-standard-font-lock)
  ;;(checkpoint 13)

  (progn
    (if (fboundp 'd-fonts--init-dired-colours)
        (d-fonts--init-dired-colours)))

  (setq font-lock-maximum-size nil)
  (setq font-lock-maximum-decoration t)

  ;; get graphics characters online...
  (if (and (< emacs-major-version 20) (not emacs-dialect--xemacs-p))
      (let ((i 127))
        (while (< i 256)
          (aset standard-display-table i (vector i))
          (incf i))))

  ;;(checkpoint 14)

  (balance-windows)
  ;;(recenter)

  (if (and os-type--mswindows-p emacs-dialect--gnuemacs-p)
      (set-cursor-color cursor-colour))

  ;;(checkpoint 15)

  )

;;(checkpoint 6)

(setq prefs-bg-black-p t)

(d-fonts)

(provide 'd-make-faces)
;;; d-make-faces.el ends here
